/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.filepicker.filter;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.github.gzuliyujiang.dialog.DialogLog;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;

public class SimpleFilter
implements FileFilter {
    private final boolean isOnlyDir;
    private final String[] allowExtensions;

    public SimpleFilter(boolean isOnlyDir, @Nullable String[] allowExtensions) {
        this.isOnlyDir = isOnlyDir;
        this.allowExtensions = allowExtensions;
    }

    @Override
    public boolean accept(File pathname) {
        if (pathname == null) {
            DialogLog.print((Object)"Filter>>>pathname is null");
            return false;
        }
        if (pathname.isDirectory()) {
            DialogLog.print((Object)("Filter>>>pathname is directory: " + pathname));
            return true;
        }
        if (this.isOnlyDir && pathname.isFile()) {
            DialogLog.print((Object)("Filter>>>except directory but is file: " + pathname));
            return false;
        }
        if (this.allowExtensions == null || this.allowExtensions.length == 0) {
            DialogLog.print((Object)("Filter>>>allow extensions is empty: " + pathname));
            return true;
        }
        String extension = this.getExtension(pathname.getPath());
        DialogLog.print((Object)("Filter>>>extension of " + pathname + ": " + extension));
        boolean contains = false;
        for (String allowExtension : this.allowExtensions) {
            if (!TextUtils.isEmpty((CharSequence)allowExtension) && !allowExtension.contains(extension)) continue;
            contains = true;
            break;
        }
        DialogLog.print((Object)("Filter>>>allow extensions is " + Arrays.toString(this.allowExtensions) + ", contains: " + contains));
        return contains;
    }

    private String getExtension(String path) {
        int dotPos;
        if (path == null) {
            return "";
        }
        String ext = "";
        int slashPos = path.lastIndexOf(File.separator);
        if (slashPos != -1) {
            path = path.substring(slashPos);
        }
        ext = (dotPos = path.lastIndexOf(46)) != -1 ? path.substring(dotPos + 1) : path;
        return ext;
    }
}

