/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.filepicker.filter;

import androidx.annotation.Nullable;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;

public class SimpleFilter
implements FileFilter {
    private final boolean isOnlyDir;
    private final String[] allowExtensions;

    public SimpleFilter(boolean isOnlyDir, @Nullable String[] allowExtensions) {
        this.isOnlyDir = isOnlyDir;
        this.allowExtensions = allowExtensions;
    }

    @Override
    public boolean accept(File pathname) {
        if (pathname == null) {
            return false;
        }
        if (this.isOnlyDir && pathname.isFile()) {
            return false;
        }
        if (this.allowExtensions == null || this.allowExtensions.length == 0) {
            return true;
        }
        String extension = this.getExtension(pathname.getPath());
        return Arrays.toString(this.allowExtensions).contains(extension);
    }

    private String getExtension(String path) {
        int dotPos;
        if (path == null) {
            return "";
        }
        int slashPos = path.lastIndexOf(File.separator);
        if (slashPos != -1) {
            path = path.substring(slashPos);
        }
        if (0 <= (dotPos = path.lastIndexOf(46))) {
            return path.substring(dotPos + 1);
        }
        return "";
    }
}

