/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.filepicker.adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.github.gzuliyujiang.dialog.DialogLog;
import com.github.gzuliyujiang.filepicker.R;
import com.github.gzuliyujiang.filepicker.adapter.FileEntity;
import com.github.gzuliyujiang.filepicker.adapter.ViewHolder;
import com.github.gzuliyujiang.filepicker.contract.OnPathClickedListener;
import com.github.gzuliyujiang.filepicker.filter.SimpleFilter;
import com.github.gzuliyujiang.filepicker.sort.SortByExtension;
import com.github.gzuliyujiang.filepicker.sort.SortByName;
import com.github.gzuliyujiang.filepicker.sort.SortBySize;
import com.github.gzuliyujiang.filepicker.sort.SortByTime;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FileAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private final Context context;
    public static final String DIR_ROOT = ".";
    public static final String DIR_PARENT = "..";
    private final List<FileEntity> data = new ArrayList<FileEntity>();
    private File rootDir = null;
    private File currentFile = null;
    private String[] allowExtensions = null;
    private boolean onlyListDir = false;
    private boolean showHomeDir = true;
    private boolean showUpDir = true;
    private boolean showHideDir = true;
    private int fileSort = 0;
    private int itemHeight = 40;
    private Drawable homeIcon;
    private Drawable upIcon;
    private Drawable folderIcon;
    private Drawable fileIcon;
    private OnPathClickedListener onPathClickedListener;

    public FileAdapter(@NonNull Context context) {
        this.context = context;
        this.homeIcon = ContextCompat.getDrawable((Context)context, (int)R.mipmap.file_picker_home);
        this.upIcon = ContextCompat.getDrawable((Context)context, (int)R.mipmap.file_picker_up);
        this.folderIcon = ContextCompat.getDrawable((Context)context, (int)R.mipmap.file_picker_folder);
        this.fileIcon = ContextCompat.getDrawable((Context)context, (int)R.mipmap.file_picker_file);
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        LinearLayout layout2 = new LinearLayout(this.context);
        layout2.setOrientation(0);
        layout2.setGravity(16);
        int height = (int)((float)this.itemHeight * this.context.getResources().getDisplayMetrics().density);
        int matchParent = -1;
        layout2.setLayoutParams(new ViewGroup.LayoutParams(matchParent, height));
        int padding = (int)(5.0f * this.context.getResources().getDisplayMetrics().density);
        layout2.setPadding(padding, padding, padding, padding);
        ImageView imageView = new ImageView(this.context);
        int size = (int)(20.0f * this.context.getResources().getDisplayMetrics().density);
        imageView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(size, size));
        imageView.setScaleType(ImageView.ScaleType.FIT_XY);
        imageView.setImageResource(17301579);
        layout2.addView((View)imageView);
        TextView textView = new TextView(this.context);
        LinearLayout.LayoutParams tvParams = new LinearLayout.LayoutParams(matchParent, matchParent);
        tvParams.leftMargin = (int)(10.0f * this.context.getResources().getDisplayMetrics().density);
        textView.setLayoutParams((ViewGroup.LayoutParams)tvParams);
        textView.setGravity(8388627);
        textView.setSingleLine();
        layout2.addView((View)textView);
        ViewHolder viewHolder = new ViewHolder((View)layout2);
        viewHolder.textView = textView;
        viewHolder.imageView = imageView;
        return viewHolder;
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        final int adapterPosition = holder.getAdapterPosition();
        final FileEntity item = this.getItem(adapterPosition);
        holder.imageView.setImageDrawable(item.getIcon());
        holder.textView.setText((CharSequence)item.getName());
        if (this.onPathClickedListener == null) {
            return;
        }
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FileAdapter.this.onPathClickedListener.onPathClicked(FileAdapter.this, adapterPosition, item.getFile().getAbsolutePath());
            }
        });
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemCount() {
        return this.data.size();
    }

    public void setItemHeight(@Dimension(unit=0) int itemHeight) {
        this.itemHeight = itemHeight;
    }

    public void setFileIcon(Drawable fileIcon) {
        if (fileIcon == null) {
            return;
        }
        this.fileIcon = fileIcon;
    }

    public void setFolderIcon(Drawable folderIcon) {
        if (folderIcon == null) {
            return;
        }
        this.folderIcon = folderIcon;
    }

    public void setHomeIcon(Drawable homeIcon) {
        if (homeIcon == null) {
            return;
        }
        this.homeIcon = homeIcon;
    }

    public void setUpIcon(Drawable upIcon) {
        if (upIcon == null) {
            return;
        }
        this.upIcon = upIcon;
    }

    public void setAllowExtensions(String[] allowExtensions) {
        if (this.allowExtensions != null && Arrays.equals(this.allowExtensions, allowExtensions)) {
            return;
        }
        this.allowExtensions = allowExtensions;
    }

    public void setOnlyListDir(boolean onlyListDir) {
        if (this.onlyListDir == onlyListDir) {
            return;
        }
        this.onlyListDir = onlyListDir;
    }

    public boolean isOnlyListDir() {
        return this.onlyListDir;
    }

    public void setShowHomeDir(boolean showHomeDir) {
        if (this.showHomeDir == showHomeDir) {
            return;
        }
        this.showHomeDir = showHomeDir;
    }

    public boolean isShowHomeDir() {
        return this.showHomeDir;
    }

    public void setShowUpDir(boolean showUpDir) {
        if (this.showUpDir == showUpDir) {
            return;
        }
        this.showUpDir = showUpDir;
    }

    public boolean isShowUpDir() {
        return this.showUpDir;
    }

    public void setShowHideDir(boolean showHideDir) {
        if (this.showHideDir == showHideDir) {
            return;
        }
        this.showHideDir = showHideDir;
    }

    public boolean isShowHideDir() {
        return this.showHideDir;
    }

    public int getFileSort() {
        return this.fileSort;
    }

    public void setFileSort(int fileSort) {
        if (this.fileSort == fileSort) {
            return;
        }
        this.fileSort = fileSort;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public void refreshData() {
        this.loadData(this.currentFile);
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    public void loadData(File dir) {
        if (dir == null) {
            DialogLog.print((Object)"current directory is null");
            return;
        }
        ArrayList<FileEntity> entities = new ArrayList<FileEntity>();
        if (this.rootDir == null) {
            this.rootDir = dir;
        }
        DialogLog.print((Object)("current directory path: " + dir));
        this.currentFile = dir;
        if (this.showHomeDir) {
            FileEntity root = new FileEntity();
            root.setIcon(this.homeIcon);
            root.setName(DIR_ROOT);
            root.setFile(this.rootDir);
            entities.add(root);
        }
        if (this.showUpDir && !File.separator.equals(dir.getAbsolutePath())) {
            FileEntity parent = new FileEntity();
            parent.setIcon(this.upIcon);
            parent.setName(DIR_PARENT);
            parent.setFile(dir.getParentFile());
            entities.add(parent);
        }
        List<File> files = this.listFiles(this.currentFile, new SimpleFilter(this.onlyListDir, this.allowExtensions));
        this.sortFiles(files, this.fileSort);
        for (File file : files) {
            if (!this.showHideDir && file.getName().startsWith(DIR_ROOT)) continue;
            FileEntity FileEntity2 = new FileEntity();
            if (file.isDirectory()) {
                FileEntity2.setIcon(this.folderIcon);
            } else {
                FileEntity2.setIcon(this.fileIcon);
            }
            FileEntity2.setName(file.getName());
            FileEntity2.setFile(file);
            entities.add(FileEntity2);
        }
        this.data.clear();
        this.data.addAll(entities);
        this.notifyDataSetChanged();
    }

    public final void recycleData() {
        Bitmap fileBitmap;
        Bitmap folderBitmap;
        Bitmap upBitmap;
        Bitmap homeBitmap;
        this.data.clear();
        if (this.homeIcon instanceof BitmapDrawable && null != (homeBitmap = ((BitmapDrawable)this.homeIcon).getBitmap()) && !homeBitmap.isRecycled()) {
            homeBitmap.recycle();
        }
        if (this.upIcon instanceof BitmapDrawable && null != (upBitmap = ((BitmapDrawable)this.upIcon).getBitmap()) && !upBitmap.isRecycled()) {
            upBitmap.recycle();
        }
        if (this.folderIcon instanceof BitmapDrawable && null != (folderBitmap = ((BitmapDrawable)this.folderIcon).getBitmap()) && !folderBitmap.isRecycled()) {
            folderBitmap.recycle();
        }
        if (this.fileIcon instanceof BitmapDrawable && null != (fileBitmap = ((BitmapDrawable)this.fileIcon).getBitmap()) && !fileBitmap.isRecycled()) {
            fileBitmap.recycle();
        }
    }

    public void setOnPathClickedListener(OnPathClickedListener listener) {
        this.onPathClickedListener = listener;
    }

    public FileEntity getItem(int position) {
        return this.data.get(position);
    }

    private List<File> listFiles(File startDir, FileFilter fileFilter) {
        DialogLog.print((Object)String.format("list dir %s", startDir));
        if (!startDir.isDirectory()) {
            return new ArrayList<File>();
        }
        File[] dirs = startDir.listFiles(fileFilter);
        if (dirs == null) {
            return new ArrayList<File>();
        }
        return Arrays.asList(dirs);
    }

    private void sortFiles(List<File> files, int sort) {
        switch (sort) {
            case 0: {
                Collections.sort(files, new SortByName());
                break;
            }
            case 1: {
                Collections.sort(files, new SortByName());
                Collections.reverse(files);
                break;
            }
            case 2: {
                Collections.sort(files, new SortByTime());
                break;
            }
            case 3: {
                Collections.sort(files, new SortByTime());
                Collections.reverse(files);
                break;
            }
            case 4: {
                Collections.sort(files, new SortBySize());
                break;
            }
            case 5: {
                Collections.sort(files, new SortBySize());
                Collections.reverse(files);
                break;
            }
            case 6: {
                Collections.sort(files, new SortByExtension());
                break;
            }
            case 7: {
                Collections.sort(files, new SortByExtension());
                Collections.reverse(files);
            }
        }
    }
}

