/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.filepicker.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.github.gzuliyujiang.filepicker.R;
import com.github.gzuliyujiang.filepicker.adapter.ViewHolder;
import com.github.gzuliyujiang.filepicker.contract.OnPathClickedListener;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;

public class PathAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private static final String ROOT_HINT = "ROOT";
    private final Context context;
    private final LinkedList<String> paths = new LinkedList();
    private Drawable arrowIcon = null;
    private OnPathClickedListener onPathClickedListener;

    public PathAdapter(@NonNull Context context) {
        this.context = context;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        int wrapContent = -2;
        LinearLayout layout2 = new LinearLayout(this.context);
        layout2.setOrientation(0);
        layout2.setGravity(16);
        layout2.setLayoutParams(new ViewGroup.LayoutParams(wrapContent, wrapContent));
        TextView textView = new TextView(this.context);
        LinearLayout.LayoutParams tvParams = new LinearLayout.LayoutParams(wrapContent, wrapContent);
        textView.setLayoutParams((ViewGroup.LayoutParams)tvParams);
        textView.setGravity(8388627);
        int padding = (int)(5.0f * this.context.getResources().getDisplayMetrics().density);
        textView.setPadding(padding, 0, padding, 0);
        layout2.addView((View)textView);
        ImageView imageView = new ImageView(this.context);
        int width = (int)(20.0f * this.context.getResources().getDisplayMetrics().density);
        imageView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(width, wrapContent));
        layout2.addView((View)imageView);
        ViewHolder viewHolder = new ViewHolder((View)layout2);
        viewHolder.textView = textView;
        viewHolder.imageView = imageView;
        return viewHolder;
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, final int position) {
        holder.textView.setText((CharSequence)this.paths.get(position));
        holder.imageView.setImageDrawable(this.arrowIcon);
        if (this.onPathClickedListener == null) {
            return;
        }
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PathAdapter.this.onPathClickedListener.onPathClicked(position, PathAdapter.this.getPath(position));
            }
        });
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemCount() {
        return this.paths.size();
    }

    public void setArrowIcon(Drawable arrowIcon) {
        this.arrowIcon = arrowIcon;
    }

    public void updatePath(File file) {
        if (this.arrowIcon == null) {
            this.arrowIcon = ContextCompat.getDrawable((Context)this.context, (int)R.mipmap.file_picker_arrow);
        }
        this.paths.clear();
        String path = file.getAbsolutePath();
        if (!File.separator.equals(path)) {
            Collections.addAll(this.paths, path.substring(path.indexOf(File.separator) + 1).split(File.separator));
        }
        this.paths.addFirst(ROOT_HINT);
        this.notifyDataSetChanged();
    }

    public String getPath(int position) {
        StringBuilder sb = new StringBuilder(File.separator);
        if (position == 0) {
            return sb.toString();
        }
        for (int i = 1; i <= position; ++i) {
            sb.append(this.paths.get(i)).append(File.separator);
        }
        return sb.toString();
    }

    public final void recycleData() {
        Bitmap homeBitmap;
        this.paths.clear();
        if (this.arrowIcon instanceof BitmapDrawable && null != (homeBitmap = ((BitmapDrawable)this.arrowIcon).getBitmap()) && !homeBitmap.isRecycled()) {
            homeBitmap.recycle();
        }
    }

    public void setOnPathClickedListener(OnPathClickedListener listener) {
        this.onPathClickedListener = listener;
    }
}

