/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.util;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import cn.qqtheme.framework.util.FileUtils;
import cn.qqtheme.framework.util.LogUtils;
import java.io.File;
import java.io.IOException;

public final class StorageUtils {
    public static boolean externalMounted() {
        String state = Environment.getExternalStorageState();
        if (state.equals("mounted")) {
            return true;
        }
        LogUtils.warn((String)"external storage unmounted");
        return false;
    }

    public static String getInternalRootPath(Context context, String type) {
        File file;
        if (TextUtils.isEmpty((CharSequence)type)) {
            file = context.getFilesDir();
        } else {
            file = new File(FileUtils.separator(context.getFilesDir().getAbsolutePath()) + type);
            file.mkdirs();
        }
        String path = "";
        if (file != null) {
            path = FileUtils.separator(file.getAbsolutePath());
        }
        LogUtils.verbose((String)("internal storage root path: " + path));
        return path;
    }

    public static String getInternalRootPath(Context context) {
        return StorageUtils.getInternalRootPath(context, null);
    }

    public static String getExternalRootPath(String type) {
        File file = null;
        if (StorageUtils.externalMounted()) {
            file = Environment.getExternalStorageDirectory();
        }
        if (file != null && !TextUtils.isEmpty((CharSequence)type)) {
            file = new File(file, type);
            file.mkdirs();
        }
        String path = "";
        if (file != null) {
            path = FileUtils.separator(file.getAbsolutePath());
        }
        LogUtils.verbose((String)("external storage root path: " + path));
        return path;
    }

    public static String getExternalRootPath() {
        return StorageUtils.getExternalRootPath(null);
    }

    public static String getExternalPrivatePath(Context context, String type) {
        File file = null;
        if (StorageUtils.externalMounted()) {
            file = context.getExternalFilesDir(type);
        }
        String path = "";
        if (file != null) {
            path = FileUtils.separator(file.getAbsolutePath());
        }
        LogUtils.verbose((String)("external storage private path: " + path));
        return path;
    }

    public static String getExternalPrivatePath(Context context) {
        return StorageUtils.getExternalPrivatePath(context, null);
    }

    public static String getDownloadPath() throws RuntimeException {
        if (!StorageUtils.externalMounted()) {
            throw new RuntimeException("\u5916\u7f6e\u5b58\u50a8\u4e0d\u53ef\u7528\uff01");
        }
        File file = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
        return FileUtils.separator(file.getAbsolutePath());
    }

    public static String getCachePath(Context context, String type) {
        File file = StorageUtils.externalMounted() ? context.getExternalCacheDir() : context.getCacheDir();
        if (!TextUtils.isEmpty((CharSequence)type)) {
            file = new File(file, type);
            file.mkdirs();
        }
        String path = "";
        if (file != null) {
            path = FileUtils.separator(file.getAbsolutePath());
        }
        LogUtils.verbose((String)("external or internal storage cache path: " + path));
        return path;
    }

    public static String getCachePath(Context context) {
        return StorageUtils.getCachePath(context, null);
    }

    public static String getTempDirPath(Context context) {
        return StorageUtils.getExternalPrivatePath(context, "temporary");
    }

    public static String getTempFilePath(Context context) {
        try {
            return File.createTempFile("lyj_", ".tmp", context.getCacheDir()).getAbsolutePath();
        }
        catch (IOException e) {
            return StorageUtils.getTempDirPath(context) + "lyj.tmp";
        }
    }
}

