/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import cn.qqtheme.framework.drawable.StateColorDrawable;
import cn.qqtheme.framework.entity.FileItem;
import cn.qqtheme.framework.util.AssetsUtils;
import cn.qqtheme.framework.util.CompatUtils;
import cn.qqtheme.framework.util.ConvertUtils;
import cn.qqtheme.framework.util.FileUtils;
import cn.qqtheme.framework.util.LogUtils;
import java.io.File;
import java.util.ArrayList;

public class FileAdapter
extends BaseAdapter {
    public static final String DIR_ROOT = "..";
    public static final String DIR_PARENT = "";
    private static final int MATCH_PARENT = -1;
    private static final int WRAP_CONTENT = -2;
    private Context context;
    private ArrayList<FileItem> data = new ArrayList();
    private String rootPath = null;
    private String currentPath = null;
    private String[] allowExtensions = null;
    private boolean onlyListDir = false;
    private boolean showHomeDir = false;
    private boolean showUpDir = true;
    private boolean showHideDir = true;
    private int itemHeight = 40;
    private Drawable homeIcon = null;
    private Drawable upIcon = null;
    private Drawable folderIcon = null;
    private Drawable fileIcon = null;

    public FileAdapter(Context context) {
        this.context = context;
        this.homeIcon = ConvertUtils.toDrawable((Bitmap)AssetsUtils.readBitmap((Context)context, (String)"file_picker_home.png"));
        this.upIcon = ConvertUtils.toDrawable((Bitmap)AssetsUtils.readBitmap((Context)context, (String)"file_picker_updir.png"));
        this.folderIcon = ConvertUtils.toDrawable((Bitmap)AssetsUtils.readBitmap((Context)context, (String)"file_picker_folder.png"));
        this.fileIcon = ConvertUtils.toDrawable((Bitmap)AssetsUtils.readBitmap((Context)context, (String)"file_picker_file.png"));
    }

    public String getCurrentPath() {
        return this.currentPath;
    }

    public void setAllowExtensions(String[] allowExtensions) {
        this.allowExtensions = allowExtensions;
    }

    public void setOnlyListDir(boolean onlyListDir) {
        this.onlyListDir = onlyListDir;
    }

    public void setShowHomeDir(boolean showHomeDir) {
        this.showHomeDir = showHomeDir;
    }

    public void setShowUpDir(boolean showUpDir) {
        this.showUpDir = showUpDir;
    }

    public void setShowHideDir(boolean showHideDir) {
        this.showHideDir = showHideDir;
    }

    public void setItemHeight(int itemHeight) {
        this.itemHeight = itemHeight;
    }

    public void loadData(String path) {
        if (path == null) {
            LogUtils.warn((String)"current directory is null");
            return;
        }
        ArrayList<FileItem> datas = new ArrayList<FileItem>();
        if (this.rootPath == null) {
            this.rootPath = path;
        }
        LogUtils.verbose((String)("current directory path: " + path));
        this.currentPath = path;
        if (this.showHomeDir) {
            FileItem fileRoot = new FileItem();
            fileRoot.setDirectory(true);
            fileRoot.setIcon(this.homeIcon);
            fileRoot.setName(DIR_ROOT);
            fileRoot.setSize(0L);
            fileRoot.setPath(this.rootPath);
            datas.add(fileRoot);
        }
        if (this.showUpDir && !path.equals("/")) {
            FileItem fileParent = new FileItem();
            fileParent.setDirectory(true);
            fileParent.setIcon(this.upIcon);
            fileParent.setName(DIR_PARENT);
            fileParent.setSize(0L);
            fileParent.setPath(new File(path).getParent());
            datas.add(fileParent);
        }
        File[] files = this.allowExtensions == null ? (this.onlyListDir ? FileUtils.listDirs(this.currentPath) : FileUtils.listDirsAndFiles(this.currentPath)) : (this.onlyListDir ? FileUtils.listDirs(this.currentPath, this.allowExtensions) : FileUtils.listDirsAndFiles(this.currentPath, this.allowExtensions));
        if (files != null) {
            for (File file : files) {
                if (!this.showHideDir && file.getName().startsWith(".")) continue;
                FileItem fileItem = new FileItem();
                boolean isDirectory = file.isDirectory();
                fileItem.setDirectory(isDirectory);
                if (isDirectory) {
                    fileItem.setIcon(this.folderIcon);
                    fileItem.setSize(0L);
                } else {
                    fileItem.setIcon(this.fileIcon);
                    fileItem.setSize(file.length());
                }
                fileItem.setName(file.getName());
                fileItem.setPath(file.getAbsolutePath());
                datas.add(fileItem);
            }
        }
        this.data.clear();
        this.data.addAll(datas);
        this.notifyDataSetChanged();
    }

    public void recycleData() {
        Bitmap fileBitmap;
        Bitmap folderBitmap;
        Bitmap upBitmap;
        Bitmap homeBitmap;
        this.data.clear();
        if (this.homeIcon instanceof BitmapDrawable && null != (homeBitmap = ((BitmapDrawable)this.homeIcon).getBitmap()) && !homeBitmap.isRecycled()) {
            homeBitmap.recycle();
        }
        if (this.upIcon instanceof BitmapDrawable && null != (upBitmap = ((BitmapDrawable)this.upIcon).getBitmap()) && !upBitmap.isRecycled()) {
            upBitmap.recycle();
        }
        if (this.folderIcon instanceof BitmapDrawable && null != (folderBitmap = ((BitmapDrawable)this.folderIcon).getBitmap()) && !folderBitmap.isRecycled()) {
            folderBitmap.recycle();
        }
        if (this.fileIcon instanceof BitmapDrawable && null != (fileBitmap = ((BitmapDrawable)this.fileIcon).getBitmap()) && !fileBitmap.isRecycled()) {
            fileBitmap.recycle();
        }
    }

    public int getCount() {
        return this.data.size();
    }

    public FileItem getItem(int position) {
        return this.data.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            LinearLayout layout = new LinearLayout(this.context);
            CompatUtils.setBackground((View)layout, (Drawable)new StateColorDrawable(-1, -3355444));
            layout.setOrientation(0);
            layout.setGravity(16);
            int height = ConvertUtils.toPx((Context)this.context, (float)this.itemHeight);
            layout.setLayoutParams(new ViewGroup.LayoutParams(-1, height));
            int padding = ConvertUtils.toPx((Context)this.context, (float)5.0f);
            layout.setPadding(padding, padding, padding, padding);
            ImageView imageView = new ImageView(this.context);
            int wh = ConvertUtils.toPx((Context)this.context, (float)30.0f);
            imageView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(wh, wh));
            imageView.setImageResource(17301579);
            layout.addView((View)imageView);
            TextView textView = new TextView(this.context);
            LinearLayout.LayoutParams tvParams = new LinearLayout.LayoutParams(-1, -1);
            tvParams.leftMargin = ConvertUtils.toPx((Context)this.context, (float)10.0f);
            textView.setLayoutParams((ViewGroup.LayoutParams)tvParams);
            textView.setGravity(8388627);
            layout.addView((View)textView);
            convertView = layout;
            holder = new ViewHolder();
            holder.imageView = imageView;
            holder.textView = textView;
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        FileItem item = this.data.get(position);
        holder.imageView.setImageDrawable(item.getIcon());
        holder.textView.setText((CharSequence)item.getName());
        return convertView;
    }

    private class ViewHolder {
        ImageView imageView;
        TextView textView;

        private ViewHolder() {
        }
    }
}

