/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.basepicker;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.CallSuper;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import com.github.gzuliyujiang.basepicker.PickerLog;
import com.github.gzuliyujiang.basepicker.R;

public abstract class BottomDialog
extends Dialog
implements DialogInterface.OnShowListener,
DialogInterface.OnDismissListener {
    public static final int MATCH_PARENT = -1;
    public static final int WRAP_CONTENT = -2;
    protected Activity activity;
    protected View contentView;
    protected View maskView;

    public BottomDialog(@NonNull Activity activity) {
        super((Context)activity, R.style.PickerTheme);
        this.init(activity);
    }

    public BottomDialog(@NonNull Activity activity, @StyleRes int themeResId) {
        super((Context)activity, themeResId);
        this.init(activity);
    }

    private void init(Activity activity) {
        this.activity = activity;
        this.onInit((Context)activity);
        PickerLog.print("dialog onInit");
        this.setOwnerActivity(activity);
        this.setCanceledOnTouchOutside(false);
        this.setCancelable(false);
        super.setOnShowListener((DialogInterface.OnShowListener)this);
        super.setOnDismissListener((DialogInterface.OnDismissListener)this);
        Window window = super.getWindow();
        if (window != null) {
            window.requestFeature(1);
            window.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            window.setLayout(activity.getResources().getDisplayMetrics().widthPixels, -2);
            window.setGravity(17);
            window.getDecorView().setPadding(0, 0, 0, 0);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            super.create();
        } else {
            this.readyView();
        }
    }

    protected void onInit(@NonNull Context context) {
    }

    protected final void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        PickerLog.print("dialog onCreate");
        if (this.contentView == null) {
            this.readyView();
        }
    }

    private void readyView() {
        this.contentView = this.createContentView(this.activity);
        this.contentView.setFocusable(true);
        this.contentView.setFocusableInTouchMode(true);
        this.setContentView(this.contentView);
        if (this.enableMaskView()) {
            this.addMaskView();
        }
        this.setCancelable(true);
        this.setCanceledOnTouchOutside(true);
        this.setWidth(this.activity.getResources().getDisplayMetrics().widthPixels);
        this.setGravity(80);
        this.initView(this.contentView);
    }

    @NonNull
    protected abstract View createContentView(@NonNull Activity var1);

    @CallSuper
    protected void initView(@NonNull View contentView) {
        PickerLog.print("dialog initView");
    }

    protected boolean enableMaskView() {
        return true;
    }

    private void addMaskView() {
        try {
            this.setDimAmount(0.0f);
            WindowManager.LayoutParams params = new WindowManager.LayoutParams();
            params.width = -1;
            Point screenRealSize = new Point();
            this.activity.getWindowManager().getDefaultDisplay().getRealSize(screenRealSize);
            int navBarIdentifier = this.activity.getResources().getIdentifier("navigation_bar_height", "dimen", "android");
            params.height = screenRealSize.y - this.activity.getResources().getDimensionPixelSize(navBarIdentifier);
            params.gravity = 48;
            if (Build.VERSION.SDK_INT >= 28) {
                params.layoutInDisplayCutoutMode = 1;
            }
            params.systemUiVisibility = 1280;
            if (Build.VERSION.SDK_INT >= 21) {
                params.flags = Integer.MIN_VALUE;
            }
            params.type = 1000;
            params.format = -3;
            params.token = this.activity.getWindow().getDecorView().getWindowToken();
            this.maskView = new View((Context)this.activity);
            this.maskView.setBackgroundColor(0x7F000000);
            this.maskView.setFitsSystemWindows(false);
            this.maskView.setOnKeyListener(new View.OnKeyListener(){

                public boolean onKey(View view, int keyCode, KeyEvent event) {
                    if (keyCode == 4) {
                        BottomDialog.this.dismiss();
                        return true;
                    }
                    return false;
                }
            });
            this.activity.getWindowManager().addView(this.maskView, (ViewGroup.LayoutParams)params);
            PickerLog.print("dialog add mask view");
        }
        catch (Exception e) {
            PickerLog.print(e);
        }
    }

    public final Activity getActivity() {
        return this.activity;
    }

    public final View getContentView() {
        return this.contentView;
    }

    public final void enableRoundCorner() {
        this.setBackgroundResource(R.drawable.picker_corner_bg);
    }

    public final void setBackground(Drawable background) {
        if (this.contentView == null) {
            return;
        }
        this.contentView.setBackground(background);
    }

    public final void setBackgroundColor(boolean round, @ColorInt int color) {
        if (this.contentView == null) {
            return;
        }
        if (!round) {
            this.contentView.setBackgroundColor(color);
            return;
        }
        float radiusInPX = this.contentView.getResources().getDisplayMetrics().density * 25.0f;
        float[] outerR = new float[]{radiusInPX, radiusInPX, radiusInPX, radiusInPX, 0.0f, 0.0f, 0.0f, 0.0f};
        ShapeDrawable drawable2 = new ShapeDrawable((Shape)new RoundRectShape(outerR, null, null));
        Paint paint = drawable2.getPaint();
        paint.setAntiAlias(true);
        paint.setColor(color);
        paint.setStyle(Paint.Style.FILL);
        this.contentView.setBackground((Drawable)drawable2);
    }

    public final void setBackgroundColor(@ColorInt int color) {
        if (this.contentView == null) {
            return;
        }
        this.contentView.setBackgroundColor(color);
    }

    public final void setBackgroundResource(@DrawableRes int resId) {
        if (this.contentView == null) {
            return;
        }
        this.contentView.setBackgroundResource(resId);
    }

    public final void setLayout(int width, int height) {
        this.getWindow().setLayout(width, height);
    }

    public final void setWidth(int width) {
        this.getWindow().setLayout(width, this.getWindow().getAttributes().height);
    }

    public final void setHeight(int height) {
        this.getWindow().setLayout(this.getWindow().getAttributes().width, height);
    }

    public final void setGravity(int gravity) {
        this.getWindow().setGravity(gravity);
    }

    public final void setDimAmount(@FloatRange(from=0.0, to=1.0) float amount) {
        this.getWindow().setDimAmount(amount);
    }

    public final void setAnimationStyle(@StyleRes int animRes) {
        this.getWindow().setWindowAnimations(animRes);
    }

    public void setOnShowListener(final @Nullable DialogInterface.OnShowListener listener) {
        if (listener == null) {
            return;
        }
        final BottomDialog current = this;
        super.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface dialog) {
                current.onShow(dialog);
                listener.onShow(dialog);
            }
        });
    }

    public void setOnDismissListener(final @Nullable DialogInterface.OnDismissListener listener) {
        if (listener == null) {
            return;
        }
        final BottomDialog current = this;
        super.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                current.onDismiss(dialog);
                listener.onDismiss(dialog);
            }
        });
    }

    @CallSuper
    public void show() {
        if (this.isShowing()) {
            return;
        }
        try {
            super.show();
            PickerLog.print("dialog show");
        }
        catch (Exception e) {
            PickerLog.print(e);
        }
    }

    @CallSuper
    public void dismiss() {
        if (!this.isShowing()) {
            return;
        }
        try {
            super.dismiss();
            PickerLog.print("dialog dismiss");
        }
        catch (Exception e) {
            PickerLog.print(e);
        }
    }

    @CallSuper
    public void onAttachedToWindow() {
        PickerLog.print("dialog attached to window");
        super.onAttachedToWindow();
        this.initData();
    }

    @CallSuper
    protected void initData() {
        PickerLog.print("dialog initData");
    }

    @CallSuper
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        PickerLog.print("dialog detached from window");
    }

    @CallSuper
    public void onShow(DialogInterface dialog) {
        PickerLog.print("dialog onShow");
    }

    @CallSuper
    public void onDismiss(DialogInterface dialog) {
        PickerLog.print("dialog onDismiss");
        this.removeMaskView();
    }

    private void removeMaskView() {
        if (this.maskView == null) {
            return;
        }
        try {
            this.activity.getWindowManager().removeViewImmediate(this.maskView);
            PickerLog.print("dialog remove mask view");
        }
        catch (Exception e) {
            PickerLog.print(e);
        }
    }
}

