/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.util;

import android.annotation.TargetApi;
import android.content.ContentUris;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.view.View;
import android.widget.ListView;
import android.widget.ScrollView;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import cn.qqtheme.framework.util.LogUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class ConvertUtils {
    public static final long GB = 0x40000000L;
    public static final long MB = 0x100000L;
    public static final long KB = 1024L;

    public static int toInt(Object obj) {
        try {
            return Integer.parseInt(obj.toString());
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static int toInt(byte[] bytes) {
        int result = 0;
        for (int i = 0; i < bytes.length; ++i) {
            byte abyte = bytes[i];
            result += (abyte & 0xFF) << 8 * i;
        }
        return result;
    }

    public static int toShort(byte first, byte second) {
        return (first << 8) + (second & 0xFF);
    }

    public static long toLong(Object obj) {
        try {
            return Long.parseLong(obj.toString());
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public static float toFloat(Object obj) {
        try {
            return Float.parseFloat(obj.toString());
        }
        catch (NumberFormatException e) {
            return -1.0f;
        }
    }

    public static byte[] toByteArray(int i) {
        return ByteBuffer.allocate(4).putInt(i).array();
    }

    public static byte[] toByteArray(String hexData, boolean isHex) {
        if (hexData == null || hexData.equals("")) {
            return null;
        }
        if (!isHex) {
            return hexData.getBytes();
        }
        hexData = hexData.replaceAll("\\s+", "");
        String hexDigits = "0123456789ABCDEF";
        ByteArrayOutputStream baos = new ByteArrayOutputStream(hexData.length() / 2);
        for (int i = 0; i < hexData.length(); i += 2) {
            baos.write(hexDigits.indexOf(hexData.charAt(i)) << 4 | hexDigits.indexOf(hexData.charAt(i + 1)));
        }
        byte[] bytes = baos.toByteArray();
        try {
            baos.close();
        }
        catch (IOException e) {
            LogUtils.warn(e);
        }
        return bytes;
    }

    public static String toHexString(String str) {
        byte[] bytes;
        if (TextUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (byte aByte : bytes = str.getBytes()) {
            builder.append(Integer.toHexString(0xFF & aByte));
            builder.append(" ");
        }
        return builder.toString();
    }

    public static String toHexString(byte ... bytes) {
        char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] buffer = new char[bytes.length * 2];
        int j = 0;
        for (int i = 0; i < bytes.length; ++i) {
            int u = bytes[i] < 0 ? bytes[i] + 256 : bytes[i];
            buffer[j++] = DIGITS[u >>> 4];
            buffer[j++] = DIGITS[u & 0xF];
        }
        return new String(buffer);
    }

    public static String toHexString(int num) {
        String hexString = Integer.toHexString(num);
        LogUtils.verbose(String.format(Locale.CHINA, "%d to hex string is %s", num, hexString));
        return hexString;
    }

    public static String toBinaryString(byte ... bytes) {
        char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] buffer = new char[bytes.length * 8];
        int j = 0;
        for (int i = 0; i < bytes.length; ++i) {
            int u = bytes[i] < 0 ? bytes[i] + 256 : bytes[i];
            buffer[j++] = DIGITS[u >>> 7 & 1];
            buffer[j++] = DIGITS[u >>> 6 & 1];
            buffer[j++] = DIGITS[u >>> 5 & 1];
            buffer[j++] = DIGITS[u >>> 4 & 1];
            buffer[j++] = DIGITS[u >>> 3 & 1];
            buffer[j++] = DIGITS[u >>> 2 & 1];
            buffer[j++] = DIGITS[u >>> 1 & 1];
            buffer[j++] = DIGITS[u & 1];
        }
        return new String(buffer);
    }

    public static String toBinaryString(int num) {
        String binaryString = Integer.toBinaryString(num);
        LogUtils.verbose(String.format(Locale.CHINA, "%d to binary string is %s", num, binaryString));
        return binaryString;
    }

    public static String toSlashString(String str) {
        char[] chars;
        String result = "";
        for (char chr : chars = str.toCharArray()) {
            if (chr == '\"' || chr == '\'' || chr == '\\') {
                result = result + "\\";
            }
            result = result + chr;
        }
        return result;
    }

    public static <T> T[] toArray(List<T> list) {
        return list.toArray();
    }

    public static <T> List<T> toList(T[] array) {
        return Arrays.asList(array);
    }

    public static String toString(Object[] objects) {
        return Arrays.deepToString(objects);
    }

    public static String toString(Object[] objects, String tag) {
        StringBuilder sb = new StringBuilder();
        for (Object object : objects) {
            sb.append(object);
            sb.append(tag);
        }
        return sb.toString();
    }

    public static byte[] toByteArray(InputStream is) {
        if (is == null) {
            return null;
        }
        try {
            int len;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buff = new byte[100];
            while ((len = is.read(buff, 0, 100)) != -1) {
                os.write(buff, 0, len);
            }
            byte[] bytes = os.toByteArray();
            os.close();
            is.close();
            return bytes;
        }
        catch (IOException e) {
            LogUtils.warn(e);
            return null;
        }
    }

    public static byte[] toByteArray(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)os);
        byte[] bytes = os.toByteArray();
        try {
            os.close();
        }
        catch (IOException e) {
            LogUtils.warn(e);
        }
        return bytes;
    }

    public static Bitmap toBitmap(byte[] bytes, int width, int height) {
        Bitmap bitmap = null;
        if (bytes.length != 0) {
            try {
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inDither = false;
                options.inPreferredConfig = null;
                if (width > 0 && height > 0) {
                    options.outWidth = width;
                    options.outHeight = height;
                }
                bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
                bitmap.setDensity(96);
            }
            catch (Exception e) {
                LogUtils.error(e);
            }
        }
        return bitmap;
    }

    public static Bitmap toBitmap(byte[] bytes) {
        return ConvertUtils.toBitmap(bytes, -1, -1);
    }

    public static Bitmap toBitmap(Drawable drawable) {
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        if (drawable instanceof ColorDrawable) {
            Bitmap bitmap = Bitmap.createBitmap((int)32, (int)32, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            canvas.drawColor(((ColorDrawable)drawable).getColor());
            return bitmap;
        }
        if (drawable instanceof NinePatchDrawable) {
            Bitmap bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
            drawable.draw(canvas);
            return bitmap;
        }
        return null;
    }

    @TargetApi(value=19)
    public static String toPath(Context context, Uri uri) {
        boolean isKitKat;
        if (uri == null) {
            LogUtils.verbose("uri is null");
            return "";
        }
        LogUtils.verbose("uri: " + uri.toString());
        String path = uri.getPath();
        String scheme = uri.getScheme();
        String authority = uri.getAuthority();
        boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
        if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            String docId = DocumentsContract.getDocumentId((Uri)uri);
            String[] split = docId.split(":");
            String type = split[0];
            Uri contentUri = null;
            switch (authority) {
                case "com.android.externalstorage.documents": {
                    if (!"primary".equalsIgnoreCase(type)) break;
                    return Environment.getExternalStorageDirectory() + "/" + split[1];
                }
                case "com.android.providers.downloads.documents": {
                    contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(docId));
                    return ConvertUtils._queryPathFromMediaStore(context, contentUri, null, null);
                }
                case "com.android.providers.media.documents": {
                    if ("image".equals(type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(type)) {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(type)) {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return ConvertUtils._queryPathFromMediaStore(context, contentUri, selection, selectionArgs);
                }
            }
        } else {
            if ("content".equalsIgnoreCase(scheme)) {
                if (authority.equals("com.google.android.apps.photos.content")) {
                    return uri.getLastPathSegment();
                }
                return ConvertUtils._queryPathFromMediaStore(context, uri, null, null);
            }
            if ("file".equalsIgnoreCase(scheme)) {
                return uri.getPath();
            }
        }
        LogUtils.verbose("uri to path: " + path);
        return path;
    }

    private static String _queryPathFromMediaStore(Context context, Uri uri, String selection, String[] selectionArgs) {
        String filePath = null;
        try {
            String[] projection = new String[]{"_data"};
            Cursor cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null) {
                int column_index = cursor.getColumnIndexOrThrow("_data");
                cursor.moveToFirst();
                filePath = cursor.getString(column_index);
                cursor.close();
            }
        }
        catch (IllegalArgumentException e) {
            LogUtils.error(e);
        }
        return filePath;
    }

    public static Bitmap toBitmap(View view) {
        int i;
        int width = view.getWidth();
        int height = view.getHeight();
        if (view instanceof ListView) {
            height = 0;
            ListView listView = (ListView)view;
            for (i = 0; i < listView.getChildCount(); ++i) {
                height += listView.getChildAt(i).getHeight();
            }
        } else if (view instanceof ScrollView) {
            height = 0;
            ScrollView scrollView = (ScrollView)view;
            for (i = 0; i < scrollView.getChildCount(); ++i) {
                height += scrollView.getChildAt(i).getHeight();
            }
        }
        view.setDrawingCacheEnabled(true);
        view.clearFocus();
        view.setPressed(false);
        boolean willNotCache = view.willNotCacheDrawing();
        view.setWillNotCacheDrawing(false);
        int color = view.getDrawingCacheBackgroundColor();
        view.setDrawingCacheBackgroundColor(-1);
        if (color != -1) {
            view.destroyDrawingCache();
        }
        view.buildDrawingCache();
        Bitmap cacheBitmap = view.getDrawingCache();
        if (cacheBitmap == null) {
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawBitmap(cacheBitmap, 0.0f, 0.0f, null);
        canvas.save();
        canvas.restore();
        if (!bitmap.isRecycled()) {
            LogUtils.verbose("recycle bitmap: " + bitmap.toString());
            bitmap.recycle();
        }
        view.destroyDrawingCache();
        view.setWillNotCacheDrawing(willNotCache);
        view.setDrawingCacheBackgroundColor(color);
        return bitmap;
    }

    public static Drawable toDrawable(Bitmap bitmap) {
        return bitmap == null ? null : new BitmapDrawable(Resources.getSystem(), bitmap);
    }

    public static byte[] toByteArray(Drawable drawable) {
        return ConvertUtils.toByteArray(ConvertUtils.toBitmap(drawable));
    }

    public static Drawable toDrawable(byte[] bytes) {
        return ConvertUtils.toDrawable(ConvertUtils.toBitmap(bytes));
    }

    public static int toPx(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        int pxValue = (int)(dpValue * scale + 0.5f);
        LogUtils.verbose(dpValue + " dp == " + pxValue + " px");
        return pxValue;
    }

    public static int toDp(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        int dpValue = (int)(pxValue / scale + 0.5f);
        LogUtils.verbose(pxValue + " px == " + dpValue + " dp");
        return dpValue;
    }

    public static int toSp(Context context, float pxValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        int spValue = (int)(pxValue / fontScale + 0.5f);
        LogUtils.verbose(pxValue + " px == " + spValue + " sp");
        return spValue;
    }

    public static String toGbk(String str) {
        try {
            return new String(str.getBytes("utf-8"), "gbk");
        }
        catch (UnsupportedEncodingException e) {
            LogUtils.warn(e);
            return str;
        }
    }

    public static String toFileSizeString(long fileSize) {
        DecimalFormat df = new DecimalFormat("0.00");
        String fileSizeString = fileSize < 1024L ? fileSize + "B" : (fileSize < 0x100000L ? df.format((double)fileSize / 1024.0) + "K" : (fileSize < 0x40000000L ? df.format((double)fileSize / 1048576.0) + "M" : df.format((double)fileSize / 1.073741824E9) + "G"));
        return fileSizeString;
    }

    public static String toString(InputStream is, String charset) {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, charset));
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            reader.close();
            is.close();
        }
        catch (IOException e) {
            LogUtils.error(e);
        }
        return sb.toString();
    }

    public static String toString(InputStream is) {
        return ConvertUtils.toString(is, "utf-8");
    }

    public static int toDarkenColor(@ColorInt int color) {
        return ConvertUtils.toDarkenColor(color, 0.8f);
    }

    public static int toDarkenColor(@ColorInt int color, @FloatRange(from=0.0, to=1.0) float value) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)color, (float[])hsv);
        hsv[2] = hsv[2] * value;
        return Color.HSVToColor((float[])hsv);
    }

    public static String toColorString(@ColorInt int color) {
        return ConvertUtils.toColorString(color, false);
    }

    public static String toColorString(@ColorInt int color, boolean includeAlpha) {
        String colorString;
        String alpha = Integer.toHexString(Color.alpha((int)color));
        String red = Integer.toHexString(Color.red((int)color));
        String green = Integer.toHexString(Color.green((int)color));
        String blue = Integer.toHexString(Color.blue((int)color));
        if (alpha.length() == 1) {
            alpha = "0" + alpha;
        }
        if (red.length() == 1) {
            red = "0" + red;
        }
        if (green.length() == 1) {
            green = "0" + green;
        }
        if (blue.length() == 1) {
            blue = "0" + blue;
        }
        if (includeAlpha) {
            colorString = alpha + red + green + blue;
            LogUtils.verbose(String.format(Locale.CHINA, "%d to color string is %s", color, colorString));
        } else {
            colorString = red + green + blue;
            LogUtils.verbose(String.format(Locale.CHINA, "%d to color string is %s%s%s%s, exclude alpha is %s", color, alpha, red, green, blue, colorString));
        }
        return colorString;
    }

    public static ColorStateList toColorStateList(@ColorInt int normalColor, @ColorInt int pressedColor, @ColorInt int focusedColor, @ColorInt int unableColor) {
        int[] colors = new int[]{pressedColor, focusedColor, normalColor, focusedColor, unableColor, normalColor};
        int[][] states = new int[][]{{16842919, 16842910}, {16842910, 16842908}, {16842910}, {16842908}, {16842909}, new int[0]};
        return new ColorStateList((int[][])states, colors);
    }

    public static ColorStateList toColorStateList(@ColorInt int normalColor, @ColorInt int pressedColor) {
        return ConvertUtils.toColorStateList(normalColor, pressedColor, pressedColor, normalColor);
    }
}

