/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.util;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import cn.qqtheme.framework.util.DateUtils;
import cn.qqtheme.framework.util.LogUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class ConvertUtils {
    public static final long GB = 0x40000000L;
    public static final long MB = 0x100000L;
    public static final long KB = 1024L;

    public static String toColorString(int color) {
        return ConvertUtils.toColorString(color, false);
    }

    public static String toColorString(int color, boolean includeAlpha) {
        String colorString;
        String alpha = Integer.toHexString(Color.alpha((int)color));
        String red = Integer.toHexString(Color.red((int)color));
        String green = Integer.toHexString(Color.green((int)color));
        String blue = Integer.toHexString(Color.blue((int)color));
        if (alpha.length() == 1) {
            alpha = "0" + alpha;
        }
        if (red.length() == 1) {
            red = "0" + red;
        }
        if (green.length() == 1) {
            green = "0" + green;
        }
        if (blue.length() == 1) {
            blue = "0" + blue;
        }
        if (includeAlpha) {
            colorString = alpha + red + green + blue;
            LogUtils.verbose(String.format(Locale.CHINA, "%d to color string is %s", color, colorString));
        } else {
            colorString = red + green + blue;
            LogUtils.verbose(String.format(Locale.CHINA, "%d to color string is %s%s%s%s, exclude alpha is %s", color, alpha, red, green, blue, colorString));
        }
        return colorString;
    }

    public static String toDateString(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format, Locale.CHINA);
        return sdf.format(date);
    }

    public static String toDateString(String format) {
        return ConvertUtils.toDateString(Calendar.getInstance(Locale.CHINA).getTime(), format);
    }

    public static Date toDate(String dateStr) {
        return DateUtils.parseDate(dateStr);
    }

    public static long toTimemillis(String dateStr) {
        return ConvertUtils.toDate(dateStr).getTime();
    }

    public static String toString(Object[] objects) {
        return Arrays.deepToString(objects);
    }

    public static String toString(Object[] objects, String tag) {
        StringBuilder sb = new StringBuilder();
        for (Object object : objects) {
            sb.append(object);
            sb.append(tag);
        }
        return sb.toString();
    }

    public static byte[] toByteArray(InputStream is) {
        if (is == null) {
            return null;
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buff = new byte[100];
            int rc = 0;
            while ((rc = is.read(buff, 0, 100)) > 0) {
                os.write(buff, 0, rc);
            }
            byte[] bytes = os.toByteArray();
            os.close();
            return bytes;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] toByteArray(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)os);
        byte[] bytes = os.toByteArray();
        try {
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bytes;
    }

    public static Bitmap toBitmap(byte[] bytes, int width, int height) {
        Bitmap bitmap = null;
        if (bytes.length != 0) {
            try {
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inDither = false;
                options.inPreferredConfig = null;
                if (width > 0 && height > 0) {
                    options.outWidth = width;
                    options.outHeight = height;
                }
                bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
            }
            catch (Exception e) {
                LogUtils.error(e);
            }
        }
        return bitmap;
    }

    public static Bitmap toBitmap(byte[] bytes) {
        return ConvertUtils.toBitmap(bytes, -1, -1);
    }

    @TargetApi(value=11)
    public static Bitmap toBitmap(Drawable drawable) {
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        if (drawable instanceof ColorDrawable) {
            Bitmap bitmap = Bitmap.createBitmap((int)32, (int)32, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            if (Build.VERSION.SDK_INT >= 11) {
                Canvas canvas = new Canvas(bitmap);
                canvas.drawColor(((ColorDrawable)drawable).getColor());
            }
            return bitmap;
        }
        if (drawable instanceof NinePatchDrawable) {
            Bitmap bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
            drawable.draw(canvas);
            return bitmap;
        }
        return null;
    }

    public static Drawable toDrawable(Bitmap bitmap) {
        return bitmap == null ? null : new BitmapDrawable(null, bitmap);
    }

    public static byte[] toByteArray(Drawable drawable) {
        return ConvertUtils.toByteArray(ConvertUtils.toBitmap(drawable));
    }

    public static Drawable toDrawable(byte[] bytes) {
        return ConvertUtils.toDrawable(ConvertUtils.toBitmap(bytes));
    }

    public static int toPx(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        int pxValue = (int)(dpValue * scale + 0.5f);
        LogUtils.verbose(dpValue + " dp == " + pxValue + " px");
        return pxValue;
    }

    public static int toPx(float dpValue) {
        Resources resources = Resources.getSystem();
        float px = TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)resources.getDisplayMetrics());
        return (int)px;
    }

    public static int toDp(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        int dpValue = (int)(pxValue / scale + 0.5f);
        LogUtils.verbose(pxValue + " px == " + dpValue + " dp");
        return dpValue;
    }

    public static int toSp(Context context, float pxValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        int spValue = (int)(pxValue / fontScale + 0.5f);
        LogUtils.verbose(pxValue + " px == " + spValue + " sp");
        return spValue;
    }

    public static String toGbk(String str) {
        try {
            return new String(str.getBytes("utf-8"), "gbk");
        }
        catch (UnsupportedEncodingException e) {
            LogUtils.warn(e.getMessage());
            return str;
        }
    }

    public static String toFileSizeString(long fileSize) {
        DecimalFormat df = new DecimalFormat("0.00");
        String fileSizeString = fileSize < 1024L ? fileSize + "B" : (fileSize < 0x100000L ? df.format((double)fileSize / 1024.0) + "K" : (fileSize < 0x40000000L ? df.format((double)fileSize / 1048576.0) + "M" : df.format((double)fileSize / 1.073741824E9) + "G"));
        return fileSizeString;
    }

    public static String toString(InputStream is) {
        StringBuilder sb = new StringBuilder();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            is.close();
        }
        catch (IOException e) {
            LogUtils.error(e);
        }
        return sb.toString();
    }

    public static ShapeDrawable toRoundDrawable(int color, int radius) {
        int r = ConvertUtils.toPx(radius);
        float[] outerR = new float[]{r, r, r, r, r, r, r, r};
        RoundRectShape shape = new RoundRectShape(outerR, null, null);
        ShapeDrawable drawable = new ShapeDrawable((Shape)shape);
        drawable.getPaint().setColor(color);
        return drawable;
    }

    public static ColorStateList toColorStateList(int normalColor, int pressedColor, int focusedColor, int unableColor) {
        int[] colors = new int[]{pressedColor, focusedColor, normalColor, focusedColor, unableColor, normalColor};
        int[][] states = new int[][]{{16842919, 16842910}, {16842910, 16842908}, {16842910}, {16842908}, {16842909}, new int[0]};
        return new ColorStateList((int[][])states, colors);
    }

    public static ColorStateList toColorStateList(int normalColor, int pressedColor) {
        return ConvertUtils.toColorStateList(normalColor, pressedColor, pressedColor, normalColor);
    }

    public static StateListDrawable toStateListDrawable(Drawable normal, Drawable pressed, Drawable focused, Drawable unable) {
        StateListDrawable drawable = new StateListDrawable();
        drawable.addState(new int[]{16842919, 16842910}, pressed);
        drawable.addState(new int[]{16842910, 16842908}, focused);
        drawable.addState(new int[]{16842910}, normal);
        drawable.addState(new int[]{16842908}, focused);
        drawable.addState(new int[]{16842909}, unable);
        drawable.addState(new int[0], normal);
        return drawable;
    }

    public static StateListDrawable toStateListDrawable(int normalColor, int pressedColor, int focusedColor, int unableColor) {
        StateListDrawable drawable = new StateListDrawable();
        ColorDrawable normal = new ColorDrawable(normalColor);
        ColorDrawable pressed = new ColorDrawable(pressedColor);
        ColorDrawable focused = new ColorDrawable(focusedColor);
        ColorDrawable unable = new ColorDrawable(unableColor);
        drawable.addState(new int[]{16842919, 16842910}, (Drawable)pressed);
        drawable.addState(new int[]{16842910, 16842908}, (Drawable)focused);
        drawable.addState(new int[]{16842910}, (Drawable)normal);
        drawable.addState(new int[]{16842908}, (Drawable)focused);
        drawable.addState(new int[]{16842909}, (Drawable)unable);
        drawable.addState(new int[0], (Drawable)normal);
        return drawable;
    }

    public static StateListDrawable toStateListDrawable(Drawable normal, Drawable pressed) {
        return ConvertUtils.toStateListDrawable(normal, pressed, pressed, normal);
    }

    public static StateListDrawable toStateListDrawable(int normalColor, int pressedColor) {
        return ConvertUtils.toStateListDrawable(normalColor, pressedColor, pressedColor, normalColor);
    }
}

