/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.popup;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.CallSuper;
import android.support.annotation.StyleRes;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import cn.qqtheme.framework.popup.Popup;
import cn.qqtheme.framework.util.LogUtils;
import cn.qqtheme.framework.util.ScreenUtils;

public abstract class BottomPopup<V extends View>
implements DialogInterface.OnKeyListener {
    public static final int MATCH_PARENT = -1;
    public static final int WRAP_CONTENT = -2;
    protected Activity activity;
    protected int screenWidthPixels;
    protected int screenHeightPixels;
    private Popup popup;
    private int width = 0;
    private int height = 0;
    private boolean isFillScreen = false;
    private boolean isHalfScreen = false;
    private boolean isPrepared = false;

    public BottomPopup(Activity activity) {
        this.activity = activity;
        DisplayMetrics displayMetrics = ScreenUtils.displayMetrics((Context)activity);
        this.screenWidthPixels = displayMetrics.widthPixels;
        this.screenHeightPixels = displayMetrics.heightPixels;
        this.popup = new Popup((Context)activity);
        this.popup.setOnKeyListener(this);
    }

    protected abstract V makeContentView();

    private void onShowPrepare() {
        if (this.isPrepared) {
            return;
        }
        this.setContentViewBefore();
        V view = this.makeContentView();
        this.popup.setContentView((View)view);
        this.setContentViewAfter(view);
        LogUtils.verbose("do something before popup show");
        if (this.width == 0 && this.height == 0) {
            this.width = this.screenWidthPixels;
            this.height = this.isFillScreen ? -1 : (this.isHalfScreen ? this.screenHeightPixels / 2 : -2);
        }
        this.popup.setSize(this.width, this.height);
        this.isPrepared = true;
    }

    public void setFillScreen(boolean fillScreen) {
        this.isFillScreen = fillScreen;
    }

    public void setHalfScreen(boolean halfScreen) {
        this.isHalfScreen = halfScreen;
    }

    protected void setContentViewBefore() {
    }

    protected void setContentViewAfter(V contentView) {
    }

    public void setAnimationStyle(@StyleRes int animRes) {
        this.popup.setAnimationStyle(animRes);
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.popup.setOnDismissListener(onDismissListener);
        LogUtils.verbose("popup setOnDismissListener");
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean isShowing() {
        return this.popup.isShowing();
    }

    @CallSuper
    public void show() {
        this.onShowPrepare();
        this.popup.show();
        LogUtils.verbose("popup show");
    }

    public void dismiss() {
        this.popup.dismiss();
        LogUtils.verbose("popup dismiss");
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return false;
    }

    public final boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
        if (event.getAction() == 0) {
            return this.onKeyDown(keyCode, event);
        }
        return false;
    }

    public Window getWindow() {
        return this.popup.getWindow();
    }

    public ViewGroup getRootView() {
        return this.popup.getRootView();
    }
}

