/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.util;

import android.support.annotation.NonNull;
import cn.qqtheme.framework.util.LogUtils;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DateUtils
extends android.text.format.DateUtils {
    public static long calculateDifferentSecond(Date startDate, Date endDate) {
        return DateUtils.calculateDifference(startDate, endDate, DifferenceMode.Second);
    }

    public static long calculateDifferentMinute(Date startDate, Date endDate) {
        return DateUtils.calculateDifference(startDate, endDate, DifferenceMode.Minute);
    }

    public static long calculateDifferentHour(Date startDate, Date endDate) {
        return DateUtils.calculateDifference(startDate, endDate, DifferenceMode.Hour);
    }

    public static long calculateDifferentDay(Date startDate, Date endDate) {
        return DateUtils.calculateDifference(startDate, endDate, DifferenceMode.Day);
    }

    public static long calculateDifferentSecond(long startTimeMillis, long endTimeMillis) {
        return DateUtils.calculateDifference(startTimeMillis, endTimeMillis, DifferenceMode.Second);
    }

    public static long calculateDifferentMinute(long startTimeMillis, long endTimeMillis) {
        return DateUtils.calculateDifference(startTimeMillis, endTimeMillis, DifferenceMode.Minute);
    }

    public static long calculateDifferentHour(long startTimeMillis, long endTimeMillis) {
        return DateUtils.calculateDifference(startTimeMillis, endTimeMillis, DifferenceMode.Hour);
    }

    public static long calculateDifferentDay(long startTimeMillis, long endTimeMillis) {
        return DateUtils.calculateDifference(startTimeMillis, endTimeMillis, DifferenceMode.Day);
    }

    public static long calculateDifference(long startTimeMillis, long endTimeMillis, DifferenceMode mode) {
        return DateUtils.calculateDifference(new Date(startTimeMillis), new Date(endTimeMillis), mode);
    }

    public static long calculateDifference(Date startDate, Date endDate, DifferenceMode mode) {
        long[] different = DateUtils.calculateDifference(startDate, endDate);
        if (mode.equals((Object)DifferenceMode.Minute)) {
            return different[2];
        }
        if (mode.equals((Object)DifferenceMode.Hour)) {
            return different[1];
        }
        if (mode.equals((Object)DifferenceMode.Day)) {
            return different[0];
        }
        return different[3];
    }

    public static long[] calculateDifference(Date startDate, Date endDate) {
        return DateUtils.calculateDifference(endDate.getTime() - startDate.getTime());
    }

    public static long[] calculateDifference(long differentMilliSeconds) {
        long secondsInMilli = 1000L;
        long minutesInMilli = secondsInMilli * 60L;
        long hoursInMilli = minutesInMilli * 60L;
        long daysInMilli = hoursInMilli * 24L;
        long elapsedDays = differentMilliSeconds / daysInMilli;
        long elapsedHours = (differentMilliSeconds %= daysInMilli) / hoursInMilli;
        long elapsedMinutes = (differentMilliSeconds %= hoursInMilli) / minutesInMilli;
        long elapsedSeconds = (differentMilliSeconds %= minutesInMilli) / secondsInMilli;
        LogUtils.debug(String.format("different: %d ms, %d days, %d hours, %d minutes, %d seconds", differentMilliSeconds, elapsedDays, elapsedHours, elapsedMinutes, elapsedSeconds));
        return new long[]{elapsedDays, elapsedHours, elapsedMinutes, elapsedSeconds};
    }

    public static int calculateDaysInMonth(int month) {
        return DateUtils.calculateDaysInMonth(0, month);
    }

    public static int calculateDaysInMonth(int year, int month) {
        String[] bigMonths = new String[]{"1", "3", "5", "7", "8", "10", "12"};
        String[] littleMonths = new String[]{"4", "6", "9", "11"};
        List<String> bigList = Arrays.asList(bigMonths);
        List<String> littleList = Arrays.asList(littleMonths);
        if (bigList.contains(String.valueOf(month))) {
            return 31;
        }
        if (littleList.contains(String.valueOf(month))) {
            return 30;
        }
        if (year <= 0) {
            return 29;
        }
        if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
            return 29;
        }
        return 28;
    }

    @NonNull
    public static String fillZero(int number) {
        return number < 10 ? "0" + number : "" + number;
    }

    public static boolean isSameDay(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("date is null");
        }
        Calendar nowCalendar = Calendar.getInstance();
        Calendar newCalendar = Calendar.getInstance();
        newCalendar.setTime(date);
        return nowCalendar.get(0) == newCalendar.get(0) && nowCalendar.get(1) == newCalendar.get(1) && nowCalendar.get(6) == newCalendar.get(6);
    }

    public static Date parseDate(String dateStr, String dataFormat) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(dataFormat);
            Date date = dateFormat.parse(dateStr);
            return new Date(date.getTime());
        }
        catch (Exception e) {
            LogUtils.warn(e);
            return null;
        }
    }

    public static Date parseDate(String dateStr) {
        return DateUtils.parseDate(dateStr, "yyyy-MM-dd HH:mm:ss");
    }

    public static enum DifferenceMode {
        Second,
        Minute,
        Hour,
        Day;

    }
}

