/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.util;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import android.support.annotation.StyleRes;
import android.view.View;
import android.widget.TextView;

public class CompatUtils {
    @TargetApi(value=16)
    public static void setBackground(View view, Drawable drawable) {
        if (Build.VERSION.SDK_INT < 16) {
            view.setBackgroundDrawable(drawable);
        } else {
            view.setBackground(drawable);
        }
    }

    @TargetApi(value=23)
    public static void setTextAppearance(TextView view, @StyleRes int appearanceRes) {
        if (Build.VERSION.SDK_INT < 23) {
            view.setTextAppearance(view.getContext(), appearanceRes);
        } else {
            view.setTextAppearance(appearanceRes);
        }
    }

    @TargetApi(value=21)
    public static Drawable getDrawable(Context context, @DrawableRes int drawableRes) {
        if (Build.VERSION.SDK_INT < 21) {
            return context.getResources().getDrawable(drawableRes);
        }
        return context.getDrawable(drawableRes);
    }

    @TargetApi(value=21)
    public static String getString(Context context, @StringRes int stringRes) {
        if (Build.VERSION.SDK_INT < 21) {
            return context.getResources().getString(stringRes);
        }
        return context.getString(stringRes);
    }

    @ColorInt
    public static int getColor(Context context, @ColorRes int colorRes) {
        if (Build.VERSION.SDK_INT < 21) {
            return context.getResources().getColor(colorRes);
        }
        return context.getResources().getColor(colorRes, null);
    }
}

