/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.calendarpicker.core;

import androidx.annotation.NonNull;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class TimeUtils {
    private static final Map<String, SimpleDateFormat> dateMap = new HashMap<String, SimpleDateFormat>();

    private static void ensureDateFormatMap(@NonNull String format) {
        if (!dateMap.containsKey(format)) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(format, Locale.getDefault());
                dateMap.put(format, sdf);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Date date(String dateText, @NonNull String format) throws Exception {
        SimpleDateFormat sdf;
        TimeUtils.ensureDateFormatMap(format);
        if (dateMap.containsKey(format) && (sdf = dateMap.get(format)) != null) {
            return sdf.parse(dateText);
        }
        return null;
    }

    public static String dateText(long date, @NonNull String format) {
        SimpleDateFormat sdf;
        String value = "";
        TimeUtils.ensureDateFormatMap(format);
        if (dateMap.containsKey(format) && (sdf = dateMap.get(format)) != null) {
            value = sdf.format(new Date(date));
        }
        return value;
    }
}

