/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.calendarpicker.core;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.github.gzuliyujiang.calendarpicker.core.ColorScheme;
import com.github.gzuliyujiang.calendarpicker.core.DateUtils;
import com.github.gzuliyujiang.calendarpicker.core.DayEntity;
import com.github.gzuliyujiang.calendarpicker.core.DayView;
import com.github.gzuliyujiang.calendarpicker.core.FestivalProvider;
import com.github.gzuliyujiang.calendarpicker.core.MonthEntity;
import com.github.gzuliyujiang.calendarpicker.core.NumInterval;
import com.github.gzuliyujiang.calendarpicker.core.OnDateClickListener;
import java.util.Date;

public class MonthView
extends ViewGroup {
    private ColorScheme colorScheme = new ColorScheme();
    private final DayView[] dayViews = new DayView[MonthEntity.MAX_DAYS_OF_MONTH];
    private final View[] dividerViews = new View[MonthEntity.MAX_HORIZONTAL_LINES];
    private int dividerHeight;
    private DividerLayoutControl dividerLayoutControl;
    private MonthEntity monthEntity;
    private int isTodayOfMonth = -1;
    private int position = 0;
    private int offset = 0;
    private int childWidth = 0;
    private int childHeight = 0;
    private OnDateClickListener onDayInMonthClickListener;

    public MonthView(Context context) {
        super(context);
        this.initialize(context);
    }

    public MonthView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context);
    }

    public MonthView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context);
    }

    @RequiresApi(api=21)
    public MonthView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initialize(context);
    }

    private void initialize(Context context) {
        int m = this.dayViews.length;
        for (int i = 0; i < m; ++i) {
            this.dayViews[i] = new DayView(context);
            this.addView((View)this.dayViews[i]);
        }
        this.dividerHeight = (int)(this.getResources().getDisplayMetrics().density * 0.5f);
        int n = this.dividerViews.length;
        for (int j = 0; j < n; ++j) {
            View view = new View(this.getContext());
            this.addView(view);
            this.dividerViews[j] = view;
        }
        this.dividerLayoutControl = new DividerLayoutControl(this.dividerViews);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (null == this.getValue()) {
            return;
        }
        int totalWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.dayViews[0].measure(widthMeasureSpec, heightMeasureSpec);
        int childrenHeight = 0;
        int amount = this.position + this.offset;
        int dayRows = amount / MonthEntity.WEEK_DAYS + (amount % MonthEntity.WEEK_DAYS != 0 ? 1 : 0);
        childrenHeight += this.dayViews[0].getMeasuredHeight() * dayRows;
        this.setMeasuredDimension(totalWidth, childrenHeight += dayRows * this.dividerHeight);
        this.childWidth = totalWidth / MonthEntity.WEEK_DAYS;
        this.childHeight = this.dayViews[0].getMeasuredHeight();
        int childWidthSpec = View.MeasureSpec.makeMeasureSpec((int)this.childWidth, (int)0x40000000);
        int childHeightSpec = View.MeasureSpec.makeMeasureSpec((int)this.childHeight, (int)0x40000000);
        for (DayView dayView : this.dayViews) {
            dayView.measure(childWidthSpec, childHeightSpec);
        }
        for (DayView dayView : this.dividerViews) {
            dayView.measure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)this.dividerHeight, (int)0x40000000));
        }
    }

    protected void onLayout(boolean b, int left, int top, int right, int bottom) {
        if (null == this.getValue()) {
            return;
        }
        int offsetX = 0;
        int offsetY = 0;
        for (int i = 0; i < this.position; ++i) {
            offsetX += this.childWidth;
        }
        int childBottom = offsetY + this.childHeight;
        boolean lastIsRightBound = false;
        NumInterval validRange = DateUtils.daysInterval(this.monthEntity.date(), this.monthEntity.valid());
        NumInterval selectRange = null;
        if (this.monthEntity.select().bothNoNull()) {
            selectRange = DateUtils.daysInterval(this.monthEntity.date(), this.monthEntity.select());
        }
        int index = 0;
        int move = this.position + 1;
        while (index < this.dayViews.length) {
            DayEntity dayEntity;
            boolean rightBound;
            boolean bl = rightBound = move % MonthEntity.WEEK_DAYS == 0;
            if (index < this.offset) {
                boolean isToday = index == this.isTodayOfMonth;
                dayEntity = DayEntity.obtain(0, index, isToday ? MonthEntity.STR_TODAY : this.toDayDesc(index)).valueStatus(lastIsRightBound || rightBound ? 6 : 0).descStatus(isToday ? 6 : 0);
                if (validRange.contain(index)) {
                    if (null != selectRange && selectRange.contain(index)) {
                        if (index == selectRange.lBound()) {
                            if (this.monthEntity.singleMode()) {
                                dayEntity.status(4).note(this.monthEntity.note().left());
                            } else {
                                dayEntity.status(3).note(this.monthEntity.note().left());
                            }
                        } else if (index == selectRange.rBound()) {
                            dayEntity.status(5).note(this.monthEntity.note().right());
                        } else {
                            dayEntity.status(2);
                            dayEntity.valueStatus(2);
                            dayEntity.descStatus(2);
                        }
                    }
                } else {
                    dayEntity.status(1).valueStatus(1).descStatus(1);
                }
                this.dayViews[index].setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (!(v instanceof DayView)) {
                            return;
                        }
                        if (null == MonthView.this.onDayInMonthClickListener) {
                            return;
                        }
                        try {
                            DayEntity entity = ((DayView)v).getValue();
                            Date dayDate = DateUtils.specialDayInMonth(MonthView.this.monthEntity.date(), entity.intValue());
                            MonthView.this.onDayInMonthClickListener.onCalendarDayClick(dayDate);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            } else {
                dayEntity = DayEntity.obtain(1, -1, "");
                this.dayViews[index].setOnClickListener(null);
            }
            this.dayViews[index].setValue(dayEntity, this.colorScheme);
            this.dayViews[index].layout(offsetX, offsetY, offsetX + this.childWidth, childBottom);
            if (rightBound) {
                offsetX = 0;
                offsetY += this.childHeight;
                offsetY = this.dividerLayoutControl.layout(offsetY);
                childBottom = offsetY + this.childHeight;
            } else {
                offsetX += this.childWidth;
            }
            lastIsRightBound = rightBound;
            ++index;
            ++move;
        }
        this.dividerLayoutControl.layout(offsetY + this.childHeight);
    }

    @NonNull
    protected String toDayDesc(int index) {
        FestivalProvider festivalProvider = this.monthEntity.festivalProvider();
        if (festivalProvider == null) {
            return "";
        }
        Date date = DateUtils.specialDayInMonth(this.monthEntity.date(), index);
        String festival = festivalProvider.provideText(date);
        if (festival == null) {
            festival = "";
        }
        return festival;
    }

    public void setValue(@NonNull MonthEntity entity, @NonNull ColorScheme colorScheme) {
        if (null != this.monthEntity) {
            this.monthEntity.recycle();
        }
        this.monthEntity = entity;
        this.position = DateUtils.firstDayOfMonthIndex(entity.date());
        this.offset = DateUtils.maxDaysOfMonth(entity.date());
        this.isTodayOfMonth = DateUtils.isTodayOfMonth(entity.date());
        this.setBackgroundColor(colorScheme.monthBackgroundColor());
        for (View view : this.dividerViews) {
            view.setBackgroundColor(colorScheme.monthDividerColor());
        }
        this.colorScheme = colorScheme;
        this.requestLayout();
    }

    public MonthEntity getValue() {
        return this.monthEntity;
    }

    public void setOnDayInMonthClickListener(OnDateClickListener listener) {
        this.onDayInMonthClickListener = listener;
    }

    private static class DividerLayoutControl {
        private final int width;
        private final int height;
        private final View[] view;
        private int count = 0;

        DividerLayoutControl(@NonNull View[] views) {
            this.view = views;
            this.width = views[0].getMeasuredWidth();
            this.height = views[0].getMeasuredHeight();
        }

        public int layout(int offsetY) {
            if (this.count >= this.view.length) {
                return offsetY;
            }
            int bottom = offsetY + this.height;
            this.view[this.count].layout(0, offsetY, this.width, bottom);
            ++this.count;
            return bottom;
        }
    }
}

