/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.calendarpicker.core;

import android.annotation.SuppressLint;
import android.graphics.Typeface;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.github.gzuliyujiang.calendarpicker.core.ColorScheme;
import com.github.gzuliyujiang.calendarpicker.core.DateUtils;
import com.github.gzuliyujiang.calendarpicker.core.FestivalProvider;
import com.github.gzuliyujiang.calendarpicker.core.Interval;
import com.github.gzuliyujiang.calendarpicker.core.MonthEntity;
import com.github.gzuliyujiang.calendarpicker.core.MonthView;
import com.github.gzuliyujiang.calendarpicker.core.OnDateClickListener;
import com.github.gzuliyujiang.calendarpicker.core.OnDateSelectedListener;
import com.github.gzuliyujiang.calendarpicker.core.TimeUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class CalendarAdapter
extends RecyclerView.Adapter<VH>
implements OnDateClickListener {
    public static String DATE_FORMAT = "yyyy\u5e74MM\u6708";
    private boolean notify = true;
    private ColorScheme colorScheme = new ColorScheme();
    private final List<Date> dates = new ArrayList<Date>();
    private final Interval<Date> valid = new Interval();
    private final Interval<Date> select = new Interval();
    private final Interval<String> selectNote = new Interval();
    private boolean singleMode = false;
    private FestivalProvider festivalProvider;
    private Date lastClickDate = null;
    private OnDateSelectedListener onDateSelectedListener;

    public CalendarAdapter notify(boolean notify) {
        this.notify = notify;
        return this;
    }

    public CalendarAdapter colorScheme(ColorScheme colorScheme) {
        if (colorScheme == null) {
            colorScheme = new ColorScheme();
        }
        this.colorScheme = colorScheme;
        return this;
    }

    public CalendarAdapter single(boolean value) {
        this.singleMode = value;
        if (this.notify) {
            this.refresh();
        }
        return this;
    }

    public CalendarAdapter festivalProvider(FestivalProvider value) {
        this.festivalProvider = value;
        if (this.notify) {
            this.refresh();
        }
        return this;
    }

    public CalendarAdapter valid(Date from, Date to) {
        this.valid.left(from);
        this.valid.right(to);
        if (this.notify) {
            this.refresh();
        }
        return this;
    }

    public CalendarAdapter intervalNotes(String noteFrom, String noteTo) {
        this.selectNote.left(noteFrom);
        this.selectNote.right(noteTo);
        if (this.notify) {
            this.refresh();
        }
        return this;
    }

    public CalendarAdapter select(long fromInMillis, long toInMillis) {
        return this.select(new Date(fromInMillis), new Date(toInMillis));
    }

    public CalendarAdapter select(Date from, Date to) {
        this.select.left(from);
        this.select.right(to);
        if (this.notify) {
            this.refresh();
        }
        return this;
    }

    public CalendarAdapter range(Date startDate, Date endDate) {
        return this.range(startDate, endDate, true);
    }

    public CalendarAdapter range(Date startDate, Date endDate, boolean clear) {
        List<Date> dates = DateUtils.fillDates(startDate, endDate);
        return this.range(dates, clear);
    }

    public CalendarAdapter range(List<Date> list, boolean clear) {
        if (clear) {
            this.dates.clear();
        }
        if (null != list && list.size() > 0) {
            this.dates.addAll(list);
        }
        if (this.notify) {
            this.refresh();
        }
        return this;
    }

    @Deprecated
    public CalendarAdapter setRange(Date startDate, Date endDate, boolean clear, boolean notify) {
        List<Date> dates = DateUtils.fillDates(startDate, endDate);
        this.notify = notify;
        return this.range(dates, clear);
    }

    @Deprecated
    public CalendarAdapter setRange(List<Date> list, boolean clear, boolean notify) {
        this.notify = notify;
        return this.range(list, clear);
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    public void refresh() {
        this.notifyDataSetChanged();
    }

    public void setOnCalendarSelectedListener(OnDateSelectedListener onDateSelectedListener) {
        this.onDateSelectedListener = onDateSelectedListener;
    }

    @NonNull
    public VH onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        LinearLayout linearLayout = new LinearLayout(parent.getContext());
        linearLayout.setOrientation(1);
        linearLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        TextView titleView = new TextView(parent.getContext());
        titleView.setGravity(17);
        titleView.setTextSize(14.0f);
        titleView.setTypeface(Typeface.defaultFromStyle((int)1));
        int padding = (int)(parent.getResources().getDisplayMetrics().density * 10.0f);
        titleView.setPadding(padding, padding, padding, padding);
        linearLayout.addView((View)titleView, new ViewGroup.LayoutParams(-1, -2));
        MonthView monthView = new MonthView(parent.getContext());
        linearLayout.addView((View)monthView, new ViewGroup.LayoutParams(-1, -2));
        return new VH((View)linearLayout, titleView, monthView);
    }

    public void onBindViewHolder(@NonNull VH holder, int position) {
        holder.titleView.setBackgroundColor(this.colorScheme.monthTitleBackgroundColor());
        holder.titleView.setTextColor(this.colorScheme.monthTitleTextColor());
        holder.titleView.setText((CharSequence)TimeUtils.dateText(this.getDateValue(position).getTime(), DATE_FORMAT));
        holder.monthView.setOnDayInMonthClickListener(this);
        holder.monthView.setValue(MonthEntity.obtain(this.valid, this.select).date(this.dates.get(position)).singleMode(this.singleMode).festivalProvider(this.festivalProvider).note(this.selectNote), this.colorScheme);
    }

    public int getItemCount() {
        return this.dates.size();
    }

    public final int getDatePosition(Date date) {
        int size = this.dates.size();
        if (size <= 1) {
            return 0;
        }
        long time = date.getTime();
        if (time <= this.dates.get(0).getTime()) {
            return 0;
        }
        int lastPosition = size - 1;
        if (time >= this.dates.get(lastPosition).getTime()) {
            return lastPosition;
        }
        for (int i = 0; i <= lastPosition; ++i) {
            Calendar minDate = DateUtils.calendar(this.dates.get(i).getTime());
            minDate.set(5, 1);
            minDate.set(11, 0);
            minDate.set(12, 0);
            minDate.set(13, 0);
            Calendar maxDate = DateUtils.calendar(this.dates.get(i).getTime());
            maxDate.set(5, DateUtils.maxDaysOfMonth(maxDate.getTime()));
            maxDate.set(11, 23);
            maxDate.set(12, 59);
            maxDate.set(13, 59);
            if (time < minDate.getTime().getTime() || time > maxDate.getTime().getTime()) continue;
            return i;
        }
        return -1;
    }

    public Date getDateValue(int position) {
        if (position >= 0 && position < this.dates.size()) {
            return this.dates.get(position);
        }
        return new Date(0L);
    }

    @Override
    public void onCalendarDayClick(Date date) {
        if (null == date) {
            return;
        }
        if (this.singleMode || null == this.lastClickDate || this.lastClickDate.getTime() >= date.getTime()) {
            this.lastClickDate = date;
            this.select(date, date).refresh();
            if (null != this.onDateSelectedListener) {
                this.onDateSelectedListener.onSingleSelected(date);
            }
            if (!this.singleMode && null != this.onDateSelectedListener) {
                this.onDateSelectedListener.onRangeSelected(date, date);
            }
            return;
        }
        this.select(this.lastClickDate, date).refresh();
        if (null != this.onDateSelectedListener) {
            this.onDateSelectedListener.onRangeSelected(this.lastClickDate, date);
        }
        this.lastClickDate = null;
    }

    static {
        if (!Locale.getDefault().getDisplayLanguage().contains("\u4e2d\u6587")) {
            DATE_FORMAT = "MMM, yyyy";
        }
    }

    static class VH
    extends RecyclerView.ViewHolder {
        TextView titleView;
        MonthView monthView;

        VH(View itemView, TextView titleView, MonthView monthView) {
            super(itemView);
            this.titleView = titleView;
            this.monthView = monthView;
        }
    }
}

