/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.calendarpicker;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import androidx.recyclerview.widget.RecyclerView;
import com.github.gzuliyujiang.calendarpicker.OnRangeDatePickListener;
import com.github.gzuliyujiang.calendarpicker.OnSingleDatePickListener;
import com.github.gzuliyujiang.calendarpicker.core.CalendarAdapter;
import com.github.gzuliyujiang.calendarpicker.core.CalendarView;
import com.github.gzuliyujiang.calendarpicker.core.ColorScheme;
import com.github.gzuliyujiang.calendarpicker.core.DateUtils;
import com.github.gzuliyujiang.calendarpicker.core.FestivalProvider;
import com.github.gzuliyujiang.calendarpicker.core.ItemViewProvider;
import com.github.gzuliyujiang.calendarpicker.core.OnDateSelectedListener;
import com.github.gzuliyujiang.dialog.DialogConfig;
import com.github.gzuliyujiang.dialog.ModalDialog;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class CalendarPicker
extends ModalDialog
implements OnDateSelectedListener {
    private CalendarView calendarView;
    private CalendarAdapter calendarAdapter;
    private ColorScheme colorScheme;
    private boolean singleMode = false;
    private FestivalProvider festivalProvider;
    private ItemViewProvider itemViewProvider;
    private Date minDate;
    private Date maxDate;
    private Date selectDate;
    private Date startDate;
    private Date endDate;
    private String noteFrom;
    private String noteTo;
    private OnSingleDatePickListener onSingleDatePickListener;
    private OnRangeDatePickListener onRangeDatePickListener;
    private boolean initialized = false;

    public CalendarPicker(Activity activity) {
        super(activity);
    }

    public CalendarPicker(@NonNull Activity activity, @StyleRes int themeResId) {
        super(activity, themeResId);
    }

    @NonNull
    protected View createBodyView() {
        this.calendarView = new CalendarView((Context)this.activity);
        return this.calendarView;
    }

    protected void initView() {
        super.initView();
        this.setHeight((int)((float)this.activity.getResources().getDisplayMetrics().heightPixels * 0.6f));
        switch (DialogConfig.getDialogStyle()) {
            case 0: 
            case 2: {
                this.headerView.setVisibility(0);
                break;
            }
            default: {
                this.headerView.setVisibility(8);
            }
        }
    }

    protected void initData() {
        super.initData();
        this.initialized = true;
        if (this.minDate == null && this.maxDate == null) {
            Date currentDate = new Date(System.currentTimeMillis());
            Calendar minCalendar = DateUtils.calendar(currentDate);
            minCalendar.add(2, -12);
            minCalendar.set(5, DateUtils.maxDaysOfMonth(minCalendar.getTime()));
            this.minDate = minCalendar.getTime();
            Calendar maxCalendar = DateUtils.calendar(currentDate);
            maxCalendar.setTime(currentDate);
            maxCalendar.add(2, 12);
            maxCalendar.set(5, DateUtils.maxDaysOfMonth(maxCalendar.getTime()));
            this.maxDate = maxCalendar.getTime();
        }
        this.calendarAdapter = this.calendarView.getAdapter();
        this.calendarAdapter.setOnCalendarSelectedListener(this);
        this.refreshData();
    }

    protected void onCancel() {
    }

    protected void onOk() {
        boolean rangeNotSelected;
        if (this.singleMode && this.selectDate == null) {
            return;
        }
        boolean bl = rangeNotSelected = this.startDate == null || this.endDate == null;
        if (!this.singleMode && rangeNotSelected) {
            return;
        }
        this.dismiss();
        if (this.onSingleDatePickListener != null) {
            this.onSingleDatePickListener.onSingleDatePicked(this.selectDate);
        }
        if (this.onRangeDatePickListener != null) {
            this.onRangeDatePickListener.onRangeDatePicked(this.startDate, this.endDate);
        }
    }

    @Override
    public void onSingleSelected(@NonNull Date date) {
        this.selectDate = date;
    }

    @Override
    public void onRangeSelected(@NonNull Date start, @NonNull Date end) {
        this.startDate = start;
        this.endDate = end;
    }

    public void enablePagerSnap() {
        this.setHeight(-2);
        this.calendarView.enablePagerSnap();
        this.calendarView.getBodyView().addOnScrollListener(new RecyclerView.OnScrollListener(){

            @SuppressLint(value={"NotifyDataSetChanged"})
            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                if (newState != 0) {
                    return;
                }
                CalendarPicker.this.calendarView.getAdapter().notifyDataSetChanged();
            }
        });
    }

    public void setColorScheme(ColorScheme colorScheme) {
        if (colorScheme == null) {
            colorScheme = new ColorScheme();
        }
        this.colorScheme = colorScheme;
        if (this.initialized) {
            this.refreshData();
        }
    }

    public void setOnRangeDatePickListener(OnRangeDatePickListener onRangeDatePickListener) {
        this.singleMode = false;
        this.onRangeDatePickListener = onRangeDatePickListener;
        if (this.initialized) {
            this.refreshData();
        }
    }

    public void setOnSingleDatePickListener(OnSingleDatePickListener onSingleDatePickListener) {
        this.singleMode = true;
        this.onSingleDatePickListener = onSingleDatePickListener;
        if (this.initialized) {
            this.refreshData();
        }
    }

    public void setRangeDate(Date minDate, Date maxDate) {
        this.minDate = DateUtils.min(minDate, maxDate);
        this.maxDate = DateUtils.max(minDate, maxDate);
        if (this.initialized) {
            this.refreshData();
        }
    }

    public void setRangeDateOnFuture(int offsetMonth) {
        if (offsetMonth < 0) {
            offsetMonth = 0;
        }
        this.minDate = new Date(System.currentTimeMillis());
        Calendar calendar = Calendar.getInstance(Locale.CHINA);
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.add(2, offsetMonth);
        calendar.set(5, DateUtils.maxDaysOfMonth(calendar.getTime()));
        this.maxDate = calendar.getTime();
        if (this.initialized) {
            this.refreshData();
        }
    }

    public void setSelectedDate(long timeInMillis) {
        this.setSelectedDate(new Date(timeInMillis));
    }

    public void setSelectedDate(Date date) {
        this.selectDate = date;
        if (this.initialized) {
            this.refreshData();
        }
    }

    public void setSelectedDate(long timeInMillisStart, long timeInMillisEnd) {
        this.setSelectedDate(new Date(Math.min(timeInMillisStart, timeInMillisEnd)), new Date(Math.max(timeInMillisStart, timeInMillisEnd)));
    }

    public void setSelectedDate(Date startDate, Date endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
        if (this.initialized) {
            this.refreshData();
        }
    }

    public void setIntervalNotes(String noteFrom, String noteTo) {
        this.noteFrom = noteFrom;
        this.noteTo = noteTo;
        if (this.initialized) {
            this.refreshData();
        }
    }

    public void setFestivalProvider(FestivalProvider festivalProvider) {
        this.festivalProvider = festivalProvider;
        if (this.initialized) {
            this.refreshData();
        }
    }

    public void setItemViewProvider(ItemViewProvider itemViewProvider) {
        this.itemViewProvider = itemViewProvider;
        if (this.initialized) {
            this.refreshData();
        }
    }

    private void refreshData() {
        this.calendarView.setColorScheme(this.colorScheme);
        this.calendarAdapter.notify(false);
        this.calendarAdapter.single(this.singleMode);
        this.calendarAdapter.festivalProvider(this.festivalProvider);
        this.calendarAdapter.itemViewProvider(this.itemViewProvider);
        if (this.singleMode) {
            this.startDate = this.selectDate;
            this.endDate = this.selectDate;
        }
        this.calendarAdapter.valid(this.minDate, this.maxDate);
        this.calendarAdapter.select(this.startDate, this.endDate);
        this.calendarAdapter.range(this.minDate, this.maxDate);
        if (!TextUtils.isEmpty((CharSequence)this.noteFrom) && !TextUtils.isEmpty((CharSequence)this.noteTo)) {
            this.calendarAdapter.intervalNotes(this.noteFrom, this.noteTo);
        }
        this.calendarAdapter.refresh();
        this.scrollToSelectedPosition();
    }

    private void scrollToSelectedPosition() {
        this.calendarView.post(new Runnable(){

            @Override
            public void run() {
                int position = CalendarPicker.this.calendarAdapter.getDatePosition(CalendarPicker.this.startDate);
                position = Math.max(position, 0);
                position = Math.min(position, CalendarPicker.this.calendarAdapter.getItemCount() - 1);
                CalendarPicker.this.calendarView.getLayoutManager().scrollToPositionWithOffset(position, 0);
            }
        });
    }

    public final CalendarView getCalendarView() {
        return this.calendarView;
    }
}

