/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.calendarpicker.core;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.graphics.ColorUtils;
import com.github.gzuliyujiang.calendarpicker.core.ColorScheme;
import com.github.gzuliyujiang.calendarpicker.core.DayEntity;

public final class DayView
extends LinearLayout {
    private TextView tvDesc;
    private TextView tvDay;
    private DayEntity entity;

    public DayView(@NonNull Context context) {
        super(context);
        this.initialize(context);
    }

    public DayView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context);
    }

    public DayView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context);
    }

    @RequiresApi(api=21)
    public DayView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initialize(context);
    }

    private void initialize(Context context) {
        this.setOrientation(1);
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        int padding = (int)(this.getResources().getDisplayMetrics().density * 3.0f);
        this.setPadding(0, padding, 0, padding);
        this.tvDay = new TextView(context);
        this.tvDay.setGravity(17);
        this.tvDay.setTextSize(15.0f);
        this.addView((View)this.tvDay, new ViewGroup.LayoutParams(-1, -2));
        this.tvDesc = new TextView(context);
        this.tvDesc.setGravity(17);
        this.tvDesc.setTextSize(12.0f);
        this.addView((View)this.tvDesc, new ViewGroup.LayoutParams(-1, -2));
    }

    public void setValue(DayEntity entity, ColorScheme scheme) {
        if (null != this.getValue()) {
            this.getValue().recycle();
        }
        this.entity = entity;
        this.tvDay.setText((CharSequence)entity.value());
        this.setTextStatusColor(this.tvDay, entity.valueStatus(), scheme);
        this.tvDesc.setText((CharSequence)entity.desc());
        this.setTextStatusColor(this.tvDesc, entity.descStatus(), scheme);
        this.setBackgroundStatus(entity, scheme);
    }

    public DayEntity getValue() {
        return this.entity;
    }

    private void setTextStatusColor(TextView tv, int status, ColorScheme scheme) {
        switch (status) {
            case 0: {
                tv.setTextColor(scheme.dayNormalTextColor());
                break;
            }
            case 1: {
                tv.setTextColor(scheme.dayInvalidTextColor());
                break;
            }
            case 6: {
                tv.setTextColor(scheme.dayStressTextColor());
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                tv.setTextColor(scheme.daySelectTextColor());
                break;
            }
        }
    }

    private void setBackgroundStatus(DayEntity entity, ColorScheme scheme) {
        switch (entity.status()) {
            case 0: 
            case 6: {
                this.setBackgroundColor(scheme.dayNormalBackgroundColor());
                this.setEnabled(true);
                break;
            }
            case 1: {
                this.tvDay.setTextColor(scheme.dayInvalidTextColor());
                this.setBackgroundColor(scheme.dayInvalidBackgroundColor());
                this.setEnabled(false);
                break;
            }
            case 2: {
                this.setBackgroundColor(ColorUtils.setAlphaComponent((int)scheme.daySelectBackgroundColor(), (int)200));
                this.setEnabled(true);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.tvDay.setTextColor(scheme.daySelectTextColor());
                this.tvDesc.setTextColor(scheme.daySelectTextColor());
                this.tvDesc.setText((CharSequence)entity.note());
                this.setBackgroundColor(scheme.daySelectBackgroundColor());
                break;
            }
        }
    }
}

