/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.calendarpicker.calendar.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import com.github.gzuliyujiang.calendarpicker.R;
import com.github.gzuliyujiang.calendarpicker.calendar.protocol.DayEntity;
import com.github.gzuliyujiang.calendarpicker.calendar.protocol.MonthEntity;
import com.github.gzuliyujiang.calendarpicker.calendar.protocol.NInterval;
import com.github.gzuliyujiang.calendarpicker.calendar.protocol.OnMonthClickListener;
import com.github.gzuliyujiang.calendarpicker.calendar.utils.DateUtils;
import com.github.gzuliyujiang.calendarpicker.calendar.view.DayView;
import java.util.Date;

public class MonthView
extends ViewGroup {
    private final DayView[] dayViews = new DayView[31];
    private final View[] lines = new View[6];
    private final int LINE_HEIGHT;
    private final SplitLinesLayoutControl lineControl;
    private MonthEntity monthEntity;
    private int isTodayOfMonth = -1;
    private int position = 0;
    private int offset = 0;
    private int childWidth = 0;
    private int childHeight = 0;
    private OnMonthClickListener onDayInMonthClickListener;
    private final View.OnClickListener clickDayListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (!(v instanceof DayView)) {
                return;
            }
            if (null == MonthView.this.onDayInMonthClickListener) {
                return;
            }
            try {
                DayView dayView = (DayView)v;
                DayEntity entity = dayView.value();
                Date month = new Date(MonthView.this.monthEntity.date().getTime());
                Date dayDate = DateUtils.specialDayInMonth(month, entity.intValue());
                MonthView.this.onDayInMonthClickListener.onMonthClick(dayDate);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public MonthView(Context context) {
        this(context, null);
    }

    public MonthView(Context context, AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public MonthView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setBackgroundColor(ContextCompat.getColor((Context)context, (int)R.color.calendar_month_background_color));
        for (int i = 0; i < this.dayViews.length; ++i) {
            this.dayViews[i] = new DayView(context);
            this.addView((View)this.dayViews[i]);
        }
        this.LINE_HEIGHT = (int)this.getResources().getDimension(R.dimen.calendar_month_divide_line_height);
        for (int j = 0; j < this.lines.length; ++j) {
            View view = new View(this.getContext());
            view.setBackgroundResource(R.color.calendar_month_divide_line_color);
            this.addView(view);
            this.lines[j] = view;
        }
        this.lineControl = new SplitLinesLayoutControl(this.lines);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (null == this.value()) {
            return;
        }
        int totalWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.dayViews[0].measure(widthMeasureSpec, heightMeasureSpec);
        int childrenHeight = 0;
        int amount = this.position + this.offset;
        int dayRows = amount / 7 + (amount % 7 != 0 ? 1 : 0);
        childrenHeight += this.dayViews[0].getMeasuredHeight() * dayRows;
        this.setMeasuredDimension(totalWidth, childrenHeight += dayRows * this.LINE_HEIGHT);
        this.childWidth = totalWidth / 7;
        this.childHeight = this.dayViews[0].getMeasuredHeight();
        int childWidthSpec = View.MeasureSpec.makeMeasureSpec((int)this.childWidth, (int)0x40000000);
        int childHeightSpec = View.MeasureSpec.makeMeasureSpec((int)this.childHeight, (int)0x40000000);
        for (DayView dayView : this.dayViews) {
            dayView.measure(childWidthSpec, childHeightSpec);
        }
        for (DayView dayView : this.lines) {
            dayView.measure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)this.LINE_HEIGHT, (int)0x40000000));
        }
    }

    protected void onLayout(boolean b, int left, int top, int right, int bottom) {
        if (null == this.value()) {
            return;
        }
        int offsetX = 0;
        int offsetY = 0;
        for (int i = 0; i < this.position; ++i) {
            offsetX += this.childWidth;
        }
        int childBottom = offsetY + this.childHeight;
        boolean lastIsRightBound = false;
        NInterval validRange = DateUtils.daysInterval(this.value().date(), this.monthEntity.valid());
        NInterval selectRange = null;
        if (this.monthEntity.select().bothNoNull()) {
            selectRange = DateUtils.daysInterval(this.value().date(), this.monthEntity.select());
        }
        int index = 0;
        int move = this.position + 1;
        while (index < this.dayViews.length) {
            DayEntity dayEntity;
            boolean rightBound;
            boolean bl = rightBound = move % 7 == 0;
            if (index < this.offset) {
                boolean isToday = index == this.isTodayOfMonth;
                dayEntity = DayEntity.obtain(0, index, isToday ? "\u4eca\u5929" : "").valueStatus(lastIsRightBound || rightBound ? 6 : 0).descStatus(isToday ? 6 : 0);
                if (validRange.contain(index)) {
                    if (null != selectRange && selectRange.contain(index)) {
                        if (index == selectRange.lBound()) {
                            if (this.monthEntity.singleFlag()) {
                                dayEntity.status(4).note(this.monthEntity.selectNote().left());
                            } else {
                                dayEntity.status(3).note(this.monthEntity.selectNote().left());
                            }
                        } else if (index == selectRange.rBound()) {
                            dayEntity.status(5).note(this.monthEntity.selectNote().right());
                        } else {
                            dayEntity.status(2);
                            if (dayEntity.valueStatus() == 0) {
                                dayEntity.valueStatus(2);
                            }
                        }
                    }
                } else {
                    dayEntity.status(1).valueStatus(1).descStatus(1);
                }
                this.dayViews[index].setOnClickListener(this.clickDayListener);
            } else {
                dayEntity = DayEntity.obtain(1, -1, "");
                this.dayViews[index].setOnClickListener(null);
            }
            this.dayViews[index].value(dayEntity);
            this.dayViews[index].layout(offsetX, offsetY, offsetX + this.childWidth, childBottom);
            if (rightBound) {
                offsetX = 0;
                offsetY += this.childHeight;
                offsetY = this.lineControl.layout(offsetY);
                childBottom = offsetY + this.childHeight;
            } else {
                offsetX += this.childWidth;
            }
            lastIsRightBound = rightBound;
            ++index;
            ++move;
        }
        this.lineControl.layout(offsetY + this.childHeight);
    }

    public void value(@NonNull MonthEntity entity) {
        if (null != this.value()) {
            this.value().recycle();
        }
        this.monthEntity = entity;
        this.position = DateUtils.firstDayOfMonthIndex(entity.date());
        this.offset = DateUtils.maxDaysOfMonth(entity.date());
        this.isTodayOfMonth = DateUtils.isTodayOfMonth(entity.date());
        this.requestLayout();
    }

    public MonthEntity value() {
        return this.monthEntity;
    }

    public void setOnDayInMonthClickListener(OnMonthClickListener listener) {
        this.onDayInMonthClickListener = listener;
    }

    private static class SplitLinesLayoutControl {
        private final int width;
        private final int height;
        private int count = 0;
        private View[] view;

        SplitLinesLayoutControl(@NonNull View[] views) {
            this.view = views;
            this.width = views[0].getMeasuredWidth();
            this.height = views[0].getMeasuredHeight();
        }

        public int layout(int offsetY) {
            if (this.count >= this.view.length) {
                return offsetY;
            }
            int bottom = offsetY + this.height;
            this.view[this.count].layout(0, offsetY, this.width, bottom);
            ++this.count;
            return bottom;
        }
    }
}

