/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.calendarpicker;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import com.github.gzuliyujiang.basepicker.ConfirmPicker;
import com.github.gzuliyujiang.calendarpicker.OnRangeDatePickListener;
import com.github.gzuliyujiang.calendarpicker.OnSingleDatePickListener;
import com.github.gzuliyujiang.calendarpicker.R;
import com.github.gzuliyujiang.calendarpicker.calendar.adapter.CalendarAdapter;
import com.github.gzuliyujiang.calendarpicker.calendar.protocol.OnCalendarSelectListener;
import com.github.gzuliyujiang.calendarpicker.calendar.utils.DateUtils;
import com.github.gzuliyujiang.calendarpicker.calendar.view.CalendarView;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class CalendarPicker
extends ConfirmPicker
implements OnCalendarSelectListener {
    private CalendarView calendarView;
    private FrameLayout bottomView;
    private CalendarAdapter calendarAdapter;
    private boolean rangePick = true;
    private Date minDate;
    private Date maxDate;
    private Date selectDate;
    private Date startDate;
    private Date endDate;
    private String noteFrom;
    private String noteTo;
    private OnSingleDatePickListener onSingleDatePickListener;
    private OnRangeDatePickListener onRangeDatePickListener;
    private boolean initialized = false;

    public CalendarPicker(Activity activity) {
        super(activity);
    }

    public CalendarPicker(@NonNull Activity activity, @StyleRes int themeResId) {
        super(activity, themeResId);
    }

    @NonNull
    protected View createBodyView(@NonNull Activity activity) {
        View view = View.inflate((Context)activity, (int)R.layout.calendar_picker, null);
        this.calendarView = (CalendarView)view.findViewById(R.id.calendar_picker_body);
        this.bottomView = (FrameLayout)view.findViewById(R.id.calendar_picker_bottom);
        return view;
    }

    protected void initData() {
        super.initData();
        this.initialized = true;
        this.setHeight((int)((double)this.calendarView.getResources().getDisplayMetrics().heightPixels * 0.6));
        this.calendarAdapter = this.calendarView.getAdapter();
        this.calendarAdapter.setOnCalendarSelectListener(this);
        this.refreshData();
    }

    protected void onCancel() {
    }

    protected void onOk() {
        boolean rangeNotSelected;
        if (!this.rangePick && this.selectDate == null) {
            return;
        }
        boolean bl = rangeNotSelected = this.startDate == null || this.endDate == null;
        if (this.rangePick && rangeNotSelected) {
            return;
        }
        this.dismiss();
        if (this.onSingleDatePickListener != null) {
            this.onSingleDatePickListener.onSingleDatePicked(this.selectDate);
        }
        if (this.onRangeDatePickListener != null) {
            this.onRangeDatePickListener.onRangeDatePicked(this.startDate, this.endDate);
        }
    }

    @Override
    public void onSingleSelect(@NonNull Date date) {
        this.selectDate = date;
    }

    @Override
    public void onDoubleSelect(@NonNull Date before, @NonNull Date after) {
        this.startDate = before;
        this.endDate = after;
    }

    public void setOnRangeDatePickListener(OnRangeDatePickListener onRangeDatePickListener) {
        this.rangePick = true;
        this.onRangeDatePickListener = onRangeDatePickListener;
        if (this.initialized) {
            this.refreshData();
        }
    }

    public void setOnSingleDatePickListener(OnSingleDatePickListener onSingleDatePickListener) {
        this.rangePick = false;
        this.onSingleDatePickListener = onSingleDatePickListener;
        if (this.initialized) {
            this.refreshData();
        }
    }

    public void setRangeDate(Date minDate, Date maxDate) {
        this.minDate = DateUtils.min(minDate, maxDate);
        this.maxDate = DateUtils.max(minDate, maxDate);
        if (this.initialized) {
            this.refreshData();
        }
    }

    public void setRangeDateOnFuture(int offsetMonth) {
        if (offsetMonth < 0) {
            offsetMonth = 0;
        }
        this.minDate = new Date(System.currentTimeMillis());
        Calendar calendar = Calendar.getInstance(Locale.CHINA);
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.add(2, offsetMonth);
        calendar.set(5, DateUtils.maxDaysOfMonth(calendar.getTime()));
        this.maxDate = calendar.getTime();
        if (this.initialized) {
            this.refreshData();
        }
    }

    public void setSelectedDate(long timeInMillis) {
        this.setSelectedDate(new Date(timeInMillis));
    }

    public void setSelectedDate(Date date) {
        this.selectDate = date;
        if (this.initialized) {
            this.refreshData();
        }
    }

    public void setSelectedDate(long timeInMillisStart, long timeInMillisEnd) {
        this.setSelectedDate(new Date(Math.min(timeInMillisStart, timeInMillisEnd)), new Date(Math.max(timeInMillisStart, timeInMillisEnd)));
    }

    public void setSelectedDate(Date startDate, Date endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
        if (this.initialized) {
            this.refreshData();
        }
    }

    public void setIntervalNotes(String noteFrom, String noteTo) {
        this.noteFrom = noteFrom;
        this.noteTo = noteTo;
        if (this.initialized) {
            this.refreshData();
        }
    }

    private void refreshData() {
        if (!TextUtils.isEmpty((CharSequence)this.noteFrom) && !TextUtils.isEmpty((CharSequence)this.noteTo)) {
            this.calendarAdapter.intervalNotes(this.noteFrom, this.noteTo);
        }
        this.calendarAdapter.single(!this.rangePick);
        if (!this.rangePick) {
            this.startDate = this.selectDate;
        }
        this.calendarAdapter.setRange(this.minDate, this.maxDate, true, false);
        this.calendarAdapter.valid(this.minDate, this.maxDate);
        this.calendarAdapter.select(this.startDate, this.endDate);
    }

    public final CalendarView getCalendarView() {
        return this.calendarView;
    }

    public final FrameLayout getBottomView() {
        return this.bottomView;
    }
}

