/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.calendarpicker.calendar.view.decoration;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.TextPaint;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.recyclerview.widget.RecyclerView;
import com.github.gzuliyujiang.calendarpicker.calendar.view.decoration.BaseDecoration;
import com.github.gzuliyujiang.calendarpicker.calendar.view.decoration.GroupListener;

public class StickyDecoration
extends BaseDecoration {
    @ColorInt
    private int mGroupTextColor = -1;
    private int mSideMargin = 10;
    private int mTextSize = 40;
    private GroupListener mGroupListener;
    private TextPaint mTextPaint;
    private Paint mGroutPaint;

    private StickyDecoration(GroupListener listener) {
        this.mGroupListener = listener;
        this.mGroutPaint = new Paint();
        this.mGroutPaint.setColor(this.mGroupBackground);
        this.mTextPaint = new TextPaint();
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setTextSize((float)this.mTextSize);
        this.mTextPaint.setColor(this.mGroupTextColor);
        this.mTextPaint.setTextAlign(Paint.Align.LEFT);
    }

    public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
        super.onDrawOver(c, parent, state);
        int itemCount = state.getItemCount();
        int childCount = parent.getChildCount();
        int left = parent.getLeft() + parent.getPaddingLeft();
        int right = parent.getRight() - parent.getPaddingRight();
        String currentGroupName = null;
        for (int i = 0; i < childCount; ++i) {
            float bottom;
            View view = parent.getChildAt(i);
            int position = parent.getChildAdapterPosition(view);
            String preGroupName = currentGroupName;
            currentGroupName = this.getGroupName(position);
            if (currentGroupName == null || TextUtils.equals((CharSequence)currentGroupName, (CharSequence)preGroupName)) {
                if (this.mDivideHeight == 0 || (bottom = (float)view.getTop()) < (float)this.mGroupHeight) continue;
                c.drawRect((float)left, bottom - (float)this.mDivideHeight, (float)right, bottom, this.mDividePaint);
                continue;
            }
            bottom = Math.max(this.mGroupHeight, view.getTop());
            if (position + 1 < itemCount) {
                String nextGroupName = this.getGroupName(position + 1);
                int viewBottom = view.getBottom();
                if (!currentGroupName.equals(nextGroupName) && (float)viewBottom < bottom) {
                    bottom = viewBottom;
                }
            }
            c.drawRect((float)left, bottom - (float)this.mGroupHeight, (float)right, bottom, this.mGroutPaint);
            c.drawRect((float)left, bottom, (float)right, bottom + (float)this.mDivideHeight, this.mDividePaint);
            Paint.FontMetrics fm = this.mTextPaint.getFontMetrics();
            float baseLine = bottom - ((float)this.mGroupHeight - (fm.bottom - fm.top)) / 2.0f - fm.bottom;
            float textWidth = this.mTextPaint.measureText(currentGroupName);
            float marginLeft = this.mAlign.equals((Object)Paint.Align.LEFT) ? (float)(left + Math.abs(this.mSideMargin)) : (this.mAlign.equals((Object)Paint.Align.RIGHT) ? (float)left + ((float)right - textWidth) - (float)Math.abs(this.mSideMargin) : (float)left + ((float)right - textWidth) / 2.0f);
            c.drawText(currentGroupName, marginLeft, baseLine, (Paint)this.mTextPaint);
        }
    }

    @Override
    String getGroupName(int position) {
        if (this.mGroupListener != null) {
            return this.mGroupListener.getGroupName(position);
        }
        return null;
    }

    public static class Builder {
        private StickyDecoration mDecoration;

        private Builder(GroupListener groupListener) {
            this.mDecoration = new StickyDecoration(groupListener);
        }

        public static Builder init(GroupListener groupListener) {
            return new Builder(groupListener);
        }

        public Builder setGroupBackground(@ColorInt int background) {
            this.mDecoration.mGroupBackground = background;
            this.mDecoration.mGroutPaint.setColor(this.mDecoration.mGroupBackground);
            return this;
        }

        public Builder setGroupTextSize(int textSize) {
            this.mDecoration.mTextSize = textSize;
            this.mDecoration.mTextPaint.setTextSize((float)this.mDecoration.mTextSize);
            return this;
        }

        public Builder setGroupHeight(int groutHeight) {
            this.mDecoration.mGroupHeight = groutHeight;
            return this;
        }

        public Builder setGroupTextColor(@ColorInt int color2) {
            this.mDecoration.mGroupTextColor = color2;
            this.mDecoration.mTextPaint.setColor(this.mDecoration.mGroupTextColor);
            return this;
        }

        public Builder setTypeface(Typeface typeface) {
            this.mDecoration.mTextPaint.setTypeface(typeface);
            return this;
        }

        public Builder setTextSideMargin(int leftMargin) {
            this.mDecoration.mSideMargin = leftMargin;
            return this;
        }

        public Builder setTextAlign(Paint.Align align) {
            this.mDecoration.mAlign = align;
            return this;
        }

        public Builder setDivideHeight(int height) {
            this.mDecoration.mDivideHeight = height;
            return this;
        }

        public Builder setDivideColor(@ColorInt int color2) {
            this.mDecoration.mDivideColor = color2;
            this.mDecoration.mDividePaint.setColor(color2);
            return this;
        }

        public StickyDecoration build() {
            return this.mDecoration;
        }
    }
}

