/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.calendarpicker.calendar.view.decoration;

import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.recyclerview.widget.RecyclerView;

public abstract class BaseDecoration
extends RecyclerView.ItemDecoration {
    @ColorInt
    int mGroupBackground = Color.parseColor((String)"#00000000");
    int mGroupHeight = 80;
    Paint.Align mAlign = Paint.Align.LEFT;
    @ColorInt
    int mDivideColor = Color.parseColor((String)"#CCCCCC");
    int mDivideHeight = 0;
    Paint mDividePaint = new Paint();

    BaseDecoration() {
        this.mDividePaint.setColor(this.mDivideColor);
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        super.getItemOffsets(outRect, view, parent, state);
        int pos = parent.getChildAdapterPosition(view);
        String groupId = this.getGroupName(pos);
        if (groupId == null) {
            return;
        }
        outRect.top = pos == 0 || this.isFirstInGroup(pos) ? this.mGroupHeight : this.mDivideHeight;
    }

    private boolean isFirstInGroup(int pos) {
        String groupId;
        if (pos == 0) {
            return true;
        }
        String prevGroupId = this.getGroupName(pos - 1);
        return !TextUtils.equals((CharSequence)prevGroupId, (CharSequence)(groupId = this.getGroupName(pos)));
    }

    abstract String getGroupName(int var1);
}

