/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker.impl;

import android.content.Context;
import android.content.res.AssetManager;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.github.gzuliyujiang.wheelpicker.contract.AddressLoader;
import com.github.gzuliyujiang.wheelpicker.contract.AddressParser;
import com.github.gzuliyujiang.wheelpicker.contract.AddressReceiver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;

public class AssetAddressLoader
implements AddressLoader {
    private final Context context;
    private final String path;

    public AssetAddressLoader(@NonNull Context context, @NonNull String path) {
        this.context = context;
        this.path = path;
    }

    @Override
    public void loadJson(final @NonNull AddressReceiver receiver, final @NonNull AddressParser parser) {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                String text = AssetAddressLoader.this.loadFromAssets();
                final List<Object> data = TextUtils.isEmpty((CharSequence)text) ? new ArrayList() : parser.parseData(text);
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        receiver.onAddressReceived(data);
                    }
                });
            }
        });
    }

    @WorkerThread
    private String loadFromAssets() {
        StringBuilder stringBuilder = new StringBuilder();
        AssetManager am = this.context.getAssets();
        try (BufferedReader bf = new BufferedReader(new InputStreamReader(am.open(this.path)));){
            String line;
            while ((line = bf.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        catch (IOException e) {
            return "";
        }
        return stringBuilder.toString();
    }
}

