/*
 * Decompiled with CFR 0.152.
 */
package com.guoxiaoxing.phoenix.compress.video.compat;

import android.media.MediaCodec;
import android.os.Build;
import java.nio.ByteBuffer;

public class MediaCodecBufferCompatWrapper {
    final MediaCodec mMediaCodec;
    final ByteBuffer[] mInputBuffers;
    final ByteBuffer[] mOutputBuffers;

    public MediaCodecBufferCompatWrapper(MediaCodec mediaCodec) {
        this.mMediaCodec = mediaCodec;
        if (Build.VERSION.SDK_INT < 21) {
            this.mInputBuffers = mediaCodec.getInputBuffers();
            this.mOutputBuffers = mediaCodec.getOutputBuffers();
        } else {
            this.mOutputBuffers = null;
            this.mInputBuffers = null;
        }
    }

    public ByteBuffer getInputBuffer(int index) {
        if (Build.VERSION.SDK_INT >= 21) {
            return this.mMediaCodec.getInputBuffer(index);
        }
        return this.mInputBuffers[index];
    }

    public ByteBuffer getOutputBuffer(int index) {
        if (Build.VERSION.SDK_INT >= 21) {
            return this.mMediaCodec.getOutputBuffer(index);
        }
        return this.mOutputBuffers[index];
    }
}

