/*
 * Decompiled with CFR 0.152.
 */
package com.guoxiaoxing.phoenix.compress.video.utils;

import android.media.MediaFormat;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class AvcCsdUtils {
    private static final byte[] AVC_START_CODE_3 = new byte[]{0, 0, 1};
    private static final byte[] AVC_START_CODE_4 = new byte[]{0, 0, 0, 1};
    private static final byte AVC_SPS_NAL = 103;
    private static final byte AVC_SPS_NAL_2 = 39;
    private static final byte AVC_SPS_NAL_3 = 71;

    public static ByteBuffer getSpsBuffer(MediaFormat format) {
        ByteBuffer sourceBuffer = format.getByteBuffer("csd-0").asReadOnlyBuffer();
        ByteBuffer prefixedSpsBuffer = ByteBuffer.allocate(sourceBuffer.limit()).order(sourceBuffer.order());
        prefixedSpsBuffer.put(sourceBuffer);
        prefixedSpsBuffer.flip();
        AvcCsdUtils.skipStartCode(prefixedSpsBuffer);
        byte spsNalData = prefixedSpsBuffer.get();
        if (spsNalData != 103 && spsNalData != 39 && spsNalData != 71) {
            throw new IllegalStateException("Got non SPS NAL data.");
        }
        return prefixedSpsBuffer.slice();
    }

    private static void skipStartCode(ByteBuffer prefixedSpsBuffer) {
        byte[] prefix3 = new byte[3];
        prefixedSpsBuffer.get(prefix3);
        if (Arrays.equals(prefix3, AVC_START_CODE_3)) {
            return;
        }
        byte[] prefix4 = Arrays.copyOf(prefix3, 4);
        prefix4[3] = prefixedSpsBuffer.get();
        if (Arrays.equals(prefix4, AVC_START_CODE_4)) {
            return;
        }
        throw new IllegalStateException("AVC NAL start code does not found in csd.");
    }

    private AvcCsdUtils() {
        throw new RuntimeException();
    }
}

