/*
 * Decompiled with CFR 0.152.
 */
package com.guoxiaoxing.phoenix.compress.video;

import android.content.Context;
import android.os.Environment;
import android.widget.Toast;
import com.guoxiaoxing.phoenix.compress.video.VideoCompressor;
import com.guoxiaoxing.phoenix.compress.video.format.MediaFormatStrategyPresets;
import com.guoxiaoxing.phoenix.core.PhoenixOption;
import com.guoxiaoxing.phoenix.core.listener.OnProcessorListener;
import com.guoxiaoxing.phoenix.core.listener.Processor;
import com.guoxiaoxing.phoenix.core.model.MediaEntity;
import java.io.File;
import java.io.IOException;

public class VideoCompressProcessor
implements Processor {
    private static final String TAG = "VideoCompressProcessor";

    public MediaEntity syncProcess(Context context, MediaEntity mediaEntity, PhoenixOption phoenixOption) {
        File compressFile;
        if (mediaEntity == null) {
            throw new IllegalArgumentException("The onProcessorListener can not be null");
        }
        MediaEntity result = mediaEntity;
        try {
            File compressCachePath = new File(context.getCacheDir(), "outputs");
            compressCachePath.mkdir();
            compressFile = File.createTempFile("compress", ".mp4", compressCachePath);
        }
        catch (IOException e) {
            Toast.makeText((Context)context, (CharSequence)"Failed to create temporary file.", (int)1).show();
            return null;
        }
        try {
            String compressPath = VideoCompressor.with().syncTranscodeVideo(mediaEntity.getLocalPath(), compressFile.getAbsolutePath(), MediaFormatStrategyPresets.createAndroid480pFormatStrategy());
            result.setCompressed(true);
            result.setCompressPath(compressPath);
            return mediaEntity;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void asyncProcess(Context context, MediaEntity mediaEntity, PhoenixOption phoenixOption, final OnProcessorListener onProcessorListener) {
        File compressFile;
        if (mediaEntity == null) {
            throw new IllegalArgumentException("The onProcessorListener can not be null");
        }
        if (onProcessorListener == null) {
            throw new IllegalArgumentException("The onProcessorListener can not be null");
        }
        final MediaEntity result = mediaEntity;
        try {
            File compressCachePath = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM), "phoenix");
            compressCachePath.mkdir();
            compressFile = File.createTempFile("compress", ".mp4", compressCachePath);
        }
        catch (IOException e) {
            Toast.makeText((Context)context, (CharSequence)"Failed to create temporary file.", (int)1).show();
            return;
        }
        VideoCompressor.Listener listener = new VideoCompressor.Listener(){

            @Override
            public void onTranscodeProgress(double progress) {
                onProcessorListener.onProgress((int)progress);
            }

            @Override
            public void onTranscodeCompleted() {
                result.setCompressed(true);
                result.setCompressPath(compressFile.getAbsolutePath());
                onProcessorListener.onSuccess(result);
            }

            @Override
            public void onTranscodeCanceled() {
            }

            @Override
            public void onTranscodeFailed(Exception exception) {
                onProcessorListener.onFailed(exception.getMessage());
            }
        };
        try {
            VideoCompressor.with().asyncTranscodeVideo(mediaEntity.getLocalPath(), compressFile.getAbsolutePath(), MediaFormatStrategyPresets.createAndroid480pFormatStrategy(), listener);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

