/*
 * Decompiled with CFR 0.152.
 */
package com.guoxiaoxing.phoenix.compress.video.engine;

import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.media.MediaMuxer;
import android.util.Log;
import com.guoxiaoxing.phoenix.compress.video.engine.AudioTrackTranscoder;
import com.guoxiaoxing.phoenix.compress.video.engine.InvalidOutputFormatException;
import com.guoxiaoxing.phoenix.compress.video.engine.MediaFormatValidator;
import com.guoxiaoxing.phoenix.compress.video.engine.PassThroughTrackTranscoder;
import com.guoxiaoxing.phoenix.compress.video.engine.QueuedMuxer;
import com.guoxiaoxing.phoenix.compress.video.engine.TrackTranscoder;
import com.guoxiaoxing.phoenix.compress.video.engine.VideoTrackTranscoder;
import com.guoxiaoxing.phoenix.compress.video.format.MediaFormatStrategy;
import com.guoxiaoxing.phoenix.compress.video.utils.MediaExtractorUtils;
import java.io.FileDescriptor;
import java.io.IOException;

public class MediaTranscoderEngine {
    private static final String TAG = "MediaTranscoderEngine";
    private static final double PROGRESS_UNKNOWN = -1.0;
    private static final long SLEEP_TO_WAIT_TRACK_TRANSCODERS = 10L;
    private static final long PROGRESS_INTERVAL_STEPS = 10L;
    private FileDescriptor mInputFileDescriptor;
    private TrackTranscoder mVideoTrackTranscoder;
    private TrackTranscoder mAudioTrackTranscoder;
    private MediaExtractor mExtractor;
    private MediaMuxer mMuxer;
    private volatile double mProgress;
    private ProgressCallback mProgressCallback;
    private long mDurationUs;

    public void setDataSource(FileDescriptor fileDescriptor) {
        this.mInputFileDescriptor = fileDescriptor;
    }

    public ProgressCallback getProgressCallback() {
        return this.mProgressCallback;
    }

    public void setProgressCallback(ProgressCallback progressCallback) {
        this.mProgressCallback = progressCallback;
    }

    public double getProgress() {
        return this.mProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transcodeVideo(String outputPath, MediaFormatStrategy formatStrategy) throws IOException, InterruptedException {
        if (outputPath == null) {
            throw new NullPointerException("Output path cannot be null.");
        }
        if (this.mInputFileDescriptor == null) {
            throw new IllegalStateException("Data source is not set.");
        }
        try {
            this.mExtractor = new MediaExtractor();
            this.mExtractor.setDataSource(this.mInputFileDescriptor);
            this.mMuxer = new MediaMuxer(outputPath, 0);
            this.setupMetadata();
            this.setupTrackTranscoders(formatStrategy);
            this.runPipelines();
            this.mMuxer.stop();
        }
        finally {
            try {
                if (this.mVideoTrackTranscoder != null) {
                    this.mVideoTrackTranscoder.release();
                    this.mVideoTrackTranscoder = null;
                }
                if (this.mAudioTrackTranscoder != null) {
                    this.mAudioTrackTranscoder.release();
                    this.mAudioTrackTranscoder = null;
                }
                if (this.mExtractor != null) {
                    this.mExtractor.release();
                    this.mExtractor = null;
                }
            }
            catch (RuntimeException e) {
                throw new Error("Could not shutdown extractor, codecs and muxer pipeline.", e);
            }
            try {
                if (this.mMuxer != null) {
                    this.mMuxer.release();
                    this.mMuxer = null;
                }
            }
            catch (RuntimeException e) {
                Log.e((String)TAG, (String)"Failed to release muxer.", (Throwable)e);
            }
        }
    }

    private void setupMetadata() throws IOException {
        MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();
        mediaMetadataRetriever.setDataSource(this.mInputFileDescriptor);
        String rotationString = mediaMetadataRetriever.extractMetadata(24);
        try {
            this.mMuxer.setOrientationHint(Integer.parseInt(rotationString));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.mDurationUs = Long.parseLong(mediaMetadataRetriever.extractMetadata(9)) * 1000L;
        }
        catch (NumberFormatException e) {
            this.mDurationUs = -1L;
        }
        Log.d((String)TAG, (String)("Duration (us): " + this.mDurationUs));
    }

    private void setupTrackTranscoders(MediaFormatStrategy formatStrategy) {
        MediaExtractorUtils.TrackResult trackResult = MediaExtractorUtils.getFirstVideoAndAudioTrack(this.mExtractor);
        MediaFormat videoOutputFormat = formatStrategy.createVideoOutputFormat(trackResult.mVideoTrackFormat);
        MediaFormat audioOutputFormat = formatStrategy.createAudioOutputFormat(trackResult.mAudioTrackFormat);
        if (videoOutputFormat == null && audioOutputFormat == null) {
            throw new InvalidOutputFormatException("MediaFormatStrategy returned pass-through for both video and audio. No transcoding is necessary.");
        }
        QueuedMuxer queuedMuxer = new QueuedMuxer(this.mMuxer, new QueuedMuxer.Listener(){

            @Override
            public void onDetermineOutputFormat() {
                MediaFormatValidator.validateVideoOutputFormat(MediaTranscoderEngine.this.mVideoTrackTranscoder.getDeterminedFormat());
                MediaFormatValidator.validateAudioOutputFormat(MediaTranscoderEngine.this.mAudioTrackTranscoder.getDeterminedFormat());
            }
        });
        this.mVideoTrackTranscoder = videoOutputFormat == null ? new PassThroughTrackTranscoder(this.mExtractor, trackResult.mVideoTrackIndex, queuedMuxer, QueuedMuxer.SampleType.VIDEO) : new VideoTrackTranscoder(this.mExtractor, trackResult.mVideoTrackIndex, videoOutputFormat, queuedMuxer);
        this.mVideoTrackTranscoder.setup();
        this.mAudioTrackTranscoder = audioOutputFormat == null ? new PassThroughTrackTranscoder(this.mExtractor, trackResult.mAudioTrackIndex, queuedMuxer, QueuedMuxer.SampleType.AUDIO) : new AudioTrackTranscoder(this.mExtractor, trackResult.mAudioTrackIndex, audioOutputFormat, queuedMuxer);
        this.mAudioTrackTranscoder.setup();
        this.mExtractor.selectTrack(trackResult.mVideoTrackIndex);
        this.mExtractor.selectTrack(trackResult.mAudioTrackIndex);
    }

    private void runPipelines() {
        long loopCount = 0L;
        if (this.mDurationUs <= 0L) {
            double progress;
            this.mProgress = progress = -1.0;
            if (this.mProgressCallback != null) {
                this.mProgressCallback.onProgress(progress);
            }
        }
        while (!this.mVideoTrackTranscoder.isFinished() || !this.mAudioTrackTranscoder.isFinished()) {
            boolean stepped = this.mVideoTrackTranscoder.stepPipeline() || this.mAudioTrackTranscoder.stepPipeline();
            if (this.mDurationUs > 0L && ++loopCount % 10L == 0L) {
                double progress;
                double videoProgress = this.mVideoTrackTranscoder.isFinished() ? 1.0 : Math.min(1.0, (double)this.mVideoTrackTranscoder.getWrittenPresentationTimeUs() / (double)this.mDurationUs);
                double audioProgress = this.mAudioTrackTranscoder.isFinished() ? 1.0 : Math.min(1.0, (double)this.mAudioTrackTranscoder.getWrittenPresentationTimeUs() / (double)this.mDurationUs);
                this.mProgress = progress = (videoProgress + audioProgress) / 2.0;
                if (this.mProgressCallback != null) {
                    this.mProgressCallback.onProgress(progress);
                }
            }
            if (stepped) continue;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static interface ProgressCallback {
        public void onProgress(double var1);
    }
}

