/*
 * Decompiled with CFR 0.152.
 */
package com.guoxiaoxing.phoenix.compress.picture.internal;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class Engine {
    private int mFilterSize;
    private ExifInterface mSourceExif;
    private File mSourcePicture;
    private File mTargetPicture;
    private int mSourceWidth;
    private int mSourceHeight;

    Engine(File sourcePicture, File targetPicture, int filterSize) throws IOException {
        if (this.isJpeg(sourcePicture)) {
            this.mSourceExif = new ExifInterface(sourcePicture.getAbsolutePath());
        }
        this.mSourcePicture = sourcePicture;
        this.mTargetPicture = targetPicture;
        this.mFilterSize = filterSize;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.inSampleSize = 1;
        BitmapFactory.decodeFile((String)this.mSourcePicture.getAbsolutePath(), (BitmapFactory.Options)options);
        this.mSourceWidth = options.outWidth;
        this.mSourceHeight = options.outHeight;
    }

    private boolean isJpeg(File photo) {
        return photo.getAbsolutePath().contains("jpeg") || photo.getAbsolutePath().contains("jpg");
    }

    private int computeSize() {
        this.mSourceWidth = this.mSourceWidth % 2 == 1 ? this.mSourceWidth + 1 : this.mSourceWidth;
        this.mSourceHeight = this.mSourceHeight % 2 == 1 ? this.mSourceHeight + 1 : this.mSourceHeight;
        this.mSourceWidth = this.mSourceWidth > this.mSourceHeight ? this.mSourceHeight : this.mSourceWidth;
        this.mSourceHeight = this.mSourceWidth > this.mSourceHeight ? this.mSourceWidth : this.mSourceHeight;
        double scale = (double)this.mSourceWidth / (double)this.mSourceHeight;
        int mSampleSize = scale <= 1.0 && scale > 0.5625 ? (this.mSourceHeight < 1664 ? 1 : (this.mSourceHeight >= 1664 && this.mSourceHeight < 4990 ? 2 : (this.mSourceHeight >= 4990 && this.mSourceHeight < 10240 ? 4 : (this.mSourceHeight / 1280 == 0 ? 1 : this.mSourceHeight / 1280)))) : (scale <= 0.5625 && scale > 0.5 ? (this.mSourceHeight / 1280 == 0 ? 1 : this.mSourceHeight / 1280) : (int)Math.ceil((double)this.mSourceHeight / (1280.0 / scale)));
        return mSampleSize;
    }

    private Bitmap rotatingImage(Bitmap bitmap) {
        if (this.mSourceExif == null) {
            return bitmap;
        }
        Matrix matrix = new Matrix();
        int angle = 0;
        int orientation = this.mSourceExif.getAttributeInt("Orientation", 1);
        switch (orientation) {
            case 6: {
                angle = 90;
                break;
            }
            case 3: {
                angle = 180;
                break;
            }
            case 8: {
                angle = 270;
            }
        }
        matrix.postRotate((float)angle);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    File compress() throws IOException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = this.computeSize();
        Bitmap tagBitmap = BitmapFactory.decodeFile((String)this.mSourcePicture.getAbsolutePath(), (BitmapFactory.Options)options);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        tagBitmap = this.rotatingImage(tagBitmap);
        tagBitmap.compress(Bitmap.CompressFormat.JPEG, 50, (OutputStream)stream);
        tagBitmap.recycle();
        FileOutputStream fos = new FileOutputStream(this.mTargetPicture);
        fos.write(stream.toByteArray());
        fos.flush();
        fos.close();
        stream.close();
        return this.mTargetPicture;
    }
}

