/*
 * Decompiled with CFR 0.152.
 */
package com.guoxiaoxing.phoenix.compress.picture.internal;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import com.guoxiaoxing.phoenix.compress.picture.internal.Engine;
import com.guoxiaoxing.phoenix.compress.picture.listener.OnCompressListener;
import java.io.File;
import java.io.IOException;

public class PictureCompressor
implements Handler.Callback {
    private static final String TAG = "PictureCompressor";
    private static final String DEFAULT_DISK_CACHE_DIR = "cache";
    private static final int MSG_COMPRESS_SUCCESS = 0;
    private static final int MSG_COMPRESS_START = 1;
    private static final int MSG_COMPRESS_ERROR = 2;
    private File mFile;
    private int mFilterSize;
    private String mSavePath;
    private OnCompressListener onCompressListener;
    private Handler mHandler;

    private PictureCompressor(Builder builder) {
        this.mFile = builder.file;
        this.mSavePath = builder.savePath;
        this.mFilterSize = builder.filterSize;
        this.onCompressListener = builder.onCompressListener;
        this.mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
    }

    public static Builder with(Context context) {
        return new Builder(context);
    }

    private File getImageCacheFile(Context context) {
        if (this.getImageCacheDir(context) != null) {
            return new File(this.getImageCacheDir(context) + "/" + System.currentTimeMillis() + (int)(Math.random() * 1000.0) + ".jpg");
        }
        return null;
    }

    @Nullable
    private File getImageCacheDir(Context context) {
        return this.getImageCacheDir(context, DEFAULT_DISK_CACHE_DIR);
    }

    @Nullable
    private File getImageCacheDir(Context context, String cacheName) {
        File cacheDir = new File(this.mSavePath);
        File result = new File(cacheDir, cacheName);
        if (!(result.mkdirs() || result.exists() && result.isDirectory())) {
            return null;
        }
        return result;
    }

    @UiThread
    private void launch(final Context context) {
        if (this.mFile == null && this.onCompressListener != null) {
            this.onCompressListener.onError(new NullPointerException("image mFile cannot be null"));
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PictureCompressor.this.mHandler.sendMessage(PictureCompressor.this.mHandler.obtainMessage(1));
                    File result = new Engine(PictureCompressor.this.mFile, PictureCompressor.this.getImageCacheFile(context), PictureCompressor.this.mFilterSize).compress();
                    PictureCompressor.this.mHandler.sendMessage(PictureCompressor.this.mHandler.obtainMessage(0, (Object)result));
                }
                catch (IOException e) {
                    PictureCompressor.this.mHandler.sendMessage(PictureCompressor.this.mHandler.obtainMessage(2, (Object)e));
                }
            }
        }).start();
    }

    @WorkerThread
    private File get(Context context) throws IOException {
        return new Engine(this.mFile, this.getImageCacheFile(context), this.mFilterSize).compress();
    }

    public boolean handleMessage(Message msg) {
        if (this.onCompressListener == null) {
            return false;
        }
        switch (msg.what) {
            case 1: {
                this.onCompressListener.onStart();
                break;
            }
            case 0: {
                this.onCompressListener.onSuccess((File)msg.obj);
                break;
            }
            case 2: {
                this.onCompressListener.onError((Throwable)msg.obj);
            }
        }
        return false;
    }

    public static class Builder {
        private Context context;
        private int filterSize;
        private File file;
        private String savePath;
        private OnCompressListener onCompressListener;

        Builder(Context context) {
            this.context = context;
        }

        private PictureCompressor build() {
            return new PictureCompressor(this);
        }

        public Builder load(File file) {
            this.file = file;
            return this;
        }

        public Builder filterSize(int filterSize) {
            this.filterSize = filterSize;
            return this;
        }

        public Builder savePath(String savePath) {
            this.savePath = savePath;
            return this;
        }

        public Builder setCompressListener(OnCompressListener listener) {
            this.onCompressListener = listener;
            return this;
        }

        public void launch() {
            this.build().launch(this.context);
        }

        public File get() throws IOException {
            return this.build().get(this.context);
        }
    }
}

