/*
 * Decompiled with CFR 0.152.
 */
package com.github.guilhe.views;

import android.animation.Animator;
import android.animation.FloatEvaluator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import com.github.guilhe.views.CircularProgressView$WhenMappings;
import com.github.guilhe.views.ProgressThumbScaleType;
import com.github.guilhe.views.circularprogress.R;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0014\n\u0002\b\n\n\u0002\u0010!\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0012\u0018\u0000 \u0099\u00012\u00020\u0001:\u0004\u0098\u0001\u0099\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010g\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u00072\u0006\u0010h\u001a\u00020\u0013H\u0002J\u0010\u0010i\u001a\u00020\u00072\u0006\u0010j\u001a\u00020\u0013H\u0002J\u0012\u0010k\u001a\u00020Y2\b\b\u0001\u0010l\u001a\u00020YH\u0002J(\u0010m\u001a\u0002042\u0006\u0010n\u001a\u00020o2\u0006\u0010p\u001a\u00020o2\u0006\u0010q\u001a\u00020r2\u0006\u0010s\u001a\u00020tH\u0002J\u0010\u0010u\u001a\u00020v2\u0006\u0010w\u001a\u00020xH\u0014J\u0018\u0010y\u001a\u00020v2\u0006\u0010z\u001a\u00020\u00072\u0006\u0010{\u001a\u00020\u0007H\u0014J\b\u0010|\u001a\u00020vH\u0002J\u001c\u0010}\u001a\u00020v2\b\b\u0002\u0010~\u001a\u00020\u00182\b\b\u0002\u0010q\u001a\u00020rH\u0007J\u0011\u0010\u007f\u001a\u00020v2\t\u0010\u0080\u0001\u001a\u0004\u0018\u00010>J\u0012\u0010\u0081\u0001\u001a\u00020v2\u0007\u00105\u001a\u00030\u0082\u0001H\u0007J\u0012\u0010\u0083\u0001\u001a\u00020v2\u0007\u00105\u001a\u00030\u0082\u0001H\u0007J\u000f\u0010\u0083\u0001\u001a\u00020v2\u0006\u00105\u001a\u00020\u0007J\u0014\u0010\u0084\u0001\u001a\u00020v2\t\b\u0001\u0010\u0085\u0001\u001a\u00020\u0007H\u0007J%\u0010\u0086\u0001\u001a\u00020v2\u0006\u00102\u001a\u00020\u00132\b\b\u0002\u0010~\u001a\u00020\u00182\b\b\u0002\u0010q\u001a\u00020rH\u0007J*\u0010\u0086\u0001\u001a\u00020v2\u0006\u00102\u001a\u00020\u00132\u0006\u0010~\u001a\u00020\u00182\u0006\u0010q\u001a\u00020r2\u0007\u0010\u0087\u0001\u001a\u00020\u0018H\u0002J&\u0010\u0086\u0001\u001a\u00020v2\r\u0010?\u001a\t\u0012\u0004\u0012\u00020\u00130\u0088\u00012\u000e\u0010\u0089\u0001\u001a\t\u0012\u0004\u0012\u00020\u00070\u0088\u0001J\u0011\u0010;\u001a\u00020v2\u0007\u00105\u001a\u00030\u0082\u0001H\u0007J\u0014\u0010\u008a\u0001\u001a\u00020v2\t\b\u0001\u0010\u0085\u0001\u001a\u00020\u0007H\u0007J'\u0010\u008b\u0001\u001a\u00020v2\b\b\u0001\u0010l\u001a\u00020Y2\u0007\u0010\u008c\u0001\u001a\u00020[2\t\b\u0002\u0010\u008d\u0001\u001a\u00020\u0018H\u0007J\u000f\u0010\u008e\u0001\u001a\u00020v2\u0006\u0010+\u001a\u00020\u0013J\u0011\u0010\u008f\u0001\u001a\u00020v2\u0006\u0010+\u001a\u00020\u0013H\u0002J\u0013\u0010\u0090\u0001\u001a\u00020v2\b\u0010V\u001a\u0004\u0018\u00010WH\u0002J\u0014\u0010\u0091\u0001\u001a\u00020v2\t\b\u0001\u0010\u0085\u0001\u001a\u00020\u0007H\u0007J\u0010\u0010\u0092\u0001\u001a\u00020v2\u0007\u0010\u0093\u0001\u001a\u00020\u0007J\u001b\u0010\u0094\u0001\u001a\u00020v2\u0007\u0010\u0095\u0001\u001a\u00020\u00132\u0007\u0010\u0096\u0001\u001a\u00020\u0018H\u0002J\u001b\u0010\u0097\u0001\u001a\u00020v2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR$\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001b\"\u0004\b\u001f\u0010\u001dR$\u0010!\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u0018@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001b\"\u0004\b\"\u0010\u001dR$\u0010#\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001b\"\u0004\b$\u0010\u001dR$\u0010%\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u0018@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001b\"\u0004\b&\u0010\u001dR\u000e\u0010'\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010,\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u000e\u00101\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082.\u00a2\u0006\u0002\n\u0000R$\u00106\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010.\"\u0004\b8\u00100R$\u00109\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010.\"\u0004\b;\u00100R\u000e\u0010<\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00130@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010B\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR\u000e\u0010G\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00100@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020JX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010L\u001a\u00020MX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010O\"\u0004\bP\u0010QR\u001a\u0010R\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010D\"\u0004\bT\u0010FR\u000e\u0010U\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010V\u001a\u0004\u0018\u00010WX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010X\u001a\u00020YX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010Z\u001a\u00020[X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\\\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010]\u001a\u00020JX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010^\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010_\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010a\u001a\u00020\u00072\u0006\u0010`\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bb\u0010.\"\u0004\bc\u00100R\u000e\u0010d\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010e\u001a\b\u0012\u0004\u0012\u00020\u00130fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u009a\u0001"}, d2={"Lcom/github/guilhe/views/CircularProgressView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "actionCallback", "Lcom/github/guilhe/views/CircularProgressView$CircularProgressViewActionCallback;", "getActionCallback", "()Lcom/github/guilhe/views/CircularProgressView$CircularProgressViewActionCallback;", "setActionCallback", "(Lcom/github/guilhe/views/CircularProgressView$CircularProgressViewActionCallback;)V", "backgroundPaint", "Landroid/graphics/Paint;", "defaultMaxWidth", "defaultShadowPadding", "", "defaultStrokeThickness", "defaultThumbSize", "defaultViewPadding", "initShader", "", "enabled", "isBackgroundAlphaEnabled", "()Z", "setBackgroundAlphaEnabled", "(Z)V", "isProgressRounded", "setProgressRounded", "enable", "isProgressThumbEnabled", "setProgressThumbEnabled", "isReverseEnabled", "setReverseEnabled", "isShadowEnabled", "setShadowEnabled", "lastValidRawMeasuredDim", "lastValidStrokeThickness", "lastValidThumbSize", "lastValidThumbSizeRate", "value", "max", "getMax", "()I", "setMax", "(I)V", "multipleArcsEnabled", "progress", "progressAnimator", "Landroid/animation/ValueAnimator;", "color", "progressBackgroundColor", "getProgressBackgroundColor", "setProgressBackgroundColor", "progressColor", "getProgressColor", "setProgressColor", "progressIconThickness", "progressInterpolator", "Landroid/animation/TimeInterpolator;", "progressList", "Ljava/util/ArrayList;", "progressListTotal", "progressMaxThumbSizeRate", "getProgressMaxThumbSizeRate", "()F", "setProgressMaxThumbSizeRate", "(F)V", "progressPaint", "progressPaintList", "progressRectF", "Landroid/graphics/RectF;", "progressStrokeThickness", "progressThumbScaleType", "Lcom/github/guilhe/views/ProgressThumbScaleType;", "getProgressThumbScaleType", "()Lcom/github/guilhe/views/ProgressThumbScaleType;", "setProgressThumbScaleType", "(Lcom/github/guilhe/views/ProgressThumbScaleType;)V", "progressThumbSize", "getProgressThumbSize", "setProgressThumbSize", "progressThumbSizeRate", "shader", "Landroid/graphics/Shader;", "shaderColors", "", "shaderPositions", "", "shadowPaint", "shadowRectF", "shadowThumbPaint", "sizeChanged", "angle", "startingAngle", "getStartingAngle", "setStartingAngle", "thumbPaint", "valuesToDrawList", "", "adjustAlpha", "factor", "dpToPx", "dp", "duplicateFirstColor", "colors", "getAnimator", "current", "", "next", "duration", "", "updateListener", "Landroid/animation/ValueAnimator$AnimatorUpdateListener;", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "resetBackgroundPaint", "resetProgress", "animate", "setAnimationInterpolator", "interpolator", "setBackgroundColor", "Landroid/graphics/Color;", "setColor", "setColorResource", "resId", "setProgress", "clockwise", "", "progressColorList", "setProgressColorResource", "setProgressColors", "positions", "duplicateFirst", "setProgressStrokeThickness", "setProgressValue", "setShader", "setShadowColorResource", "setSize", "size", "setThickness", "thickness", "requestLayout", "setupAttr", "CircularProgressViewActionCallback", "Companion", "circular-progress-view_release"})
public final class CircularProgressView
extends View {
    private final float defaultViewPadding;
    private final float defaultShadowPadding;
    private final float defaultStrokeThickness;
    private final float defaultThumbSize;
    private final int defaultMaxWidth;
    private final List<Float> valuesToDrawList;
    private RectF progressRectF;
    private RectF shadowRectF;
    private Paint backgroundPaint;
    private Paint progressPaint;
    private Paint shadowPaint;
    private Paint shadowThumbPaint;
    private Paint thumbPaint;
    private ValueAnimator progressAnimator;
    private boolean multipleArcsEnabled;
    private float progressListTotal;
    private ArrayList<Float> progressList;
    private ArrayList<Paint> progressPaintList;
    private float progress;
    private float progressThumbSizeRate;
    private float progressIconThickness;
    private float progressStrokeThickness;
    private float lastValidRawMeasuredDim;
    private float lastValidStrokeThickness;
    private float lastValidThumbSize;
    private float lastValidThumbSizeRate;
    private TimeInterpolator progressInterpolator;
    private Shader shader;
    private int[] shaderColors;
    private float[] shaderPositions;
    private boolean initShader;
    private boolean sizeChanged;
    @NotNull
    private ProgressThumbScaleType progressThumbScaleType;
    private float progressMaxThumbSizeRate;
    private float progressThumbSize;
    @Nullable
    private CircularProgressViewActionCallback actionCallback;
    private boolean isBackgroundAlphaEnabled;
    private boolean isReverseEnabled;
    private boolean isProgressRounded;
    private boolean isShadowEnabled;
    private boolean isProgressThumbEnabled;
    private int progressColor;
    private int progressBackgroundColor;
    private int startingAngle;
    private int max;
    private static final float ANGLE_OFFSET_FOR_MULTIPLE_ARC_PROGRESS = 6.0f;
    private static final float DEFAULT_VIEW_PADDING_DP = 10.0f;
    private static final float DEFAULT_SHADOW_PADDING_DP = 5.0f;
    private static final float DEFAULT_STROKE_THICKNESS_DP = 10.0f;
    private static final float DEFAULT_THUMB_SIZE_DP = 10.0f;
    private static final float DEFAULT_MAXIMUM_THUMB_SIZE_RATE = 2.0f;
    private static final int DEFAULT_MAX_WIDTH_DP = 100;
    private static final int DEFAULT_MAX = 100;
    private static final int DEFAULT_STARTING_ANGLE = 270;
    private static final int DEFAULT_ANIMATION_MILLIS = 1000;
    private static final int DEFAULT_PROGRESS_COLOR = -16777216;
    private static final float DEFAULT_BACKGROUND_ALPHA = 0.3f;
    private static final TimeInterpolator DEFAULT_INTERPOLATOR;
    public static final Companion Companion;

    @NotNull
    public final ProgressThumbScaleType getProgressThumbScaleType() {
        return this.progressThumbScaleType;
    }

    public final void setProgressThumbScaleType(@NotNull ProgressThumbScaleType progressThumbScaleType) {
        Intrinsics.checkNotNullParameter((Object)((Object)progressThumbScaleType), (String)"<set-?>");
        this.progressThumbScaleType = progressThumbScaleType;
    }

    public final float getProgressMaxThumbSizeRate() {
        return this.progressMaxThumbSizeRate;
    }

    public final void setProgressMaxThumbSizeRate(float f) {
        this.progressMaxThumbSizeRate = f;
    }

    public final float getProgressThumbSize() {
        return this.progressThumbSize;
    }

    public final void setProgressThumbSize(float f) {
        this.progressThumbSize = f;
    }

    @Nullable
    public final CircularProgressViewActionCallback getActionCallback() {
        return this.actionCallback;
    }

    public final void setActionCallback(@Nullable CircularProgressViewActionCallback circularProgressViewActionCallback) {
        this.actionCallback = circularProgressViewActionCallback;
    }

    public final boolean isBackgroundAlphaEnabled() {
        return this.isBackgroundAlphaEnabled;
    }

    public final void setBackgroundAlphaEnabled(boolean enabled) {
        this.isBackgroundAlphaEnabled = enabled;
        this.resetBackgroundPaint();
        this.invalidate();
    }

    public final boolean isReverseEnabled() {
        return this.isReverseEnabled;
    }

    public final void setReverseEnabled(boolean enabled) {
        this.isReverseEnabled = enabled;
        this.invalidate();
    }

    public final boolean isProgressRounded() {
        return this.isProgressRounded;
    }

    public final void setProgressRounded(boolean enabled) {
        this.isProgressRounded = enabled;
        Paint paint = this.progressPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressPaint");
        }
        paint.setStrokeCap(this.isProgressRounded ? Paint.Cap.ROUND : Paint.Cap.SQUARE);
        Paint paint2 = this.shadowPaint;
        if (paint2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shadowPaint");
        }
        Paint paint3 = this.progressPaint;
        if (paint3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressPaint");
        }
        paint2.setStrokeCap(paint3.getStrokeCap());
        this.invalidate();
    }

    public final boolean isShadowEnabled() {
        return this.isShadowEnabled;
    }

    public final void setShadowEnabled(boolean enable) {
        this.isShadowEnabled = enable;
        this.invalidate();
    }

    public final boolean isProgressThumbEnabled() {
        return this.isProgressThumbEnabled;
    }

    public final void setProgressThumbEnabled(boolean enable) {
        this.isProgressThumbEnabled = enable;
        this.invalidate();
        this.requestLayout();
    }

    public final int getProgressColor() {
        return this.progressColor;
    }

    public final void setProgressColor(int color) {
        this.progressColor = color;
        if (color == -1) {
            this.setProgressBackgroundColor(color);
        }
        Paint paint = this.progressPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressPaint");
        }
        paint.setColor(color);
        this.setShader(null);
        this.invalidate();
    }

    public final int getProgressBackgroundColor() {
        return this.progressBackgroundColor;
    }

    public final void setProgressBackgroundColor(int color) {
        this.progressBackgroundColor = color;
        this.resetBackgroundPaint();
        this.invalidate();
    }

    public final int getStartingAngle() {
        return this.startingAngle;
    }

    public final void setStartingAngle(int angle) {
        this.startingAngle = angle;
        this.invalidate();
    }

    public final int getMax() {
        return this.max;
    }

    public final void setMax(int value) {
        this.max = value;
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void setupAttr(Context context, AttributeSet attrs) {
        this.progressRectF = new RectF();
        this.shadowRectF = new RectF();
        Paint paint = this.backgroundPaint = new Paint(1);
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backgroundPaint");
        }
        paint.setStyle(Paint.Style.STROKE);
        Paint paint2 = this.progressPaint = new Paint(1);
        if (paint2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressPaint");
        }
        paint2.setStyle(Paint.Style.STROKE);
        Paint paint3 = this.shadowPaint = new Paint(1);
        if (paint3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shadowPaint");
        }
        paint3.setStyle(Paint.Style.STROKE);
        Paint paint4 = this.shadowThumbPaint = new Paint(1);
        if (paint4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shadowThumbPaint");
        }
        paint4.setStyle(Paint.Style.FILL);
        Paint paint5 = this.thumbPaint = new Paint(1);
        if (paint5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"thumbPaint");
        }
        paint5.setStyle(Paint.Style.FILL);
        if (attrs != null) {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CircularProgressView, 0, 0);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyl\u2026rcularProgressView, 0, 0)");
            TypedArray typedArray2 = typedArray;
            try {
                int positionsId;
                this.setMax(typedArray2.getInt(R.styleable.CircularProgressView_max, 100));
                this.setShadowEnabled(typedArray2.getBoolean(R.styleable.CircularProgressView_shadow, true));
                this.setProgressThumbEnabled(typedArray2.getBoolean(R.styleable.CircularProgressView_progressThumb, false));
                this.progressThumbScaleType = ProgressThumbScaleType.values()[typedArray2.getInteger(R.styleable.CircularProgressView_progressThumbScaleType, 0)];
                this.progressMaxThumbSizeRate = typedArray2.getFloat(R.styleable.CircularProgressView_progressThumbSizeMaxRate, 2.0f);
                this.setStartingAngle(typedArray2.getInteger(R.styleable.CircularProgressView_startingAngle, 270));
                this.progress = typedArray2.getFloat(R.styleable.CircularProgressView_progress, 0.0f);
                this.progressStrokeThickness = typedArray2.getDimension(R.styleable.CircularProgressView_progressBarThickness, this.defaultStrokeThickness);
                this.progressThumbSize = typedArray2.getDimension(R.styleable.CircularProgressView_progressThumbSize, this.defaultThumbSize);
                this.progressThumbSizeRate = typedArray2.getFloat(R.styleable.CircularProgressView_progressThumbSizeRate, 2.0f);
                this.setProgressColor(typedArray2.getInt(R.styleable.CircularProgressView_progressBarColor, -16777216));
                this.setProgressRounded(typedArray2.getBoolean(R.styleable.CircularProgressView_progressBarRounded, false));
                this.setProgressBackgroundColor(typedArray2.getInt(R.styleable.CircularProgressView_progressBackgroundColor, this.progressColor));
                this.setBackgroundAlphaEnabled(typedArray2.getBoolean(R.styleable.CircularProgressView_progressBackgroundAlphaEnabled, true));
                this.setReverseEnabled(typedArray2.getBoolean(R.styleable.CircularProgressView_reverse, false));
                int colorsId = typedArray2.getResourceId(R.styleable.CircularProgressView_progressBarColorArray, -1);
                boolean duplicate = typedArray2.getBoolean(R.styleable.CircularProgressView_duplicateFirstColorInArray, false);
                if (colorsId != -1) {
                    int[] nArray = typedArray2.getResources().getIntArray(colorsId);
                    Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"typedArray.resources.getIntArray(colorsId)");
                    this.shaderColors = nArray;
                    if (duplicate) {
                        this.shaderColors = this.duplicateFirstColor(this.shaderColors);
                    }
                    this.initShader = true;
                }
                if ((positionsId = typedArray2.getResourceId(R.styleable.CircularProgressView_progressBarColorArrayPositions, -1)) != -1) {
                    TypedArray typedArray3 = typedArray2.getResources().obtainTypedArray(positionsId);
                    Intrinsics.checkNotNullExpressionValue((Object)typedArray3, (String)"typedArray.resources.obtainTypedArray(positionsId)");
                    TypedArray floats = typedArray3;
                    this.shaderPositions = new float[floats.length()];
                    int n = 0;
                    int n2 = floats.length();
                    while (n < n2) {
                        void i;
                        this.shaderPositions[i] = floats.getFloat((int)i, 0.0f);
                        ++i;
                    }
                    floats.recycle();
                }
            }
            finally {
                typedArray2.recycle();
            }
        }
        this.resetBackgroundPaint();
        Paint paint6 = this.progressPaint;
        if (paint6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressPaint");
        }
        paint6.setColor(this.progressColor);
        this.setShader(this.shader);
        Paint paint7 = this.progressPaint;
        if (paint7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressPaint");
        }
        paint7.setStrokeCap(this.isProgressRounded ? Paint.Cap.ROUND : Paint.Cap.SQUARE);
        Paint paint8 = this.shadowPaint;
        if (paint8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shadowPaint");
        }
        paint8.setColor(this.adjustAlpha(-16777216, 0.2f));
        Paint paint9 = this.shadowPaint;
        if (paint9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shadowPaint");
        }
        Paint paint10 = this.progressPaint;
        if (paint10 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressPaint");
        }
        paint9.setStrokeCap(paint10.getStrokeCap());
        this.setThickness(this.progressStrokeThickness, false);
    }

    public final void setSize(int size) {
        this.getLayoutParams().height = size;
        this.sizeChanged = true;
        this.requestLayout();
    }

    public final void setColor(int color) {
        this.setProgressColor(color);
        this.setProgressBackgroundColor(color);
    }

    @RequiresApi(api=23)
    public final void setColorResource(@ColorRes int resId) {
        this.setColor(this.getContext().getColor(resId));
    }

    @RequiresApi(api=26)
    public final void setColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.setColor(color.toArgb());
    }

    @RequiresApi(api=23)
    public final void setProgressColorResource(@ColorRes int resId) {
        this.setProgressColor(this.getContext().getColor(resId));
    }

    @RequiresApi(api=26)
    public final void setProgressColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.setProgressColor(color.toArgb());
    }

    @JvmOverloads
    public final void setProgressColors(@ColorInt @NotNull int[] colors, @NotNull float[] positions, boolean duplicateFirst) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)positions, (String)"positions");
        this.shaderColors = duplicateFirst ? this.duplicateFirstColor(colors) : colors;
        this.shaderPositions = positions;
        RectF rectF = this.progressRectF;
        if (rectF == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressRectF");
        }
        float f = rectF.centerX();
        RectF rectF2 = this.progressRectF;
        if (rectF2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressRectF");
        }
        this.setShader((Shader)new SweepGradient(f, rectF2.centerY(), colors, positions));
        this.invalidate();
    }

    public static /* synthetic */ void setProgressColors$default(CircularProgressView circularProgressView, int[] nArray, float[] fArray, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        circularProgressView.setProgressColors(nArray, fArray, bl);
    }

    @JvmOverloads
    public final void setProgressColors(@ColorInt @NotNull int[] colors, @NotNull float[] positions) {
        CircularProgressView.setProgressColors$default(this, colors, positions, false, 4, null);
    }

    private final int[] duplicateFirstColor(@ColorInt int[] colors) {
        int[] nArray = colors;
        int n = colors.length + 1;
        boolean bl = false;
        int[] nArray2 = Arrays.copyOf(nArray, n);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
        nArray = nArray2;
        n = 0;
        bl = false;
        int[] it = nArray;
        boolean bl2 = false;
        it[colors.length] = colors[0];
        return nArray;
    }

    private final void setShader(Shader shader) {
        Paint paint = this.progressPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressPaint");
        }
        paint.setShader(shader);
    }

    @RequiresApi(api=23)
    public final void setShadowColorResource(@ColorRes int resId) {
        this.setBackgroundColor(this.getContext().getColor(resId));
    }

    @RequiresApi(api=26)
    public final void setBackgroundColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.setBackgroundColor(color.toArgb());
    }

    public final void setProgressStrokeThickness(float value) {
        this.setThickness(value, true);
    }

    private final void setThickness(float thickness, boolean requestLayout) {
        this.progressStrokeThickness = thickness;
        this.progressIconThickness = this.progressStrokeThickness / (float)2;
        Paint paint = this.backgroundPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backgroundPaint");
        }
        paint.setStrokeWidth(this.progressStrokeThickness);
        Paint paint2 = this.progressPaint;
        if (paint2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressPaint");
        }
        paint2.setStrokeWidth(this.progressStrokeThickness);
        Iterator<Paint> iterator = this.progressPaintList.iterator();
        while (iterator.hasNext()) {
            Paint paint3;
            Paint paint4 = paint3 = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)paint4, (String)"paint");
            paint4.setStrokeWidth(this.progressStrokeThickness);
        }
        Paint paint5 = this.shadowPaint;
        if (paint5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shadowPaint");
        }
        paint5.setStrokeWidth(this.progressStrokeThickness);
        if (requestLayout) {
            this.requestLayout();
        }
    }

    @JvmOverloads
    public final void setProgress(float progress, boolean animate, long duration) {
        this.setProgress(progress, animate, duration, true);
    }

    public static /* synthetic */ void setProgress$default(CircularProgressView circularProgressView, float f, boolean bl, long l, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            l = 1000;
        }
        circularProgressView.setProgress(f, bl, l);
    }

    @JvmOverloads
    public final void setProgress(float progress, boolean animate) {
        CircularProgressView.setProgress$default(this, progress, animate, 0L, 4, null);
    }

    @JvmOverloads
    public final void setProgress(float progress) {
        CircularProgressView.setProgress$default(this, progress, false, 0L, 6, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void setProgress(@NotNull List<Float> progressList, @NotNull List<Integer> progressColorList) throws RuntimeException {
        Intrinsics.checkNotNullParameter(progressList, (String)"progressList");
        Intrinsics.checkNotNullParameter(progressColorList, (String)"progressColorList");
        this.setProgressRounded(false);
        this.progress = this.progressListTotal = 0.0f;
        Iterator<Float> iterator = progressList.iterator();
        while (iterator.hasNext()) {
            float value = ((Number)iterator.next()).floatValue();
            this.progressListTotal += value;
            if (!(this.progressListTotal > (float)this.max)) continue;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Progress entities sum (%s) is greater than max value (%s)";
            Object[] objectArray = new Object[]{Float.valueOf(this.progressListTotal), this.max};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            throw (Throwable)new RuntimeException(string2);
        }
        this.multipleArcsEnabled = true;
        this.progressList = new ArrayList(progressList);
        this.progressPaintList = new ArrayList();
        int value = 0;
        int n = ((Collection)progressList).size();
        while (value < n) {
            void i;
            Paint paint = new Paint(1);
            paint.setStyle(Paint.Style.STROKE);
            paint.setColor(i < progressColorList.size() ? ((Number)progressColorList.get((int)i)).intValue() : 0);
            this.progressPaintList.add(paint);
            ++i;
        }
        this.setThickness(this.progressStrokeThickness, false);
        this.invalidate();
    }

    @JvmOverloads
    public final void resetProgress(boolean animate, long duration) {
        this.setProgress(0.0f, animate, duration, false);
    }

    public static /* synthetic */ void resetProgress$default(CircularProgressView circularProgressView, boolean bl, long l, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            l = 1000;
        }
        circularProgressView.resetProgress(bl, l);
    }

    @JvmOverloads
    public final void resetProgress(boolean animate) {
        CircularProgressView.resetProgress$default(this, animate, 0L, 2, null);
    }

    @JvmOverloads
    public final void resetProgress() {
        CircularProgressView.resetProgress$default(this, false, 0L, 3, null);
    }

    public final void setAnimationInterpolator(@Nullable TimeInterpolator interpolator) {
        TimeInterpolator timeInterpolator = interpolator;
        if (timeInterpolator == null) {
            timeInterpolator = DEFAULT_INTERPOLATOR;
        }
        this.progressInterpolator = timeInterpolator;
    }

    private final void resetBackgroundPaint() {
        Paint paint = this.backgroundPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backgroundPaint");
        }
        paint.setColor(this.isBackgroundAlphaEnabled ? this.adjustAlpha(this.progressBackgroundColor, 0.3f) : this.progressBackgroundColor);
    }

    private final void setProgress(float progress, boolean animate, long duration, boolean clockwise) {
        this.multipleArcsEnabled = false;
        if (animate) {
            if (this.progressAnimator != null) {
                ValueAnimator valueAnimator = this.progressAnimator;
                if (valueAnimator == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"progressAnimator");
                }
                valueAnimator.cancel();
            }
            ValueAnimator valueAnimator = this.progressAnimator = this.getAnimator(this.progress, clockwise ? (double)progress : 0.0, duration, new ValueAnimator.AnimatorUpdateListener(this, progress){
                final /* synthetic */ CircularProgressView this$0;
                final /* synthetic */ float $progress;

                public final void onAnimationUpdate(ValueAnimator valueAnimator) {
                    block1: {
                        ValueAnimator valueAnimator2 = valueAnimator;
                        Intrinsics.checkNotNullExpressionValue((Object)valueAnimator2, (String)"valueAnimator");
                        Object object = valueAnimator2.getAnimatedValue();
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                        }
                        CircularProgressView.access$setProgressValue(this.this$0, ((Float)object).floatValue());
                        CircularProgressViewActionCallback circularProgressViewActionCallback = this.this$0.getActionCallback();
                        if (circularProgressViewActionCallback == null) break block1;
                        circularProgressViewActionCallback.onProgressChanged(this.$progress);
                    }
                }
                {
                    this.this$0 = circularProgressView;
                    this.$progress = f;
                }
            });
            if (valueAnimator == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"progressAnimator");
            }
            valueAnimator.addListener(new Animator.AnimatorListener(this, progress){
                final /* synthetic */ CircularProgressView this$0;
                final /* synthetic */ float $progress;

                public void onAnimationEnd(@NotNull Animator animation) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                        CircularProgressViewActionCallback circularProgressViewActionCallback = this.this$0.getActionCallback();
                        if (circularProgressViewActionCallback == null) break block0;
                        circularProgressViewActionCallback.onAnimationFinished(this.$progress);
                    }
                }

                public void onAnimationStart(@NotNull Animator animation) {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                }

                public void onAnimationCancel(@NotNull Animator animation) {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                }

                public void onAnimationRepeat(@NotNull Animator animation) {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                }
                {
                    this.this$0 = this$0;
                    this.$progress = $captured_local_variable$1;
                }
            });
            ValueAnimator valueAnimator2 = this.progressAnimator;
            if (valueAnimator2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"progressAnimator");
            }
            valueAnimator2.start();
        } else {
            this.setProgressValue(progress);
        }
    }

    private final void setProgressValue(float value) {
        this.progress = value;
        this.invalidate();
    }

    private final ValueAnimator getAnimator(double current, double next, long duration, ValueAnimator.AnimatorUpdateListener updateListener) {
        ValueAnimator valueAnimator = new ValueAnimator();
        boolean bl = false;
        boolean bl2 = false;
        ValueAnimator $this$apply = valueAnimator;
        boolean bl3 = false;
        $this$apply.setInterpolator(this.progressInterpolator);
        $this$apply.setDuration(duration);
        $this$apply.setObjectValues(new Object[]{current, next});
        $this$apply.setEvaluator((TypeEvaluator)new FloatEvaluator(){

            public final int evaluate(float fraction, float startValue, float endValue) {
                return MathKt.roundToInt((float)(startValue + (endValue - startValue) * fraction));
            }
        });
        $this$apply.addUpdateListener(updateListener);
        return valueAnimator;
    }

    private final int adjustAlpha(int color, float factor) {
        int alpha = MathKt.roundToInt((float)((float)Color.alpha((int)color) * factor));
        int red = Color.red((int)color);
        int green = Color.green((int)color);
        int blue = Color.blue((int)color);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        float thumbSize;
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getMode((int)heightMeasureSpec) != 0 ? View.MeasureSpec.getSize((int)heightMeasureSpec) : this.defaultMaxWidth;
        int n = 0;
        n = Math.min(width, height);
        int n2 = 0;
        boolean bl = false;
        int rawMeasuredDim = Math.max(n, n2);
        float progressWidth = this.progressStrokeThickness;
        switch (CircularProgressView$WhenMappings.$EnumSwitchMapping$0[this.progressThumbScaleType.ordinal()]) {
            case 1: {
                float f = this.progressThumbSize;
                break;
            }
            case 2: {
                float f = this.progressStrokeThickness / (float)2 * this.progressThumbSizeRate;
                break;
            }
            default: {
                float f = thumbSize = this.progressStrokeThickness;
            }
        }
        if (this.isProgressThumbEnabled && this.progressThumbScaleType != ProgressThumbScaleType.AUTO) {
            progressWidth = thumbSize * (float)2 > this.progressStrokeThickness ? (progressWidth += thumbSize - this.progressStrokeThickness) : this.progressStrokeThickness / (float)2;
        }
        float f = 0.0f;
        boolean bl2 = false;
        float arcDim = Math.max(progressWidth, f) + this.defaultViewPadding;
        RectF rectF = this.progressRectF;
        if (rectF == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressRectF");
        }
        rectF.set(arcDim, arcDim, (float)rawMeasuredDim - arcDim, (float)rawMeasuredDim - arcDim);
        RectF rectF2 = this.progressRectF;
        if (rectF2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressRectF");
        }
        boolean bl3 = false;
        if (rectF2.width() <= Math.max(progressWidth, thumbSize)) {
            arcDim = this.lastValidRawMeasuredDim;
            RectF rectF3 = this.progressRectF;
            if (rectF3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"progressRectF");
            }
            rectF3.set(arcDim, arcDim, (float)rawMeasuredDim - arcDim, (float)rawMeasuredDim - arcDim);
            this.setThickness(this.lastValidStrokeThickness, false);
            this.progressThumbSize = this.lastValidThumbSize;
            float f2 = this.lastValidThumbSizeRate;
            float f3 = this.progressMaxThumbSizeRate;
            boolean bl4 = false;
            f2 = Math.min(f2, f3);
            f3 = 0.0f;
            bl4 = false;
            this.progressThumbSizeRate = Math.max(f2, f3);
        } else {
            this.lastValidRawMeasuredDim = arcDim;
            this.lastValidStrokeThickness = this.progressStrokeThickness;
            this.lastValidThumbSize = this.progressThumbSize;
            this.lastValidThumbSizeRate = this.progressThumbSizeRate;
        }
        RectF rectF4 = this.shadowRectF;
        if (rectF4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shadowRectF");
        }
        RectF rectF5 = this.progressRectF;
        if (rectF5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressRectF");
        }
        float f4 = rectF5.left;
        RectF rectF6 = this.progressRectF;
        if (rectF6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressRectF");
        }
        float f5 = this.defaultShadowPadding + rectF6.top;
        RectF rectF7 = this.progressRectF;
        if (rectF7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressRectF");
        }
        float f6 = rectF7.right;
        RectF rectF8 = this.progressRectF;
        if (rectF8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressRectF");
        }
        rectF4.set(f4, f5, f6, this.defaultShadowPadding + rectF8.bottom);
        this.setMeasuredDimension(rawMeasuredDim, rawMeasuredDim);
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized void onDraw(@NotNull Canvas canvas) {
        int n;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        this.valuesToDrawList.clear();
        if (!this.multipleArcsEnabled) {
            this.valuesToDrawList.add(Float.valueOf(this.progress));
            this.progressPaintList.clear();
            Paint paint = this.progressPaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"progressPaint");
            }
            this.progressPaintList.add(paint);
        } else {
            this.valuesToDrawList.addAll((Collection<Float>)this.progressList);
        }
        float angle = 0.0f;
        float previousAngle = this.startingAngle;
        float radius = (float)this.getWidth() / (float)2 - this.defaultViewPadding;
        float thumbSize = 0.0f;
        if (this.progressThumbScaleType == ProgressThumbScaleType.AUTO) {
            thumbSize = this.progressIconThickness;
            radius -= this.progressIconThickness + this.progressStrokeThickness / (float)2;
        } else {
            boolean isThicker = false;
            if (this.progressThumbScaleType == ProgressThumbScaleType.POINT) {
                thumbSize = this.progressThumbSize;
                isThicker = this.progressThumbSize * (float)2 > this.progressStrokeThickness;
            } else if (this.progressThumbScaleType == ProgressThumbScaleType.RATE) {
                thumbSize = this.progressStrokeThickness / (float)2 * this.progressThumbSizeRate;
                isThicker = this.progressThumbSizeRate > 1.0f;
            }
            radius -= isThicker ? thumbSize : this.progressStrokeThickness / (float)2;
        }
        double endX = 0.0;
        double endY = 0.0;
        if (this.isShadowEnabled) {
            angle = (float)360 * (this.multipleArcsEnabled ? this.progressListTotal : this.progress) / (float)this.max;
            if (this.isReverseEnabled) {
                angle *= -1.0f;
            }
            if (!this.multipleArcsEnabled && this.isProgressThumbEnabled) {
                double d = Math.toRadians((double)previousAngle + (double)angle);
                boolean bl = false;
                endX = Math.cos(d) * (double)radius;
                d = Math.toRadians((double)previousAngle + (double)angle);
                bl = false;
                endY = Math.sin(d) * (double)radius;
                Paint paint = this.shadowThumbPaint;
                if (paint == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"shadowThumbPaint");
                }
                Paint paint2 = this.shadowPaint;
                if (paint2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"shadowPaint");
                }
                paint.set(paint2);
                switch (CircularProgressView$WhenMappings.$EnumSwitchMapping$1[this.progressThumbScaleType.ordinal()]) {
                    case 1: 
                    case 2: {
                        Paint paint3 = this.shadowThumbPaint;
                        if (paint3 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"shadowThumbPaint");
                        }
                        paint3.setStyle(Paint.Style.FILL);
                        break;
                    }
                    default: {
                        Paint paint4 = this.shadowThumbPaint;
                        if (paint4 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"shadowThumbPaint");
                        }
                        paint4.setStyle(Paint.Style.STROKE);
                    }
                }
                float f = (float)endX;
                RectF rectF = this.shadowRectF;
                if (rectF == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"shadowRectF");
                }
                float f2 = f + rectF.centerX();
                float f3 = (float)endY;
                RectF rectF2 = this.shadowRectF;
                if (rectF2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"shadowRectF");
                }
                float f4 = f3 + rectF2.centerY();
                Paint paint5 = this.shadowThumbPaint;
                if (paint5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"shadowThumbPaint");
                }
                canvas.drawCircle(f2, f4, thumbSize, paint5);
            }
            RectF rectF = this.shadowRectF;
            if (rectF == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"shadowRectF");
            }
            Paint paint = this.shadowPaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"shadowPaint");
            }
            canvas.drawArc(rectF, previousAngle, angle, false, paint);
        }
        if (this.initShader) {
            this.initShader = false;
            RectF rectF = this.progressRectF;
            if (rectF == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"progressRectF");
            }
            float f = rectF.centerX();
            RectF rectF3 = this.progressRectF;
            if (rectF3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"progressRectF");
            }
            float[] fArray = this.shaderPositions;
            n = 0;
            this.setShader((Shader)new SweepGradient(f, rectF3.centerY(), this.shaderColors, fArray.length == 0 ? null : this.shaderPositions));
        } else if (this.sizeChanged) {
            this.sizeChanged = false;
            RectF rectF = this.progressRectF;
            if (rectF == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"progressRectF");
            }
            float f = rectF.centerX();
            RectF rectF4 = this.progressRectF;
            if (rectF4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"progressRectF");
            }
            float[] fArray = this.shaderPositions;
            n = 0;
            this.setShader((Shader)new SweepGradient(f, rectF4.centerY(), this.shaderColors, fArray.length == 0 ? null : this.shaderPositions));
        }
        int n2 = 0;
        n = ((Collection)this.valuesToDrawList).size();
        while (n2 < n) {
            void i;
            if (!this.multipleArcsEnabled) {
                RectF rectF = this.progressRectF;
                if (rectF == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"progressRectF");
                }
                Paint paint = this.backgroundPaint;
                if (paint == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"backgroundPaint");
                }
                canvas.drawOval(rectF, paint);
            }
            angle = (float)360 * ((Number)this.valuesToDrawList.get((int)i)).floatValue() / (float)this.max;
            if (this.isReverseEnabled) {
                angle *= -1.0f;
            }
            float offset = !this.isReverseEnabled && this.multipleArcsEnabled ? 6.0f : 0.0f;
            RectF rectF = this.progressRectF;
            if (rectF == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"progressRectF");
            }
            canvas.drawArc(rectF, previousAngle - offset, angle + offset, false, this.progressPaintList.get((int)i));
            if (!this.multipleArcsEnabled && this.isProgressThumbEnabled) {
                double d = Math.toRadians((double)previousAngle + (double)angle);
                boolean bl = false;
                endX = Math.cos(d) * (double)radius;
                d = Math.toRadians((double)previousAngle + (double)angle);
                bl = false;
                endY = Math.sin(d) * (double)radius;
                Paint paint = this.thumbPaint;
                if (paint == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"thumbPaint");
                }
                paint.set(this.progressPaintList.get((int)i));
                switch (CircularProgressView$WhenMappings.$EnumSwitchMapping$2[this.progressThumbScaleType.ordinal()]) {
                    case 1: 
                    case 2: {
                        Paint paint6 = this.thumbPaint;
                        if (paint6 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"thumbPaint");
                        }
                        paint6.setStyle(Paint.Style.FILL);
                        break;
                    }
                    default: {
                        Paint paint7 = this.thumbPaint;
                        if (paint7 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"thumbPaint");
                        }
                        paint7.setStyle(Paint.Style.STROKE);
                    }
                }
                float f = (float)endX;
                RectF rectF5 = this.progressRectF;
                if (rectF5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"progressRectF");
                }
                float f5 = f + rectF5.centerX();
                float f6 = (float)endY;
                RectF rectF6 = this.progressRectF;
                if (rectF6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"progressRectF");
                }
                float f7 = f6 + rectF6.centerY();
                Paint paint8 = this.thumbPaint;
                if (paint8 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"thumbPaint");
                }
                canvas.drawCircle(f5, f7, thumbSize, paint8);
            }
            previousAngle += angle;
            ++i;
        }
    }

    private final int dpToPx(float dp) {
        double d = dp;
        Resources resources = Resources.getSystem();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
        double d2 = d * (double)resources.getDisplayMetrics().density;
        boolean bl = false;
        return (int)Math.ceil(d2);
    }

    @JvmOverloads
    public CircularProgressView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.defaultViewPadding = this.dpToPx(10.0f);
        this.defaultShadowPadding = this.dpToPx(5.0f);
        this.defaultStrokeThickness = this.dpToPx(10.0f);
        this.defaultThumbSize = this.dpToPx(10.0f);
        this.defaultMaxWidth = this.dpToPx(100);
        this.valuesToDrawList = new ArrayList();
        this.progressList = new ArrayList();
        this.progressPaintList = new ArrayList();
        this.progressThumbSizeRate = 2.0f;
        this.progressStrokeThickness = this.defaultStrokeThickness;
        this.lastValidStrokeThickness = this.defaultStrokeThickness;
        this.lastValidThumbSize = this.defaultThumbSize;
        this.lastValidThumbSizeRate = 2.0f;
        this.progressInterpolator = DEFAULT_INTERPOLATOR;
        this.shaderColors = new int[0];
        this.shaderPositions = new float[0];
        this.progressThumbScaleType = ProgressThumbScaleType.AUTO;
        this.progressMaxThumbSizeRate = 2.0f;
        this.progressThumbSize = this.defaultThumbSize;
        this.isShadowEnabled = true;
        this.progressColor = -16777216;
        this.progressBackgroundColor = -16777216;
        this.startingAngle = 270;
        this.max = 100;
        this.setupAttr(context, attrs);
    }

    public /* synthetic */ CircularProgressView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public CircularProgressView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CircularProgressView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    static {
        Companion = new Companion(null);
        DEFAULT_INTERPOLATOR = (TimeInterpolator)new DecelerateInterpolator();
    }

    public static final /* synthetic */ ValueAnimator access$getProgressAnimator$p(CircularProgressView $this) {
        ValueAnimator valueAnimator = $this.progressAnimator;
        if (valueAnimator == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressAnimator");
        }
        return valueAnimator;
    }

    public static final /* synthetic */ void access$setProgressAnimator$p(CircularProgressView $this, ValueAnimator valueAnimator) {
        $this.progressAnimator = valueAnimator;
    }

    public static final /* synthetic */ void access$setProgressValue(CircularProgressView $this, float value) {
        $this.setProgressValue(value);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/github/guilhe/views/CircularProgressView$CircularProgressViewActionCallback;", "", "onAnimationFinished", "", "progress", "", "onProgressChanged", "circular-progress-view_release"})
    public static interface CircularProgressViewActionCallback {
        public void onProgressChanged(float var1);

        public void onAnimationFinished(float var1);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/github/guilhe/views/CircularProgressView$Companion;", "", "()V", "ANGLE_OFFSET_FOR_MULTIPLE_ARC_PROGRESS", "", "DEFAULT_ANIMATION_MILLIS", "", "DEFAULT_BACKGROUND_ALPHA", "DEFAULT_INTERPOLATOR", "Landroid/animation/TimeInterpolator;", "DEFAULT_MAX", "DEFAULT_MAXIMUM_THUMB_SIZE_RATE", "DEFAULT_MAX_WIDTH_DP", "DEFAULT_PROGRESS_COLOR", "DEFAULT_SHADOW_PADDING_DP", "DEFAULT_STARTING_ANGLE", "DEFAULT_STROKE_THICKNESS_DP", "DEFAULT_THUMB_SIZE_DP", "DEFAULT_VIEW_PADDING_DP", "circular-progress-view_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

