/*
 * Decompiled with CFR 0.152.
 */
package com.github.guanpy.library;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.github.guanpy.library.EventReceiver;
import com.github.guanpy.library.inner.ClassSpecRegistry;
import com.github.guanpy.library.inner.base.MethodSpec;
import com.github.guanpy.library.inner.bus.ReceiveEventsAnn;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;

public class EventBus {
    private static final String TAG = "EventBus";
    private static final String ALL = "_all_";
    private static final ConcurrentHashMap<String, ConcurrentHashMap<EventReceiver<Object>, Boolean>> eventNameToReceivers = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Object> stickyEvents = new ConcurrentHashMap();
    private static Handler handler;

    public static void postEvent(String name) {
        EventBus.postEvent(name, null);
    }

    public static void postEvent(String name, Object data) {
        EventBus.runOnUiThread(new PostEventRunnable(name, data));
    }

    public static void postEventSticky(String name) {
        EventBus.postEventSticky(name, new Object());
    }

    public static void postEventSticky(String name, Object data) {
        stickyEvents.put(name, data);
        EventBus.postEvent(name, data);
    }

    public static void clearStickyEvents(String ... eventNames) {
        boolean allEvents;
        boolean bl = allEvents = eventNames.length == 0;
        if (allEvents) {
            stickyEvents.clear();
        } else {
            HashSet<String> nameSet = new HashSet<String>(Arrays.asList(eventNames));
            for (String eventName : stickyEvents.keySet()) {
                if (!nameSet.contains(eventName)) continue;
                stickyEvents.remove(eventName);
                break;
            }
        }
    }

    public static void registerReceiver(EventReceiver<?> receiver, String ... eventNames) {
        boolean allEvents;
        EventReceiver<Object> rec = receiver;
        boolean bl = allEvents = eventNames.length == 0;
        if (allEvents) {
            for (String name : stickyEvents.keySet()) {
                EventBus.notifyReceiver(rec, name, stickyEvents.get(name));
            }
            EventBus.receiversForEventName(ALL).put(rec, Boolean.FALSE);
        } else {
            for (String name : eventNames) {
                Object data = stickyEvents.get(name);
                if (data == null) continue;
                EventBus.notifyReceiver(rec, name, data);
            }
            for (String action : eventNames) {
                EventBus.receiversForEventName(action).put(rec, Boolean.FALSE);
            }
        }
    }

    public static void unregisterReceiver(EventReceiver<?> receiver) {
        EventBus.receiversForEventName(ALL).remove(receiver);
        for (String eventName : eventNameToReceivers.keySet()) {
            ConcurrentHashMap<EventReceiver<Object>, Boolean> receivers = eventNameToReceivers.get(eventName);
            receivers.remove(receiver);
            if (!receivers.isEmpty()) continue;
            eventNameToReceivers.remove(eventName);
        }
    }

    public static void registerAnnotatedReceiver(Object obj) {
        MethodSpec<ReceiveEventsAnn>[] specs;
        for (MethodSpec<ReceiveEventsAnn> spec : specs = ClassSpecRegistry.getReceiveEventsSpecs(obj.getClass())) {
            EventBus.registerReceiver(new ReflectiveReceiver(obj, spec), ((ReceiveEventsAnn)spec.ann).names);
        }
    }

    public static void unregisterAnnotatedReceiver(Object obj) {
        for (ConcurrentHashMap<EventReceiver<Object>, Boolean> receivers : eventNameToReceivers.values()) {
            for (EventReceiver receiver : receivers.keySet()) {
                if (!(receiver instanceof ReflectiveReceiver) || obj != ((ReflectiveReceiver)receiver).objectRef.get()) continue;
                receivers.remove(receiver);
            }
        }
    }

    private static ConcurrentHashMap<EventReceiver<Object>, Boolean> receiversForEventName(String name) {
        ConcurrentHashMap<EventReceiver<Object>, Boolean> map = eventNameToReceivers.get(name);
        if (map == null) {
            map = new ConcurrentHashMap();
            eventNameToReceivers.put(name, map);
        }
        return map;
    }

    private static void notifyReceiver(EventReceiver<Object> receiver, String event, Object data) {
        try {
            receiver.onEvent(event, data);
        }
        catch (IllegalArgumentException e) {
            String info = String.format("Failed to deliver event %s to %s: %s.", event, receiver.getClass().getName(), e.getMessage());
            Log.wtf((String)TAG, (String)info);
        }
        catch (Exception e) {
            Log.wtf((String)TAG, (Throwable)e);
            Log.wtf((String)TAG, (String)"Receiver unregistered.");
            EventBus.unregisterReceiver(receiver);
        }
    }

    private static void runOnUiThread(Runnable r) {
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper());
        }
        boolean success = handler.post(r);
        while (!success) {
            handler = null;
            EventBus.runOnUiThread(r);
        }
    }

    private static class ReflectiveReceiver
    implements EventReceiver<Object> {
        final WeakReference<Object> objectRef;
        final MethodSpec<ReceiveEventsAnn> spec;

        ReflectiveReceiver(Object object, MethodSpec<ReceiveEventsAnn> spec) {
            this.objectRef = new WeakReference<Object>(object);
            this.spec = spec;
        }

        @Override
        public void onEvent(String name, Object data) {
            try {
                Object obj = this.objectRef.get();
                switch (this.spec.paramTypes.length) {
                    case 0: {
                        this.spec.method.invoke(obj, new Object[0]);
                        break;
                    }
                    case 1: {
                        if (this.spec.paramTypes[0] == String.class) {
                            this.spec.method.invoke(obj, name);
                            break;
                        }
                        this.spec.method.invoke(obj, data);
                        break;
                    }
                    default: {
                        this.spec.method.invoke(obj, name, data);
                        break;
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static class PostEventRunnable
    implements Runnable {
        private final String name;
        private final Object data;

        public PostEventRunnable(String name, Object data) {
            this.name = name;
            this.data = data;
        }

        @Override
        public void run() {
            HashSet receivers = new HashSet();
            receivers.addAll(EventBus.receiversForEventName(EventBus.ALL).keySet());
            receivers.addAll(EventBus.receiversForEventName(this.name).keySet());
            for (EventReceiver rec : receivers) {
                EventBus.notifyReceiver(rec, this.name, this.data);
            }
        }
    }
}

