/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java.repository;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import growthbook.sdk.java.callback.FeatureRefreshCallback;
import growthbook.sdk.java.exception.FeatureFetchException;
import growthbook.sdk.java.repository.IGBFeaturesRepository;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalGbFeatureRepository
implements IGBFeaturesRepository {
    private static final Logger log = LoggerFactory.getLogger(LocalGbFeatureRepository.class);
    private String featuresJson = "{}";
    private final String jsonPath;

    @Override
    public void initialize() throws FeatureFetchException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        String resourcesDirectory = this.getResourceDirectoryPath();
        String fullPath = resourcesDirectory + this.validateUserJsonPath(this.jsonPath);
        try {
            JsonObject featuresJsonObject = (JsonObject)gson.fromJson((Reader)new FileReader(fullPath), JsonObject.class);
            this.featuresJson = featuresJsonObject.toString();
            log.info("LocalGbFeatureRepository load features from {} successfully", (Object)fullPath);
            log.info("Features: {}", (Object)this.featuresJson);
        }
        catch (FileNotFoundException e) {
            log.error("LocalGbFeatureRepository cannot load features from {}, Exception was: {}", new Object[]{fullPath, e.getMessage(), e});
            throw new FeatureFetchException(FeatureFetchException.FeatureFetchErrorCode.CONFIGURATION_ERROR, "Failed to load features from: " + fullPath);
        }
    }

    @Override
    public void initialize(Boolean retryOnFailure) {
    }

    @Override
    public String getFeaturesJson() {
        return this.featuresJson;
    }

    @Override
    public void onFeaturesRefresh(FeatureRefreshCallback callback) {
    }

    @Override
    public void clearCallbacks() {
    }

    private String getResourceDirectoryPath() {
        Path resourceDirectory = Paths.get("src", "main", "resources");
        return resourceDirectory.toFile().getAbsolutePath();
    }

    private String validateUserJsonPath(String jsonPath) {
        if (!jsonPath.startsWith("/")) {
            jsonPath = "/" + jsonPath;
        }
        if (!jsonPath.endsWith(".json")) {
            jsonPath = jsonPath + ".json";
        }
        return jsonPath;
    }

    public LocalGbFeatureRepository(String jsonPath) {
        this.jsonPath = jsonPath;
    }
}

