/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java.evaluators;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import growthbook.sdk.java.evaluators.IConditionEvaluator;
import growthbook.sdk.java.model.DataType;
import growthbook.sdk.java.model.Operator;
import growthbook.sdk.java.util.GrowthBookJsonUtils;
import growthbook.sdk.java.util.StringUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionEvaluator
implements IConditionEvaluator {
    private static final Logger log = LoggerFactory.getLogger(ConditionEvaluator.class);
    private final GrowthBookJsonUtils jsonUtils = GrowthBookJsonUtils.getInstance();

    @Override
    public Boolean evaluateCondition(JsonObject attributes, JsonObject conditionJson, @Nullable JsonObject savedGroups) {
        try {
            block16: for (Map.Entry entry : conditionJson.entrySet()) {
                String key = (String)entry.getKey();
                JsonElement value = (JsonElement)entry.getValue();
                switch (key) {
                    case "$or": {
                        JsonArray orTargetItems = value.getAsJsonArray();
                        if (orTargetItems == null || this.evalOr((JsonElement)attributes, orTargetItems, savedGroups).booleanValue()) continue block16;
                        return false;
                    }
                    case "$nor": {
                        JsonArray norTargetItems = value.getAsJsonArray();
                        if (norTargetItems == null || !this.evalOr((JsonElement)attributes, norTargetItems, savedGroups).booleanValue()) continue block16;
                        return false;
                    }
                    case "$and": {
                        JsonArray andTargetItems = value.getAsJsonArray();
                        if (andTargetItems == null || this.evalAnd((JsonElement)attributes, andTargetItems, savedGroups).booleanValue()) continue block16;
                        return false;
                    }
                    case "$not": {
                        if (value == null || !this.evaluateCondition(attributes, value.getAsJsonObject(), savedGroups).booleanValue()) continue block16;
                        return false;
                    }
                }
                JsonElement element = (JsonElement)this.getPath((JsonElement)attributes, key);
                if (this.evalConditionValue(value, element, savedGroups).booleanValue()) continue;
                return false;
            }
            return true;
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            log.error(jsonSyntaxException.getMessage(), (Throwable)jsonSyntaxException);
            return false;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            log.error(patternSyntaxException.getMessage(), (Throwable)patternSyntaxException);
            return false;
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public Boolean isOperatorObject(JsonElement object) {
        if (!object.isJsonObject()) {
            return false;
        }
        Set entries = ((JsonObject)object).entrySet();
        if (entries.isEmpty()) {
            return true;
        }
        long without$Prefix = entries.stream().filter(o -> !((String)o.getKey()).startsWith("$")).count();
        return without$Prefix == 0L;
    }

    @Nullable
    public Object getPath(JsonElement attributes, String path) {
        if (Objects.equals(path, "")) {
            return null;
        }
        ArrayList<String> paths = new ArrayList<String>();
        if (path.contains(".")) {
            String[] pathSegments = path.split("\\.");
            Collections.addAll(paths, pathSegments);
        } else {
            paths.add(path);
        }
        JsonElement element = attributes;
        for (String segment : paths) {
            if (element == null || element instanceof JsonArray) {
                return null;
            }
            if (element instanceof JsonObject) {
                element = ((JsonObject)element).get(segment);
                continue;
            }
            return null;
        }
        return element;
    }

    Boolean evalOperatorCondition(String operatorString, @Nullable JsonElement actual, JsonElement expected, @Nullable JsonObject savedGroups) {
        Operator operator = Operator.fromString(operatorString);
        if (operator == null) {
            return false;
        }
        DataType attributeDataType = GrowthBookJsonUtils.getElementType(actual);
        switch (operator) {
            case IN: {
                if (actual == null) {
                    return false;
                }
                if (DataType.ARRAY == attributeDataType) {
                    if (!expected.isJsonArray()) {
                        return false;
                    }
                    JsonArray value = actual.getAsJsonArray();
                    JsonArray expectedArr = expected.getAsJsonArray();
                    return this.isIn((JsonElement)value, expectedArr);
                }
                if (DataType.STRING == attributeDataType) {
                    String value = actual.getAsString();
                    Type listType = new TypeToken<ArrayList<String>>(){}.getType();
                    ArrayList conditionsList = (ArrayList)this.jsonUtils.gson.fromJson(expected, listType);
                    return conditionsList.contains(value);
                }
                if (DataType.NUMBER == attributeDataType) {
                    Float value = Float.valueOf(actual.getAsFloat());
                    Type listType = new TypeToken<ArrayList<Float>>(){}.getType();
                    ArrayList conditionsList = (ArrayList)this.jsonUtils.gson.fromJson(expected, listType);
                    return conditionsList.contains(value);
                }
                if (DataType.BOOLEAN != attributeDataType) break;
                Boolean value = actual.getAsBoolean();
                Type listType = new TypeToken<ArrayList<Boolean>>(){}.getType();
                ArrayList conditionsList = (ArrayList)this.jsonUtils.gson.fromJson(expected, listType);
                return conditionsList.contains(value);
            }
            case NIN: {
                if (actual == null) {
                    return false;
                }
                if (DataType.ARRAY == attributeDataType) {
                    JsonArray expectedArr;
                    if (!expected.isJsonArray()) {
                        return false;
                    }
                    JsonArray value = actual.getAsJsonArray();
                    return this.isIn((JsonElement)value, expectedArr = expected.getAsJsonArray()) == false;
                }
                if (DataType.STRING == attributeDataType) {
                    String value = actual.getAsString();
                    Type listType = new TypeToken<ArrayList<String>>(){}.getType();
                    ArrayList conditionsList = (ArrayList)this.jsonUtils.gson.fromJson(expected, listType);
                    return !conditionsList.contains(value);
                }
                if (DataType.NUMBER == attributeDataType) {
                    Float value = Float.valueOf(actual.getAsFloat());
                    Type listType = new TypeToken<ArrayList<Float>>(){}.getType();
                    ArrayList conditionsList = (ArrayList)this.jsonUtils.gson.fromJson(expected, listType);
                    return !conditionsList.contains(value);
                }
                if (DataType.BOOLEAN != attributeDataType) break;
                Boolean value = actual.getAsBoolean();
                Type listType = new TypeToken<ArrayList<Boolean>>(){}.getType();
                ArrayList conditionsList = (ArrayList)this.jsonUtils.gson.fromJson(expected, listType);
                return !conditionsList.contains(value);
            }
            case GT: {
                if (actual == null || DataType.NULL.equals((Object)attributeDataType)) {
                    return (!expected.isJsonPrimitive() || expected.getAsJsonPrimitive().isNumber()) && 0.0 > expected.getAsDouble();
                }
                if (actual.getAsJsonPrimitive().isNumber()) {
                    return actual.getAsNumber().floatValue() > expected.getAsNumber().floatValue();
                }
                if (!actual.getAsJsonPrimitive().isString()) break;
                return actual.getAsString().compareTo(expected.getAsString()) > 0;
            }
            case GTE: {
                if (actual == null || DataType.NULL.equals((Object)attributeDataType)) {
                    return (!expected.isJsonPrimitive() || expected.getAsJsonPrimitive().isNumber()) && 0.0 >= expected.getAsDouble();
                }
                if (actual.getAsJsonPrimitive().isNumber()) {
                    return actual.getAsNumber().floatValue() >= expected.getAsNumber().floatValue();
                }
                if (!actual.getAsJsonPrimitive().isString()) break;
                return actual.getAsString().compareTo(expected.getAsString()) >= 0;
            }
            case LT: {
                if (actual == null || DataType.NULL.equals((Object)attributeDataType)) {
                    return (!expected.isJsonPrimitive() || expected.getAsJsonPrimitive().isNumber()) && 0.0 < expected.getAsDouble();
                }
                if (actual.getAsString().toLowerCase().matches("\\d+")) {
                    return Double.parseDouble(actual.getAsString()) < expected.getAsDouble();
                }
                if (actual.getAsJsonPrimitive().isNumber()) {
                    return actual.getAsNumber().floatValue() < expected.getAsNumber().floatValue();
                }
                if (!actual.getAsJsonPrimitive().isString()) break;
                return actual.getAsString().compareTo(expected.getAsString()) < 0;
            }
            case LTE: {
                if (actual == null || DataType.NULL.equals((Object)attributeDataType)) {
                    return (!expected.isJsonPrimitive() || expected.getAsJsonPrimitive().isNumber()) && 0.0 <= expected.getAsDouble();
                }
                if (actual.getAsJsonPrimitive().isNumber()) {
                    return actual.getAsNumber().floatValue() <= expected.getAsNumber().floatValue();
                }
                if (!actual.getAsJsonPrimitive().isString()) break;
                return actual.getAsString().compareTo(expected.getAsString()) <= 0;
            }
            case REGEX: {
                if (actual == null || DataType.NULL.equals((Object)attributeDataType)) {
                    return false;
                }
                Pattern pattern = Pattern.compile(expected.getAsString());
                Matcher matcher = pattern.matcher(actual.getAsString());
                boolean matches = false;
                while (matcher.find()) {
                    matches = true;
                }
                return matches;
            }
            case NE: {
                if (DataType.NULL.equals((Object)attributeDataType)) {
                    return false;
                }
                return !Objects.equals(actual, expected);
            }
            case EQ: {
                if (actual == null || DataType.NULL.equals((Object)attributeDataType)) {
                    return false;
                }
                return this.arePrimitivesEqual(actual.getAsJsonPrimitive(), expected.getAsJsonPrimitive(), attributeDataType);
            }
            case SIZE: {
                if (actual == null || !actual.isJsonArray()) {
                    return false;
                }
                JsonArray attributeValueArrayForSize = (JsonArray)actual;
                JsonPrimitive size = new JsonPrimitive((Number)attributeValueArrayForSize.size());
                return this.evalConditionValue(expected, (JsonElement)size, savedGroups);
            }
            case ELEMENT_MATCH: {
                if (actual == null) {
                    return false;
                }
                return this.elemMatch(actual, expected, savedGroups);
            }
            case ALL: {
                if (actual == null || !actual.isJsonArray()) {
                    return false;
                }
                JsonArray actualArrayForAll = (JsonArray)actual;
                JsonArray expectedArrayForAll = (JsonArray)expected;
                for (int i = 0; i < expectedArrayForAll.size(); ++i) {
                    boolean passed = false;
                    for (int j = 0; j < actualArrayForAll.size(); ++j) {
                        if (!this.evalConditionValue(expectedArrayForAll.get(i), actualArrayForAll.get(j), savedGroups).booleanValue()) continue;
                        passed = true;
                        break;
                    }
                    if (passed) continue;
                    return false;
                }
                return true;
            }
            case NOT: {
                return this.evalConditionValue(expected, actual, savedGroups) == false;
            }
            case TYPE: {
                return GrowthBookJsonUtils.getElementType(actual).toString().equals(expected.getAsString());
            }
            case EXISTS: {
                boolean exists = expected.getAsBoolean();
                if (exists) {
                    return actual != null;
                }
                return actual == null || actual.isJsonNull();
            }
            case VERSION_GT: {
                if (actual == null || expected == null || DataType.NULL.equals((Object)attributeDataType)) {
                    return false;
                }
                return StringUtils.paddedVersionString(actual.getAsString()).compareTo(StringUtils.paddedVersionString(expected.getAsString())) > 0;
            }
            case VERSION_GTE: {
                if (actual == null || expected == null || DataType.NULL.equals((Object)attributeDataType)) {
                    return false;
                }
                return StringUtils.paddedVersionString(actual.getAsString()).compareTo(StringUtils.paddedVersionString(expected.getAsString())) >= 0;
            }
            case VERSION_LT: {
                if (actual == null || expected == null || DataType.NULL.equals((Object)attributeDataType)) {
                    return false;
                }
                return StringUtils.paddedVersionString(actual.getAsString()).compareTo(StringUtils.paddedVersionString(expected.getAsString())) < 0;
            }
            case VERSION_LTE: {
                if (actual == null || expected == null || DataType.NULL.equals((Object)attributeDataType)) {
                    return false;
                }
                return StringUtils.paddedVersionString(actual.getAsString()).compareTo(StringUtils.paddedVersionString(expected.getAsString())) <= 0;
            }
            case VERSION_NE: {
                if (actual == null || expected == null || DataType.NULL.equals((Object)attributeDataType)) {
                    return false;
                }
                return StringUtils.paddedVersionString(actual.getAsString()).compareTo(StringUtils.paddedVersionString(expected.getAsString())) != 0;
            }
            case VERSION_EQ: {
                if (actual == null || expected == null || DataType.NULL.equals((Object)attributeDataType)) {
                    return false;
                }
                return StringUtils.paddedVersionString(actual.getAsString()).compareTo(StringUtils.paddedVersionString(expected.getAsString())) == 0;
            }
            case IN_GROUP: {
                if (actual != null && expected != null) {
                    JsonElement jsonElement;
                    JsonElement jsonElement2 = jsonElement = savedGroups != null ? savedGroups.get(expected.getAsString()) : null;
                    if (jsonElement != null) {
                        return this.isIn(actual, jsonElement.getAsJsonArray());
                    }
                    return this.isIn(actual, new JsonArray());
                }
            }
            case NOT_IN_GROUP: {
                if (actual != null && expected != null) {
                    JsonElement jsonElement;
                    JsonElement jsonElement3 = jsonElement = savedGroups != null ? savedGroups.get(expected.getAsString()) : null;
                    if (jsonElement != null) {
                        return this.isIn(actual, jsonElement.getAsJsonArray()) == false;
                    }
                    return this.isIn(actual, new JsonArray()) == false;
                }
            }
            default: {
                return false;
            }
        }
        return false;
    }

    Boolean arePrimitivesEqual(JsonPrimitive a, JsonPrimitive b, DataType dataType) {
        switch (dataType) {
            case STRING: {
                return a.getAsString().equals(b.getAsString());
            }
            case NUMBER: {
                return Objects.equals(a.getAsNumber(), b.getAsNumber());
            }
            case BOOLEAN: {
                return a.getAsBoolean() == b.getAsBoolean();
            }
        }
        log.info("\nUnsupported data type {}", (Object)dataType);
        return false;
    }

    Boolean evalConditionValue(JsonElement conditionValue, @Nullable JsonElement attributeValue, @Nullable JsonObject savedGroups) {
        JsonObject conditionValueObject;
        if (conditionValue.isJsonObject() && this.isOperatorObject((JsonElement)(conditionValueObject = (JsonObject)conditionValue)).booleanValue()) {
            Set entries = conditionValueObject.entrySet();
            for (Map.Entry entry : entries) {
                if (this.evalOperatorCondition((String)entry.getKey(), attributeValue, (JsonElement)entry.getValue(), savedGroups).booleanValue()) continue;
                return false;
            }
            return true;
        }
        if (conditionValue.isJsonNull() && (attributeValue == null || attributeValue.isJsonNull())) {
            return true;
        }
        if (attributeValue == null) {
            return false;
        }
        return conditionValue.toString().equals(attributeValue.toString());
    }

    Boolean elemMatch(JsonElement actual, JsonElement expected, @Nullable JsonObject savedGroups) {
        if (!actual.isJsonArray()) {
            return false;
        }
        JsonArray actualArray = actual.getAsJsonArray();
        boolean isOperator = this.isOperatorObject(expected);
        for (JsonElement actualElement : actualArray) {
            if (!(isOperator ? this.evalConditionValue(expected, actualElement, savedGroups) != false : this.evaluateCondition(actualElement.getAsJsonObject(), expected.getAsJsonObject(), savedGroups) != false)) continue;
            return true;
        }
        return false;
    }

    Boolean evalOr(JsonElement attributes, JsonArray conditions, @Nullable JsonObject savedGroups) {
        if (conditions.isEmpty()) {
            return true;
        }
        Iterator iterator = conditions.iterator();
        while (iterator.hasNext()) {
            JsonElement condition;
            JsonObject attributesObj = null == attributes ? new JsonObject() : attributes.getAsJsonObject();
            Boolean matches = this.evaluateCondition(attributesObj, (condition = (JsonElement)iterator.next()).getAsJsonObject(), savedGroups);
            if (!matches.booleanValue()) continue;
            return true;
        }
        return false;
    }

    Boolean evalAnd(JsonElement attributes, JsonArray conditions, @Nullable JsonObject savedGroups) {
        Iterator iterator = conditions.iterator();
        while (iterator.hasNext()) {
            JsonElement condition;
            JsonObject attributesObj = null == attributes ? new JsonObject() : attributes.getAsJsonObject();
            Boolean matches = this.evaluateCondition(attributesObj, (condition = (JsonElement)iterator.next()).getAsJsonObject(), savedGroups);
            if (matches.booleanValue()) continue;
            return false;
        }
        return true;
    }

    private Boolean isIn(JsonElement actual, JsonArray expected) {
        Type listType = new TypeToken<ArrayList<Object>>(){}.getType();
        ArrayList expectedAsList = (ArrayList)this.jsonUtils.gson.fromJson((JsonElement)expected, listType);
        if (!actual.isJsonArray()) {
            return expected.contains(actual);
        }
        JsonArray actualArr = actual.getAsJsonArray();
        if (actualArr.isEmpty()) {
            return false;
        }
        DataType attributeDataType = GrowthBookJsonUtils.getElementType(actualArr.get(0));
        ArrayList actualAsList = (ArrayList)this.jsonUtils.gson.fromJson((JsonElement)actualArr, listType);
        return actualAsList.stream().anyMatch(o -> {
            if (attributeDataType == DataType.STRING || attributeDataType == DataType.NUMBER || attributeDataType == DataType.BOOLEAN) {
                return expectedAsList.contains(o);
            }
            return false;
        });
    }
}

