/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import growthbook.sdk.java.BucketRange;
import growthbook.sdk.java.DataType;
import growthbook.sdk.java.FeatureResult;
import growthbook.sdk.java.Namespace;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nullable;

class GrowthBookJsonUtils {
    public final Gson gson;
    private static GrowthBookJsonUtils instance = null;

    private GrowthBookJsonUtils() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Namespace.class, Namespace.getSerializer());
        gsonBuilder.registerTypeAdapter(Namespace.class, Namespace.getDeserializer());
        gsonBuilder.registerTypeAdapter(BucketRange.class, BucketRange.getSerializer());
        gsonBuilder.registerTypeAdapter(BucketRange.class, BucketRange.getDeserializer());
        gsonBuilder.registerTypeAdapter(FeatureResult.class, FeatureResult.getSerializer());
        gsonBuilder.setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE);
        this.gson = gsonBuilder.create();
    }

    public static GrowthBookJsonUtils getInstance() {
        if (instance == null) {
            instance = new GrowthBookJsonUtils();
        }
        return instance;
    }

    public static Object unwrap(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof JsonElement)) {
            return o;
        }
        JsonElement e = (JsonElement)o;
        if (e.isJsonNull()) {
            return null;
        }
        if (e.isJsonPrimitive()) {
            JsonPrimitive p = e.getAsJsonPrimitive();
            if (p.isString()) {
                return p.getAsString();
            }
            if (p.isBoolean()) {
                return p.getAsBoolean();
            }
            if (p.isNumber()) {
                return GrowthBookJsonUtils.unwrapNumber(p.getAsNumber());
            }
        }
        return o;
    }

    private static boolean isPrimitiveNumber(Number n) {
        return n instanceof Integer || n instanceof Float || n instanceof Double || n instanceof Long || n instanceof BigDecimal || n instanceof BigInteger;
    }

    private static Number unwrapNumber(Number n) {
        double doubleValue;
        BigDecimal bigDecimal;
        Number unwrapped = !GrowthBookJsonUtils.isPrimitiveNumber(n) ? (Number)((bigDecimal = new BigDecimal(n.toString())).scale() <= 0 ? (Number)(bigDecimal.abs().compareTo(new BigDecimal(Integer.MAX_VALUE)) <= 0 ? (Number)bigDecimal.intValue() : (Number)(bigDecimal.abs().compareTo(new BigDecimal(Long.MAX_VALUE)) <= 0 ? Long.valueOf(bigDecimal.longValue()) : bigDecimal)) : (Number)(BigDecimal.valueOf(doubleValue = bigDecimal.doubleValue()).compareTo(bigDecimal) != 0 ? bigDecimal : Double.valueOf(doubleValue))) : (Number)n;
        return unwrapped;
    }

    public static DataType getElementType(@Nullable JsonElement element) {
        try {
            if (element == null) {
                return DataType.UNDEFINED;
            }
            if (element.toString().equals("null")) {
                return DataType.NULL;
            }
            if (element.isJsonPrimitive()) {
                JsonPrimitive primitive = element.getAsJsonPrimitive();
                if (primitive.isBoolean()) {
                    return DataType.BOOLEAN;
                }
                if (primitive.isNumber()) {
                    return DataType.NUMBER;
                }
                if (primitive.isString()) {
                    return DataType.STRING;
                }
            }
            if (element.isJsonArray()) {
                return DataType.ARRAY;
            }
            if (element.isJsonObject()) {
                return DataType.OBJECT;
            }
            return DataType.UNKNOWN;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return DataType.UNKNOWN;
        }
    }

    @Nullable
    public static JsonElement getJsonElementForObject(Object object) {
        try {
            if (object instanceof String) {
                return new JsonPrimitive((String)object);
            }
            if (object instanceof Float) {
                return new JsonPrimitive((Number)((Float)object));
            }
            if (object instanceof Integer) {
                return new JsonPrimitive((Number)((Integer)object));
            }
            if (object instanceof Double) {
                return new JsonPrimitive((Number)((Double)object));
            }
            if (object instanceof Long) {
                return new JsonPrimitive((Number)((Long)object));
            }
            if (object instanceof BigDecimal) {
                return new JsonPrimitive((Number)((BigDecimal)object));
            }
            return GrowthBookJsonUtils.getInstance().gson.toJsonTree(object);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

