/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import growthbook.sdk.java.BucketRange;
import growthbook.sdk.java.Filter;
import growthbook.sdk.java.MathUtils;
import growthbook.sdk.java.Namespace;
import growthbook.sdk.java.UrlUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

class GrowthBookUtils {
    GrowthBookUtils() {
    }

    @Nullable
    public static Float hash(String stringValue, Integer hashVersion, String seed) {
        if (hashVersion == null) {
            return null;
        }
        switch (hashVersion) {
            case 1: {
                return GrowthBookUtils.hashV1(stringValue, seed);
            }
            case 2: {
                return GrowthBookUtils.hashV2(stringValue, seed);
            }
        }
        return null;
    }

    private static Float hashV1(String stringValue, String seed) {
        long hashValue = MathUtils.fnv1a_32((stringValue + seed).getBytes());
        long thousand = 1000L;
        long remainder = hashValue % thousand;
        float remainderAsFloat = Float.parseFloat(String.valueOf(remainder));
        return Float.valueOf(remainderAsFloat / 1000.0f);
    }

    private static Float hashV2(String stringValue, String seed) {
        long first = MathUtils.fnv1a_32((seed + stringValue).getBytes());
        long second = MathUtils.fnv1a_32(String.valueOf(first).getBytes());
        long tenThousand = 10000L;
        long remainder = second % tenThousand;
        float remainderAsFloat = Float.parseFloat(String.valueOf(remainder));
        return Float.valueOf(remainderAsFloat / 10000.0f);
    }

    public static Boolean inNameSpace(String userId, Namespace namespace) {
        Float n = GrowthBookUtils.hash(userId, 1, "__" + namespace.getId());
        if (n == null) {
            return false;
        }
        return n.floatValue() >= namespace.getRangeStart().floatValue() && n.floatValue() < namespace.getRangeEnd().floatValue();
    }

    public static Integer chooseVariation(@NotNull Float n, ArrayList<BucketRange> bucketRanges) {
        for (int i = 0; i < bucketRanges.size(); ++i) {
            BucketRange range = bucketRanges.get(i);
            if (!GrowthBookUtils.inRange(n, range).booleanValue()) continue;
            return i;
        }
        return -1;
    }

    public static ArrayList<Float> getEqualWeights(Integer numberOfVariations) {
        int size = Math.max(0, numberOfVariations);
        if (size == 0) {
            return new ArrayList<Float>();
        }
        Float weight = Float.valueOf(1.0f / (float)numberOfVariations.intValue());
        return new ArrayList<Float>(Collections.nCopies(size, weight));
    }

    @Nullable
    public static Integer getQueryStringOverride(String id, String urlString, Integer numberOfVariations) {
        if (urlString == null || urlString.isEmpty()) {
            return null;
        }
        try {
            URL url = new URL(urlString);
            return GrowthBookUtils.getQueryStringOverride(id, url, numberOfVariations);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Nullable
    public static Integer getQueryStringOverride(String id, URL url, Integer numberOfVariations) {
        String query = url.getQuery();
        Map<String, String> queryMap = UrlUtils.parseQueryString(query);
        String possibleValue = queryMap.get(id);
        if (possibleValue == null) {
            return null;
        }
        try {
            int variationValue = Integer.parseInt(possibleValue);
            if (variationValue < 0 || variationValue >= numberOfVariations) {
                return null;
            }
            return variationValue;
        }
        catch (NumberFormatException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Nullable
    private static String getForcedFeatureRawValueForKeyFromUrl(String featureKey, URL url) {
        String prefixedKey = "gb~" + featureKey;
        Map<String, String> queryMap = UrlUtils.parseQueryString(url.getQuery());
        if (!queryMap.containsKey(prefixedKey)) {
            return null;
        }
        return queryMap.get(prefixedKey);
    }

    @Nullable
    public static Boolean getForcedBooleanValueFromUrl(String featureKey, URL url) {
        String value = GrowthBookUtils.getForcedFeatureRawValueForKeyFromUrl(featureKey, url);
        if (value == null) {
            return null;
        }
        if ((value = value.toLowerCase()).equals("true") || value.equals("1") || value.equals("on")) {
            return true;
        }
        if (value.equals("false") || value.equals("0") || value.equals("off")) {
            return false;
        }
        return null;
    }

    @Nullable
    public static String getForcedStringValueFromUrl(String featureKey, URL url) {
        return GrowthBookUtils.getForcedFeatureRawValueForKeyFromUrl(featureKey, url);
    }

    @Nullable
    public static Float getForcedFloatValueFromUrl(String featureKey, URL url) {
        String value = GrowthBookUtils.getForcedFeatureRawValueForKeyFromUrl(featureKey, url);
        if (value == null) {
            return null;
        }
        try {
            return Float.valueOf(Float.parseFloat(value));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static Double getForcedDoubleValueFromUrl(String featureKey, URL url) {
        String value = GrowthBookUtils.getForcedFeatureRawValueForKeyFromUrl(featureKey, url);
        if (value == null) {
            return null;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static Integer getForcedIntegerValueFromUrl(String featureKey, URL url) {
        String value = GrowthBookUtils.getForcedFeatureRawValueForKeyFromUrl(featureKey, url);
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static <ValueType> ValueType getForcedSerializableValueFromUrl(String featureKey, URL url, Class<ValueType> valueTypeClass, Gson gson) {
        String value = GrowthBookUtils.getForcedFeatureRawValueForKeyFromUrl(featureKey, url);
        if (value == null) {
            return null;
        }
        try {
            return (ValueType)gson.fromJson(value, valueTypeClass);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ArrayList<BucketRange> getBucketRanges(Integer numberOfVariations, @NotNull Float coverage, @Nullable ArrayList<Float> weights) {
        float sumOfWeights;
        float clampedCoverage = MathUtils.clamp(coverage.floatValue(), 0.0f, 1.0f);
        ArrayList<Float> adjustedWeights = weights;
        if (weights == null || numberOfVariations.intValue() != weights.size()) {
            adjustedWeights = GrowthBookUtils.getEqualWeights(numberOfVariations);
        }
        if ((double)(sumOfWeights = MathUtils.sum(adjustedWeights)) < 0.99 || (double)sumOfWeights > 1.01) {
            adjustedWeights = GrowthBookUtils.getEqualWeights(numberOfVariations);
        }
        float start = 0.0f;
        float cumulative = 0.0f;
        ArrayList<BucketRange> bucketRanges = new ArrayList<BucketRange>();
        for (float weight : adjustedWeights) {
            start = cumulative;
            cumulative += weight;
            BucketRange bucketRange = BucketRange.builder().rangeStart(Float.valueOf(start)).rangeEnd(Float.valueOf(start + clampedCoverage * weight)).build();
            bucketRanges.add(bucketRange);
        }
        return bucketRanges;
    }

    public static Boolean inRange(Float n, BucketRange range) {
        if (n == null || range == null) {
            return false;
        }
        return n.floatValue() >= range.getRangeStart().floatValue() && n.floatValue() < range.getRangeEnd().floatValue();
    }

    public static Boolean isFilteredOut(List<Filter> filters, JsonObject attributes) {
        if (filters == null) {
            return false;
        }
        if (attributes == null) {
            return false;
        }
        return filters.stream().anyMatch(filter -> {
            Float n;
            JsonElement hashValueElement;
            String hashAttribute = filter.getAttribute();
            if (hashAttribute == null) {
                hashAttribute = "id";
            }
            if ((hashValueElement = attributes.get(hashAttribute)) == null) {
                return true;
            }
            if (hashValueElement.isJsonNull()) {
                return true;
            }
            if (!hashValueElement.isJsonPrimitive()) {
                return true;
            }
            JsonPrimitive hashValuePrimitive = hashValueElement.getAsJsonPrimitive();
            String hashValue = hashValuePrimitive.getAsString();
            if (hashValue == null || hashValue.equals("")) {
                return true;
            }
            Integer hashVersion = filter.getHashVersion();
            if (hashVersion == null) {
                hashVersion = 2;
            }
            if ((n = GrowthBookUtils.hash(hashValue, hashVersion, filter.getSeed())) == null) {
                return true;
            }
            List<BucketRange> ranges = filter.getRanges();
            if (ranges == null) {
                return true;
            }
            return ranges.stream().noneMatch(range -> GrowthBookUtils.inRange(n, range));
        });
    }

    public static Boolean isIncludedInRollout(JsonObject attributes, String seed, String hashAttribute, @Nullable BucketRange range, @Nullable Float coverage, @Nullable Integer hashVersion) {
        String hashValue;
        Float hash;
        if (range == null && coverage == null) {
            return true;
        }
        if (hashAttribute == null || hashAttribute.equals("")) {
            hashAttribute = "id";
        }
        if (attributes == null) {
            return false;
        }
        JsonElement hashValueElement = attributes.get(hashAttribute);
        if (hashValueElement == null || hashValueElement.isJsonNull()) {
            return false;
        }
        if (hashVersion == null) {
            hashVersion = 1;
        }
        if ((hash = GrowthBookUtils.hash(hashValue = hashValueElement.getAsString(), hashVersion, seed)) == null) {
            return false;
        }
        if (range != null) {
            return GrowthBookUtils.inRange(hash, range);
        }
        return hash.floatValue() <= coverage.floatValue();
    }
}

