/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import growthbook.sdk.java.BucketRange;
import growthbook.sdk.java.ConditionEvaluator;
import growthbook.sdk.java.Experiment;
import growthbook.sdk.java.ExperimentResult;
import growthbook.sdk.java.Filter;
import growthbook.sdk.java.GBContext;
import growthbook.sdk.java.GrowthBookJsonUtils;
import growthbook.sdk.java.GrowthBookUtils;
import growthbook.sdk.java.IExperimentEvaluator;
import growthbook.sdk.java.Namespace;
import growthbook.sdk.java.TrackingCallback;
import growthbook.sdk.java.VariationMeta;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

class ExperimentEvaluator
implements IExperimentEvaluator {
    private final ConditionEvaluator conditionEvaluator = new ConditionEvaluator();

    ExperimentEvaluator() {
    }

    @Override
    public <ValueType> ExperimentResult<ValueType> evaluateExperiment(Experiment<ValueType> experiment, GBContext context, @Nullable String featureId) {
        Float hash;
        Integer hashVersion;
        String seed;
        ArrayList<BucketRange> bucketRanges;
        Float coverage;
        String attributesJson;
        Boolean shouldEvaluate;
        Boolean isInNamespace;
        JsonElement attributeValueElement;
        String hashAttribute;
        Integer forcedVariation;
        ArrayList<Object> experimentVariations = experiment.getVariations();
        if (experimentVariations == null) {
            experimentVariations = new ArrayList();
        }
        if (context.getEnabled() != null && !context.getEnabled().booleanValue() || experimentVariations.size() < 2) {
            return this.getExperimentResult(experiment, context, 0, false, false, featureId, null);
        }
        Integer override = GrowthBookUtils.getQueryStringOverride(experiment.getKey(), context.getUrl(), (Integer)experimentVariations.size());
        if (override != null) {
            return this.getExperimentResult(experiment, context, override, true, false, featureId, null);
        }
        Map<String, Integer> forcedVariations = context.getForcedVariationsMap();
        if (forcedVariations == null) {
            forcedVariations = new HashMap<String, Integer>();
        }
        if ((forcedVariation = forcedVariations.get(experiment.getKey())) != null) {
            return this.getExperimentResult(experiment, context, forcedVariation, true, false, featureId, null);
        }
        if (experiment.getIsActive() != null && !experiment.getIsActive().booleanValue()) {
            return this.getExperimentResult(experiment, context, 0, false, false, featureId, null);
        }
        JsonObject attributes = context.getAttributes();
        if (attributes == null) {
            attributes = new JsonObject();
        }
        if ((hashAttribute = experiment.getHashAttribute()) == null || hashAttribute.equals("")) {
            hashAttribute = "id";
        }
        if ((attributeValueElement = attributes.get(hashAttribute)) == null || attributeValueElement.isJsonNull() || attributeValueElement.isJsonPrimitive() && attributeValueElement.getAsJsonPrimitive().isString() && Objects.equals(attributeValueElement.getAsString(), "")) {
            return this.getExperimentResult(experiment, context, 0, false, false, featureId, null);
        }
        String attributeValue = attributeValueElement.getAsString();
        ArrayList<Filter> filters = experiment.getFilters();
        Namespace namespace = experiment.getNamespace();
        if (filters != null ? GrowthBookUtils.isFilteredOut(filters, attributes) != false : namespace != null && (isInNamespace = GrowthBookUtils.inNameSpace(attributeValue, namespace)) == false) {
            return this.getExperimentResult(experiment, context, 0, false, false, featureId, null);
        }
        String jsonStringCondition = experiment.getConditionJson();
        if (jsonStringCondition != null && !(shouldEvaluate = this.conditionEvaluator.evaluateCondition(attributesJson = GrowthBookJsonUtils.getInstance().gson.toJson((JsonElement)attributes), jsonStringCondition)).booleanValue()) {
            return this.getExperimentResult(experiment, context, 0, false, false, featureId, null);
        }
        ArrayList<Float> weights = experiment.getWeights();
        if (weights == null) {
            weights = GrowthBookUtils.getEqualWeights(experiment.getVariations().size());
        }
        if ((coverage = experiment.getCoverage()) == null) {
            coverage = Float.valueOf(1.0f);
        }
        if ((bucketRanges = experiment.getRanges()) == null) {
            bucketRanges = GrowthBookUtils.getBucketRanges(experiment.getVariations().size(), coverage, weights);
        }
        if ((seed = experiment.getSeed()) == null) {
            seed = experiment.getKey();
        }
        if ((hashVersion = experiment.getHashVersion()) == null) {
            hashVersion = 1;
        }
        if ((hash = GrowthBookUtils.hash(attributeValue, hashVersion, seed)) == null) {
            return this.getExperimentResult(experiment, context, 0, false, false, featureId, null);
        }
        Integer assignedVariation = GrowthBookUtils.chooseVariation(hash, bucketRanges);
        if (assignedVariation == -1) {
            return this.getExperimentResult(experiment, context, 0, false, false, featureId, null);
        }
        Integer force = experiment.getForce();
        if (force != null) {
            return this.getExperimentResult(experiment, context, force, true, false, featureId, null);
        }
        if (context.getIsQaMode() != null && context.getIsQaMode().booleanValue()) {
            return this.getExperimentResult(experiment, context, 0, false, false, featureId, null);
        }
        ExperimentResult<ValueType> result = this.getExperimentResult(experiment, context, assignedVariation, true, true, featureId, hash);
        TrackingCallback trackingCallback = context.getTrackingCallback();
        if (trackingCallback != null) {
            trackingCallback.onTrack(experiment, result);
        }
        return result;
    }

    private <ValueType> ExperimentResult<ValueType> getExperimentResult(Experiment<ValueType> experiment, GBContext context, Integer variationIndex, Boolean inExperiment, Boolean hashUsed, String featureId, @Nullable Float hashBucket) {
        JsonElement hashAttributeElement;
        String hashAttribute;
        ArrayList<Object> experimentVariations = experiment.getVariations();
        if (experimentVariations == null) {
            experimentVariations = new ArrayList();
        }
        if (variationIndex < 0 || variationIndex >= experimentVariations.size()) {
            variationIndex = 0;
            inExperiment = false;
        }
        Object targetValue = null;
        if (!experimentVariations.isEmpty()) {
            targetValue = experiment.getVariations().get(variationIndex);
        }
        if ((hashAttribute = experiment.getHashAttribute()) == null) {
            hashAttribute = "id";
        }
        String hashValue = "";
        JsonObject attributes = context.getAttributes();
        if (attributes != null && (hashAttributeElement = attributes.get(hashAttribute)) != null && !hashAttributeElement.isJsonNull()) {
            hashValue = hashAttributeElement.getAsString();
        }
        VariationMeta maybeMeta = null;
        ArrayList<VariationMeta> metaList = experiment.getMeta();
        if (metaList == null) {
            metaList = new ArrayList();
        }
        if (variationIndex < metaList.size()) {
            maybeMeta = metaList.get(variationIndex);
        }
        return ExperimentResult.builder().inExperiment(inExperiment).variationId(variationIndex).key(maybeMeta == null ? variationIndex.toString() : maybeMeta.getKey()).featureId(featureId).hashValue(hashValue).hashUsed(hashUsed).hashAttribute(hashAttribute).value(targetValue).bucket(hashBucket).name(maybeMeta == null ? null : maybeMeta.getName()).passThrough(maybeMeta == null ? null : maybeMeta.getPassThrough()).build();
    }
}

