/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java;

import growthbook.sdk.java.ConditionEvaluator;
import growthbook.sdk.java.Experiment;
import growthbook.sdk.java.ExperimentEvaluator;
import growthbook.sdk.java.ExperimentResult;
import growthbook.sdk.java.ExperimentRunCallback;
import growthbook.sdk.java.FeatureEvaluator;
import growthbook.sdk.java.FeatureResult;
import growthbook.sdk.java.GBContext;
import growthbook.sdk.java.GrowthBookJsonUtils;
import growthbook.sdk.java.IGrowthBook;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class GrowthBook
implements IGrowthBook {
    private final GBContext context;
    private final FeatureEvaluator featureEvaluator;
    private final ConditionEvaluator conditionEvaluator;
    private final ExperimentEvaluator experimentEvaluatorEvaluator;
    private final GrowthBookJsonUtils jsonUtils = GrowthBookJsonUtils.getInstance();
    private ArrayList<ExperimentRunCallback> callbacks = new ArrayList();

    public GrowthBook(GBContext context) {
        this.context = context;
        this.featureEvaluator = new FeatureEvaluator();
        this.conditionEvaluator = new ConditionEvaluator();
        this.experimentEvaluatorEvaluator = new ExperimentEvaluator();
    }

    public GrowthBook() {
        this.context = GBContext.builder().build();
        this.featureEvaluator = new FeatureEvaluator();
        this.conditionEvaluator = new ConditionEvaluator();
        this.experimentEvaluatorEvaluator = new ExperimentEvaluator();
    }

    GrowthBook(GBContext context, FeatureEvaluator featureEvaluator, ConditionEvaluator conditionEvaluator, ExperimentEvaluator experimentEvaluator) {
        this.featureEvaluator = featureEvaluator;
        this.conditionEvaluator = conditionEvaluator;
        this.experimentEvaluatorEvaluator = experimentEvaluator;
        this.context = context;
    }

    @Override
    @Nullable
    public <ValueType> FeatureResult<ValueType> evalFeature(String key, Class<ValueType> valueTypeClass) {
        return this.featureEvaluator.evaluateFeature(key, this.context, valueTypeClass);
    }

    @Override
    public void setFeatures(String featuresJsonString) {
        this.context.setFeaturesJson(featuresJsonString);
    }

    @Override
    public void setAttributes(String attributesJsonString) {
        this.context.setAttributesJson(attributesJsonString);
    }

    @Override
    public <ValueType> ExperimentResult<ValueType> run(Experiment<ValueType> experiment) {
        ExperimentResult result = this.experimentEvaluatorEvaluator.evaluateExperiment(experiment, this.context, null);
        this.callbacks.forEach(callback -> callback.onRun(result));
        return result;
    }

    @Override
    public Boolean isOn(String featureKey) {
        return this.featureEvaluator.evaluateFeature(featureKey, this.context, Object.class).isOn();
    }

    @Override
    public Boolean isOff(String featureKey) {
        return this.featureEvaluator.evaluateFeature(featureKey, this.context, Object.class).isOff();
    }

    @Override
    public Boolean getFeatureValue(String featureKey, Boolean defaultValue) {
        try {
            Boolean maybeValue = (Boolean)this.featureEvaluator.evaluateFeature(featureKey, this.context, Boolean.class).getValue();
            return maybeValue == null ? defaultValue : maybeValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    @Override
    public String getFeatureValue(String featureKey, String defaultValue) {
        try {
            String maybeValue = (String)this.featureEvaluator.evaluateFeature(featureKey, this.context, String.class).getValue();
            return maybeValue == null ? defaultValue : maybeValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    @Override
    public Float getFeatureValue(String featureKey, Float defaultValue) {
        try {
            Double maybeValue = (Double)this.featureEvaluator.evaluateFeature(featureKey, this.context, Double.class).getValue();
            if (maybeValue == null) {
                return defaultValue;
            }
            try {
                return Float.valueOf(maybeValue.floatValue());
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    @Override
    public Integer getFeatureValue(String featureKey, Integer defaultValue) {
        try {
            Double maybeValue = (Double)this.featureEvaluator.evaluateFeature(featureKey, this.context, Double.class).getValue();
            if (maybeValue == null) {
                return defaultValue;
            }
            try {
                return maybeValue.intValue();
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    @Override
    public Object getFeatureValue(String featureKey, Object defaultValue) {
        try {
            Object maybeValue = this.featureEvaluator.evaluateFeature(featureKey, this.context, defaultValue.getClass()).getValue();
            return maybeValue == null ? defaultValue : maybeValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    @Override
    public <ValueType> ValueType getFeatureValue(String featureKey, ValueType defaultValue, Class<ValueType> gsonDeserializableClass) {
        try {
            Object maybeValue = this.featureEvaluator.evaluateFeature(featureKey, this.context, gsonDeserializableClass).getValue();
            if (maybeValue == null) {
                return defaultValue;
            }
            String stringValue = this.jsonUtils.gson.toJson(maybeValue);
            return (ValueType)this.jsonUtils.gson.fromJson(stringValue, gsonDeserializableClass);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    @Override
    public Boolean evaluateCondition(String attributesJsonString, String conditionJsonString) {
        return this.conditionEvaluator.evaluateCondition(attributesJsonString, conditionJsonString);
    }

    @Override
    public Double getFeatureValue(String featureKey, Double defaultValue) {
        try {
            Double maybeValue = (Double)this.featureEvaluator.evaluateFeature(featureKey, this.context, Double.class).getValue();
            return maybeValue == null ? defaultValue : maybeValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    @Override
    public void destroy() {
        this.callbacks = new ArrayList();
    }

    @Override
    public void subscribe(ExperimentRunCallback callback) {
        this.callbacks.add(callback);
    }
}

