/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import growthbook.sdk.java.DecryptionUtils;
import growthbook.sdk.java.FeatureUsageCallback;
import growthbook.sdk.java.GrowthBookJsonUtils;
import growthbook.sdk.java.TrackingCallback;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class GBContext {
    @Nullable
    private JsonObject features;
    @Nullable
    private Boolean enabled;
    private Integer hashVersion;
    @Nullable
    private String url;
    private Boolean isQaMode;
    private Boolean allowUrlOverride;
    @Nullable
    private TrackingCallback trackingCallback;
    @Nullable
    private FeatureUsageCallback featureUsageCallback;
    @Nullable
    private String attributesJson;
    @Nullable
    private JsonObject attributes;
    @Nullable
    private String featuresJson;
    @Nullable
    private String encryptionKey;
    @Nullable
    private Map<String, Integer> forcedVariationsMap;

    public GBContext(@Nullable String attributesJson, @Nullable String featuresJson, @Nullable String encryptionKey, @Nullable Boolean enabled, Boolean isQaMode, @Nullable String url, Boolean allowUrlOverrides, @Nullable Map<String, Integer> forcedVariationsMap, @Nullable TrackingCallback trackingCallback, @Nullable FeatureUsageCallback featureUsageCallback) {
        this.encryptionKey = encryptionKey;
        this.attributesJson = attributesJson == null ? "{}" : attributesJson;
        this.featuresJson = "{}";
        if (encryptionKey != null && featuresJson != null) {
            try {
                String decrypted = DecryptionUtils.decrypt(featuresJson, encryptionKey);
                this.featuresJson = decrypted.trim();
            }
            catch (DecryptionUtils.DecryptionException e) {
                e.printStackTrace();
            }
        } else if (featuresJson != null) {
            this.featuresJson = featuresJson;
        }
        this.enabled = enabled == null ? true : enabled;
        this.isQaMode = isQaMode == null ? false : isQaMode;
        this.allowUrlOverride = allowUrlOverrides == null ? false : allowUrlOverrides;
        this.url = url;
        this.forcedVariationsMap = forcedVariationsMap == null ? new HashMap() : forcedVariationsMap;
        this.trackingCallback = trackingCallback;
        this.featureUsageCallback = featureUsageCallback;
    }

    private void setFeatures(@Nullable JsonObject features) {
        this.features = features;
    }

    public void setAttributesJson(String attributesJson) {
        this.attributesJson = attributesJson;
        if (attributesJson != null) {
            this.setAttributes(GBContext.transformAttributes(attributesJson));
        }
    }

    private void setAttributes(@Nullable JsonObject attributes) {
        this.attributes = attributes;
    }

    public void setFeaturesJson(String featuresJson) {
        this.featuresJson = featuresJson;
        if (featuresJson != null) {
            this.setFeatures(GBContext.transformFeatures(featuresJson));
        }
    }

    public static GBContextBuilder builder() {
        return new CustomGBContextBuilder();
    }

    @Nullable
    private static JsonObject transformFeatures(String featuresJsonString) {
        try {
            return (JsonObject)GrowthBookJsonUtils.getInstance().gson.fromJson(featuresJsonString, JsonObject.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static JsonObject transformAttributes(@Nullable String attributesJsonString) {
        try {
            if (attributesJsonString == null) {
                return new JsonObject();
            }
            JsonElement element = (JsonElement)GrowthBookJsonUtils.getInstance().gson.fromJson(attributesJsonString, JsonElement.class);
            if (element == null || element.isJsonNull()) {
                return new JsonObject();
            }
            return (JsonObject)GrowthBookJsonUtils.getInstance().gson.fromJson(attributesJsonString, JsonObject.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new JsonObject();
        }
    }

    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    public Integer getHashVersion() {
        return this.hashVersion;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    public Boolean getIsQaMode() {
        return this.isQaMode;
    }

    public Boolean getAllowUrlOverride() {
        return this.allowUrlOverride;
    }

    @Nullable
    public TrackingCallback getTrackingCallback() {
        return this.trackingCallback;
    }

    @Nullable
    public FeatureUsageCallback getFeatureUsageCallback() {
        return this.featureUsageCallback;
    }

    @Nullable
    public String getAttributesJson() {
        return this.attributesJson;
    }

    @Nullable
    public String getFeaturesJson() {
        return this.featuresJson;
    }

    @Nullable
    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    @Nullable
    public Map<String, Integer> getForcedVariationsMap() {
        return this.forcedVariationsMap;
    }

    public void setEnabled(@Nullable Boolean enabled) {
        this.enabled = enabled;
    }

    public void setHashVersion(Integer hashVersion) {
        this.hashVersion = hashVersion;
    }

    public void setUrl(@Nullable String url) {
        this.url = url;
    }

    public void setIsQaMode(Boolean isQaMode) {
        this.isQaMode = isQaMode;
    }

    public void setAllowUrlOverride(Boolean allowUrlOverride) {
        this.allowUrlOverride = allowUrlOverride;
    }

    public void setTrackingCallback(@Nullable TrackingCallback trackingCallback) {
        this.trackingCallback = trackingCallback;
    }

    public void setFeatureUsageCallback(@Nullable FeatureUsageCallback featureUsageCallback) {
        this.featureUsageCallback = featureUsageCallback;
    }

    public void setEncryptionKey(@Nullable String encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public void setForcedVariationsMap(@Nullable Map<String, Integer> forcedVariationsMap) {
        this.forcedVariationsMap = forcedVariationsMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GBContext)) {
            return false;
        }
        GBContext other = (GBContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Integer this$hashVersion = this.getHashVersion();
        Integer other$hashVersion = other.getHashVersion();
        if (this$hashVersion == null ? other$hashVersion != null : !((Object)this$hashVersion).equals(other$hashVersion)) {
            return false;
        }
        Boolean this$isQaMode = this.getIsQaMode();
        Boolean other$isQaMode = other.getIsQaMode();
        if (this$isQaMode == null ? other$isQaMode != null : !((Object)this$isQaMode).equals(other$isQaMode)) {
            return false;
        }
        Boolean this$allowUrlOverride = this.getAllowUrlOverride();
        Boolean other$allowUrlOverride = other.getAllowUrlOverride();
        if (this$allowUrlOverride == null ? other$allowUrlOverride != null : !((Object)this$allowUrlOverride).equals(other$allowUrlOverride)) {
            return false;
        }
        JsonObject this$features = this.getFeatures();
        JsonObject other$features = other.getFeatures();
        if (this$features == null ? other$features != null : !this$features.equals(other$features)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        TrackingCallback this$trackingCallback = this.getTrackingCallback();
        TrackingCallback other$trackingCallback = other.getTrackingCallback();
        if (this$trackingCallback == null ? other$trackingCallback != null : !this$trackingCallback.equals(other$trackingCallback)) {
            return false;
        }
        FeatureUsageCallback this$featureUsageCallback = this.getFeatureUsageCallback();
        FeatureUsageCallback other$featureUsageCallback = other.getFeatureUsageCallback();
        if (this$featureUsageCallback == null ? other$featureUsageCallback != null : !this$featureUsageCallback.equals(other$featureUsageCallback)) {
            return false;
        }
        String this$attributesJson = this.getAttributesJson();
        String other$attributesJson = other.getAttributesJson();
        if (this$attributesJson == null ? other$attributesJson != null : !this$attributesJson.equals(other$attributesJson)) {
            return false;
        }
        JsonObject this$attributes = this.getAttributes();
        JsonObject other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !this$attributes.equals(other$attributes)) {
            return false;
        }
        String this$featuresJson = this.getFeaturesJson();
        String other$featuresJson = other.getFeaturesJson();
        if (this$featuresJson == null ? other$featuresJson != null : !this$featuresJson.equals(other$featuresJson)) {
            return false;
        }
        String this$encryptionKey = this.getEncryptionKey();
        String other$encryptionKey = other.getEncryptionKey();
        if (this$encryptionKey == null ? other$encryptionKey != null : !this$encryptionKey.equals(other$encryptionKey)) {
            return false;
        }
        Map<String, Integer> this$forcedVariationsMap = this.getForcedVariationsMap();
        Map<String, Integer> other$forcedVariationsMap = other.getForcedVariationsMap();
        return !(this$forcedVariationsMap == null ? other$forcedVariationsMap != null : !((Object)this$forcedVariationsMap).equals(other$forcedVariationsMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GBContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Integer $hashVersion = this.getHashVersion();
        result = result * 59 + ($hashVersion == null ? 43 : ((Object)$hashVersion).hashCode());
        Boolean $isQaMode = this.getIsQaMode();
        result = result * 59 + ($isQaMode == null ? 43 : ((Object)$isQaMode).hashCode());
        Boolean $allowUrlOverride = this.getAllowUrlOverride();
        result = result * 59 + ($allowUrlOverride == null ? 43 : ((Object)$allowUrlOverride).hashCode());
        JsonObject $features = this.getFeatures();
        result = result * 59 + ($features == null ? 43 : $features.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        TrackingCallback $trackingCallback = this.getTrackingCallback();
        result = result * 59 + ($trackingCallback == null ? 43 : $trackingCallback.hashCode());
        FeatureUsageCallback $featureUsageCallback = this.getFeatureUsageCallback();
        result = result * 59 + ($featureUsageCallback == null ? 43 : $featureUsageCallback.hashCode());
        String $attributesJson = this.getAttributesJson();
        result = result * 59 + ($attributesJson == null ? 43 : $attributesJson.hashCode());
        JsonObject $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : $attributes.hashCode());
        String $featuresJson = this.getFeaturesJson();
        result = result * 59 + ($featuresJson == null ? 43 : $featuresJson.hashCode());
        String $encryptionKey = this.getEncryptionKey();
        result = result * 59 + ($encryptionKey == null ? 43 : $encryptionKey.hashCode());
        Map<String, Integer> $forcedVariationsMap = this.getForcedVariationsMap();
        result = result * 59 + ($forcedVariationsMap == null ? 43 : ((Object)$forcedVariationsMap).hashCode());
        return result;
    }

    public String toString() {
        return "GBContext(features=" + this.getFeatures() + ", enabled=" + this.getEnabled() + ", hashVersion=" + this.getHashVersion() + ", url=" + this.getUrl() + ", isQaMode=" + this.getIsQaMode() + ", allowUrlOverride=" + this.getAllowUrlOverride() + ", trackingCallback=" + this.getTrackingCallback() + ", featureUsageCallback=" + this.getFeatureUsageCallback() + ", attributesJson=" + this.getAttributesJson() + ", attributes=" + this.getAttributes() + ", featuresJson=" + this.getFeaturesJson() + ", encryptionKey=" + this.getEncryptionKey() + ", forcedVariationsMap=" + this.getForcedVariationsMap() + ")";
    }

    @Nullable
    JsonObject getFeatures() {
        return this.features;
    }

    @Nullable
    JsonObject getAttributes() {
        return this.attributes;
    }

    static class CustomGBContextBuilder
    extends GBContextBuilder {
        CustomGBContextBuilder() {
        }

        @Override
        public GBContext build() {
            GBContext context = super.build();
            if (context.featuresJson != null) {
                context.setFeatures(GBContext.transformFeatures(context.featuresJson));
            }
            context.setAttributesJson(context.attributesJson);
            return context;
        }
    }

    public static class GBContextBuilder {
        private String attributesJson;
        private String featuresJson;
        private String encryptionKey;
        private Boolean enabled;
        private Boolean isQaMode;
        private String url;
        private Boolean allowUrlOverrides;
        private Map<String, Integer> forcedVariationsMap;
        private TrackingCallback trackingCallback;
        private FeatureUsageCallback featureUsageCallback;

        GBContextBuilder() {
        }

        public GBContextBuilder attributesJson(@Nullable String attributesJson) {
            this.attributesJson = attributesJson;
            return this;
        }

        public GBContextBuilder featuresJson(@Nullable String featuresJson) {
            this.featuresJson = featuresJson;
            return this;
        }

        public GBContextBuilder encryptionKey(@Nullable String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public GBContextBuilder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public GBContextBuilder isQaMode(Boolean isQaMode) {
            this.isQaMode = isQaMode;
            return this;
        }

        public GBContextBuilder url(@Nullable String url) {
            this.url = url;
            return this;
        }

        public GBContextBuilder allowUrlOverrides(Boolean allowUrlOverrides) {
            this.allowUrlOverrides = allowUrlOverrides;
            return this;
        }

        public GBContextBuilder forcedVariationsMap(@Nullable Map<String, Integer> forcedVariationsMap) {
            this.forcedVariationsMap = forcedVariationsMap;
            return this;
        }

        public GBContextBuilder trackingCallback(@Nullable TrackingCallback trackingCallback) {
            this.trackingCallback = trackingCallback;
            return this;
        }

        public GBContextBuilder featureUsageCallback(@Nullable FeatureUsageCallback featureUsageCallback) {
            this.featureUsageCallback = featureUsageCallback;
            return this;
        }

        public GBContext build() {
            return new GBContext(this.attributesJson, this.featuresJson, this.encryptionKey, this.enabled, this.isQaMode, this.url, this.allowUrlOverrides, this.forcedVariationsMap, this.trackingCallback, this.featureUsageCallback);
        }

        public String toString() {
            return "GBContext.GBContextBuilder(attributesJson=" + this.attributesJson + ", featuresJson=" + this.featuresJson + ", encryptionKey=" + this.encryptionKey + ", enabled=" + this.enabled + ", isQaMode=" + this.isQaMode + ", url=" + this.url + ", allowUrlOverrides=" + this.allowUrlOverrides + ", forcedVariationsMap=" + this.forcedVariationsMap + ", trackingCallback=" + this.trackingCallback + ", featureUsageCallback=" + this.featureUsageCallback + ")";
        }
    }
}

