/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import growthbook.sdk.java.DecryptionUtils;
import growthbook.sdk.java.FeatureFetchException;
import growthbook.sdk.java.FeatureRefreshCallback;
import growthbook.sdk.java.GrowthBookJsonUtils;
import growthbook.sdk.java.IGBFeaturesRepository;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class GBFeaturesRepository
implements IGBFeaturesRepository {
    private final String endpoint;
    @Nullable
    private final String encryptionKey;
    private final Integer ttlSeconds;
    private Long expiresAt;
    private final OkHttpClient okHttpClient;
    private final ArrayList<FeatureRefreshCallback> refreshCallbacks = new ArrayList();
    private String featuresJson = "{}";

    public GBFeaturesRepository(String endpoint, @Nullable String encryptionKey, @Nullable Integer ttlSeconds) {
        if (endpoint == null) {
            throw new IllegalArgumentException("endpoint cannot be null");
        }
        this.endpoint = endpoint;
        this.encryptionKey = encryptionKey;
        this.ttlSeconds = ttlSeconds == null ? 60 : ttlSeconds;
        this.refreshExpiresAt();
        this.okHttpClient = this.initializeHttpClient();
    }

    GBFeaturesRepository(OkHttpClient okHttpClient, @Nullable String endpoint, @Nullable String encryptionKey, @Nullable Integer ttlSeconds) {
        this.encryptionKey = encryptionKey;
        this.endpoint = endpoint;
        this.ttlSeconds = ttlSeconds == null ? 60 : ttlSeconds;
        this.refreshExpiresAt();
        this.okHttpClient = okHttpClient;
    }

    @Override
    public String getFeaturesJson() {
        if (this.isCacheExpired().booleanValue()) {
            this.enqueueFeatureRefreshRequest();
            this.refreshExpiresAt();
        }
        return this.featuresJson;
    }

    @Override
    public void onFeaturesRefresh(FeatureRefreshCallback callback) {
        this.refreshCallbacks.add(callback);
    }

    @Override
    public void clearCallbacks() {
        this.refreshCallbacks.clear();
    }

    private void enqueueFeatureRefreshRequest() {
        final GBFeaturesRepository self = this;
        Request request = new Request.Builder().url(this.endpoint).build();
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try {
                    self.onSuccess(response);
                }
                catch (FeatureFetchException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void initialize() throws FeatureFetchException {
        this.fetchFeatures();
    }

    private OkHttpClient initializeHttpClient() {
        OkHttpClient client = new OkHttpClient.Builder().addInterceptor((Interceptor)new GBFeaturesRepositoryRequestInterceptor()).retryOnConnectionFailure(true).build();
        return client;
    }

    private void refreshExpiresAt() {
        this.expiresAt = Instant.now().getEpochSecond() + (long)this.ttlSeconds.intValue();
    }

    private Boolean isCacheExpired() {
        long now = Instant.now().getEpochSecond();
        return now >= this.expiresAt;
    }

    private void fetchFeatures() throws FeatureFetchException {
        if (this.endpoint == null) {
            throw new IllegalArgumentException("endpoint cannot be null");
        }
        Request request = new Request.Builder().url(this.endpoint).build();
        try (Response response = this.okHttpClient.newCall(request).execute();){
            this.onSuccess(response);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new FeatureFetchException(FeatureFetchException.FeatureFetchErrorCode.UNKNOWN, e.getMessage());
        }
    }

    private void onSuccess(Response response) throws FeatureFetchException {
        try {
            String refreshedFeatures;
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                throw new FeatureFetchException(FeatureFetchException.FeatureFetchErrorCode.NO_RESPONSE_ERROR);
            }
            JsonObject jsonObject = (JsonObject)GrowthBookJsonUtils.getInstance().gson.fromJson(responseBody.string(), JsonObject.class);
            if (this.encryptionKey != null) {
                JsonElement encryptedFeaturesJsonElement = jsonObject.get("encryptedFeatures");
                if (encryptedFeaturesJsonElement == null) {
                    throw new FeatureFetchException(FeatureFetchException.FeatureFetchErrorCode.CONFIGURATION_ERROR, "encryptionKey provided but endpoint not encrypted");
                }
                String encryptedFeaturesJson = encryptedFeaturesJsonElement.getAsString();
                refreshedFeatures = DecryptionUtils.decrypt(encryptedFeaturesJson, this.encryptionKey).trim();
            } else {
                JsonElement featuresJsonElement = jsonObject.get("features");
                if (featuresJsonElement == null) {
                    throw new FeatureFetchException(FeatureFetchException.FeatureFetchErrorCode.CONFIGURATION_ERROR, "No features found");
                }
                refreshedFeatures = featuresJsonElement.toString().trim();
            }
            this.featuresJson = refreshedFeatures;
            this.refreshCallbacks.forEach(featureRefreshCallback -> featureRefreshCallback.onRefresh(this.featuresJson));
        }
        catch (DecryptionUtils.DecryptionException | IOException e) {
            e.printStackTrace();
            throw new FeatureFetchException(FeatureFetchException.FeatureFetchErrorCode.UNKNOWN, e.getMessage());
        }
    }

    public static GBFeaturesRepositoryBuilder builder() {
        return new GBFeaturesRepositoryBuilder();
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    @Nullable
    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public Integer getTtlSeconds() {
        return this.ttlSeconds;
    }

    public Long getExpiresAt() {
        return this.expiresAt;
    }

    private static class GBFeaturesRepositoryRequestInterceptor
    implements Interceptor {
        private GBFeaturesRepositoryRequestInterceptor() {
        }

        @NotNull
        public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
            Request modifiedRequest = chain.request().newBuilder().header("User-Agent", "growthbook-sdk-java/0.5.0").build();
            return chain.proceed(modifiedRequest);
        }
    }

    public static class GBFeaturesRepositoryBuilder {
        private String endpoint;
        private String encryptionKey;
        private Integer ttlSeconds;

        GBFeaturesRepositoryBuilder() {
        }

        public GBFeaturesRepositoryBuilder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public GBFeaturesRepositoryBuilder encryptionKey(@Nullable String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public GBFeaturesRepositoryBuilder ttlSeconds(@Nullable Integer ttlSeconds) {
            this.ttlSeconds = ttlSeconds;
            return this;
        }

        public GBFeaturesRepository build() {
            return new GBFeaturesRepository(this.endpoint, this.encryptionKey, this.ttlSeconds);
        }

        public String toString() {
            return "GBFeaturesRepository.GBFeaturesRepositoryBuilder(endpoint=" + this.endpoint + ", encryptionKey=" + this.encryptionKey + ", ttlSeconds=" + this.ttlSeconds + ")";
        }
    }
}

