/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java;

import com.google.gson.Gson;
import growthbook.sdk.java.BucketRange;
import growthbook.sdk.java.MathUtils;
import growthbook.sdk.java.Namespace;
import growthbook.sdk.java.UrlUtils;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;

class GrowthBookUtils {
    GrowthBookUtils() {
    }

    public static Float hash(String stringValue) {
        BigInteger bigInt = MathUtils.fnv1a_32(stringValue.getBytes());
        BigInteger thousand = new BigInteger("1000");
        BigInteger remainder = bigInt.remainder(thousand);
        String remainderAsString = remainder.toString();
        float remainderAsFloat = Float.parseFloat(remainderAsString);
        return Float.valueOf(remainderAsFloat / 1000.0f);
    }

    public static Boolean inNameSpace(String userId, Namespace namespace) {
        Float n = GrowthBookUtils.hash(userId + "__" + namespace.getId());
        return n.floatValue() >= namespace.getRangeStart().floatValue() && n.floatValue() < namespace.getRangeEnd().floatValue();
    }

    public static Integer chooseVariation(Float n, ArrayList<BucketRange> bucketRanges) {
        for (int i = 0; i < bucketRanges.size(); ++i) {
            BucketRange range = bucketRanges.get(i);
            if (!(n.floatValue() >= range.getRangeStart().floatValue()) || !(n.floatValue() < range.getRangeEnd().floatValue())) continue;
            return i;
        }
        return -1;
    }

    public static ArrayList<Float> getEqualWeights(Integer numberOfVariations) {
        int size = Math.max(0, numberOfVariations);
        if (size == 0) {
            return new ArrayList<Float>();
        }
        Float weight = Float.valueOf(1.0f / (float)numberOfVariations.intValue());
        return new ArrayList<Float>(Collections.nCopies(size, weight));
    }

    @Nullable
    public static Integer getQueryStringOverride(String id, String urlString, Integer numberOfVariations) {
        try {
            URL url = new URL(urlString);
            return GrowthBookUtils.getQueryStringOverride(id, url, numberOfVariations);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Nullable
    public static Integer getQueryStringOverride(String id, URL url, Integer numberOfVariations) {
        String query = url.getQuery();
        Map<String, String> queryMap = UrlUtils.parseQueryString(query);
        String possibleValue = queryMap.get(id);
        if (possibleValue == null) {
            return null;
        }
        try {
            int variationValue = Integer.parseInt(possibleValue);
            if (variationValue < 0 || variationValue >= numberOfVariations) {
                return null;
            }
            return variationValue;
        }
        catch (NumberFormatException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Nullable
    private static String getForcedFeatureRawValueForKeyFromUrl(String featureKey, URL url) {
        String prefixedKey = "gb~" + featureKey;
        Map<String, String> queryMap = UrlUtils.parseQueryString(url.getQuery());
        if (!queryMap.containsKey(prefixedKey)) {
            return null;
        }
        return queryMap.get(prefixedKey);
    }

    @Nullable
    public static Boolean getForcedBooleanValueFromUrl(String featureKey, URL url) {
        String value = GrowthBookUtils.getForcedFeatureRawValueForKeyFromUrl(featureKey, url);
        if (value == null) {
            return null;
        }
        if ((value = value.toLowerCase()).equals("true") || value.equals("1") || value.equals("on")) {
            return true;
        }
        if (value.equals("false") || value.equals("0") || value.equals("off")) {
            return false;
        }
        return null;
    }

    @Nullable
    public static String getForcedStringValueFromUrl(String featureKey, URL url) {
        return GrowthBookUtils.getForcedFeatureRawValueForKeyFromUrl(featureKey, url);
    }

    @Nullable
    public static Float getForcedFloatValueFromUrl(String featureKey, URL url) {
        String value = GrowthBookUtils.getForcedFeatureRawValueForKeyFromUrl(featureKey, url);
        if (value == null) {
            return null;
        }
        try {
            return Float.valueOf(Float.parseFloat(value));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static Double getForcedDoubleValueFromUrl(String featureKey, URL url) {
        String value = GrowthBookUtils.getForcedFeatureRawValueForKeyFromUrl(featureKey, url);
        if (value == null) {
            return null;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static Integer getForcedIntegerValueFromUrl(String featureKey, URL url) {
        String value = GrowthBookUtils.getForcedFeatureRawValueForKeyFromUrl(featureKey, url);
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static <ValueType> ValueType getForcedSerializableValueFromUrl(String featureKey, URL url, Class<ValueType> valueTypeClass, Gson gson) {
        String value = GrowthBookUtils.getForcedFeatureRawValueForKeyFromUrl(featureKey, url);
        if (value == null) {
            return null;
        }
        try {
            return (ValueType)gson.fromJson(value, valueTypeClass);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ArrayList<BucketRange> getBucketRanges(Integer numberOfVariations, Float coverage, @Nullable ArrayList<Float> weights) {
        float sumOfWeights;
        float clampedCoverage = MathUtils.clamp(coverage.floatValue(), 0.0f, 1.0f);
        ArrayList<Float> adjustedWeights = weights;
        if (weights == null || numberOfVariations.intValue() != weights.size()) {
            adjustedWeights = GrowthBookUtils.getEqualWeights(numberOfVariations);
        }
        if ((double)(sumOfWeights = MathUtils.sum(adjustedWeights)) < 0.99 || (double)sumOfWeights > 1.01) {
            adjustedWeights = GrowthBookUtils.getEqualWeights(numberOfVariations);
        }
        float start = 0.0f;
        float cumulative = 0.0f;
        ArrayList<BucketRange> bucketRanges = new ArrayList<BucketRange>();
        for (float weight : adjustedWeights) {
            start = cumulative;
            cumulative += weight;
            BucketRange bucketRange = BucketRange.builder().rangeStart(Float.valueOf(start)).rangeEnd(Float.valueOf(start + clampedCoverage * weight)).build();
            bucketRanges.add(bucketRange);
        }
        return bucketRanges;
    }
}

