/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import growthbook.sdk.java.FeatureRule;
import growthbook.sdk.java.GrowthBookJsonUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class Feature<ValueType> {
    @Nullable
    private final ArrayList<FeatureRule<ValueType>> rules;
    private final Object defaultValue;

    public Feature(String rawValue) {
        JsonObject featureJson = Feature.getFeatureJsonFromRawValue(rawValue);
        this.defaultValue = GrowthBookJsonUtils.unwrap(featureJson.get("defaultValue"));
        this.rules = Feature.getRulesFromFeatureJson(featureJson);
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Nullable
    public ArrayList<FeatureRule<ValueType>> getRules() {
        return this.rules;
    }

    private static JsonObject getFeatureJsonFromRawValue(String rawValue) {
        try {
            return (JsonObject)GrowthBookJsonUtils.getInstance().gson.fromJson(rawValue, JsonObject.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new JsonObject();
        }
    }

    private static <ValueType> ArrayList<FeatureRule<ValueType>> getRulesFromFeatureJson(JsonObject json) {
        try {
            Type featureRuleListType = new TypeToken<ArrayList<FeatureRule>>(){}.getType();
            JsonElement rulesJsonElement = json.get("rules");
            JsonArray rulesJson = rulesJsonElement != null ? rulesJsonElement.getAsJsonArray() : new JsonArray();
            return (ArrayList)GrowthBookJsonUtils.getInstance().gson.fromJson((JsonElement)rulesJson, featureRuleListType);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<FeatureRule<ValueType>>();
        }
    }
}

