/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Objects;
import org.apache.commons.math3.util.Precision;

public class BucketRange {
    private static final int BUCKET_RANGE_FLOAT_PRECISION = 3;
    Float rangeStart;
    Float rangeEnd;

    static BucketRange fromJson(JsonElement jsonElement) {
        JsonArray array = (JsonArray)jsonElement;
        float start = array.get(0).getAsFloat();
        float end = array.get(1).getAsFloat();
        return BucketRange.builder().rangeStart(Float.valueOf(Precision.round((float)start, (int)3))).rangeEnd(Float.valueOf(Precision.round((float)end, (int)3))).build();
    }

    public String toJson() {
        return BucketRange.getJson(this).toString();
    }

    public String toString() {
        return this.toJson();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BucketRange that = (BucketRange)o;
        return Objects.equals(Float.valueOf(Precision.round((float)this.rangeStart.floatValue(), (int)3)), Float.valueOf(Precision.round((float)that.rangeStart.floatValue(), (int)3))) && Objects.equals(Float.valueOf(Precision.round((float)this.rangeEnd.floatValue(), (int)3)), Float.valueOf(Precision.round((float)that.rangeEnd.floatValue(), (int)3)));
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(Precision.round((float)this.rangeStart.floatValue(), (int)3)), Float.valueOf(Precision.round((float)this.rangeEnd.floatValue(), (int)3)));
    }

    static JsonElement getJson(BucketRange object) {
        JsonArray array = new JsonArray();
        array.add((Number)Float.valueOf(Precision.round((float)object.rangeStart.floatValue(), (int)3)));
        array.add((Number)Float.valueOf(Precision.round((float)object.rangeEnd.floatValue(), (int)3)));
        return array;
    }

    public static JsonSerializer<BucketRange> getSerializer() {
        return new JsonSerializer<BucketRange>(){

            public JsonElement serialize(BucketRange src, Type typeOfSrc, JsonSerializationContext context) {
                return BucketRange.getJson(src);
            }
        };
    }

    public static JsonDeserializer<BucketRange> getDeserializer() {
        return new JsonDeserializer<BucketRange>(){

            public BucketRange deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return BucketRange.fromJson(json);
            }
        };
    }

    public static BucketRangeBuilder builder() {
        return new BucketRangeBuilder();
    }

    public Float getRangeStart() {
        return this.rangeStart;
    }

    public Float getRangeEnd() {
        return this.rangeEnd;
    }

    public void setRangeStart(Float rangeStart) {
        this.rangeStart = rangeStart;
    }

    public void setRangeEnd(Float rangeEnd) {
        this.rangeEnd = rangeEnd;
    }

    public BucketRange(Float rangeStart, Float rangeEnd) {
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
    }

    public static class BucketRangeBuilder {
        private Float rangeStart;
        private Float rangeEnd;

        BucketRangeBuilder() {
        }

        public BucketRangeBuilder rangeStart(Float rangeStart) {
            this.rangeStart = rangeStart;
            return this;
        }

        public BucketRangeBuilder rangeEnd(Float rangeEnd) {
            this.rangeEnd = rangeEnd;
            return this;
        }

        public BucketRange build() {
            return new BucketRange(this.rangeStart, this.rangeEnd);
        }

        public String toString() {
            return "BucketRange.BucketRangeBuilder(rangeStart=" + this.rangeStart + ", rangeEnd=" + this.rangeEnd + ")";
        }
    }
}

