/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import growthbook.sdk.java.model.BucketRange;
import growthbook.sdk.java.model.Feature;
import growthbook.sdk.java.model.FeatureRule;
import growthbook.sdk.java.model.Filter;
import growthbook.sdk.java.model.GBContext;
import growthbook.sdk.java.model.GeneratedStickyBucketAssignmentDocModel;
import growthbook.sdk.java.model.HashAttributeAndHashValue;
import growthbook.sdk.java.model.Namespace;
import growthbook.sdk.java.model.StickyAssignmentsDocument;
import growthbook.sdk.java.model.StickyBucketVariation;
import growthbook.sdk.java.model.VariationMeta;
import growthbook.sdk.java.multiusermode.configurations.EvaluationContext;
import growthbook.sdk.java.multiusermode.util.TransformationUtil;
import growthbook.sdk.java.stickyBucketing.StickyBucketService;
import growthbook.sdk.java.util.GrowthBookJsonUtils;
import growthbook.sdk.java.util.MathUtils;
import growthbook.sdk.java.util.UrlUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrowthBookUtils {
    private static final Logger log = LoggerFactory.getLogger(GrowthBookUtils.class);

    @Nullable
    public static Float hash(String stringValue, Integer hashVersion, String seed) {
        if (hashVersion == null) {
            return null;
        }
        switch (hashVersion) {
            case 1: {
                return GrowthBookUtils.hashV1(stringValue, seed);
            }
            case 2: {
                return GrowthBookUtils.hashV2(stringValue, seed);
            }
        }
        return null;
    }

    private static Float hashV1(String stringValue, String seed) {
        long hashValue = MathUtils.fnv1a_32((stringValue + seed).getBytes());
        long thousand = 1000L;
        long remainder = hashValue % thousand;
        float remainderAsFloat = Float.parseFloat(String.valueOf(remainder));
        return Float.valueOf(remainderAsFloat / 1000.0f);
    }

    private static Float hashV2(String stringValue, String seed) {
        long first = MathUtils.fnv1a_32((seed + stringValue).getBytes());
        long second = MathUtils.fnv1a_32(String.valueOf(first).getBytes());
        long tenThousand = 10000L;
        long remainder = second % tenThousand;
        float remainderAsFloat = Float.parseFloat(String.valueOf(remainder));
        return Float.valueOf(remainderAsFloat / 10000.0f);
    }

    public static Boolean inNameSpace(String userId, Namespace namespace) {
        Float n = GrowthBookUtils.hash(userId + "__", 1, namespace.getId());
        if (n == null) {
            return false;
        }
        return GrowthBookUtils.inRange(n, BucketRange.builder().rangeStart(namespace.getRangeStart()).rangeEnd(namespace.getRangeEnd()).build());
    }

    public static Integer chooseVariation(@NotNull Float n, ArrayList<BucketRange> bucketRanges) {
        for (int i = 0; i < bucketRanges.size(); ++i) {
            BucketRange range = bucketRanges.get(i);
            if (!GrowthBookUtils.inRange(n, range).booleanValue()) continue;
            return i;
        }
        return -1;
    }

    public static ArrayList<Float> getEqualWeights(Integer numberOfVariations) {
        int size = Math.max(0, numberOfVariations);
        if (size == 0) {
            return new ArrayList<Float>();
        }
        Float weight = Float.valueOf(1.0f / (float)numberOfVariations.intValue());
        return new ArrayList<Float>(Collections.nCopies(size, weight));
    }

    @Nullable
    public static Integer getQueryStringOverride(String id, String urlString, Integer numberOfVariations) {
        if (urlString == null || urlString.isEmpty()) {
            return null;
        }
        try {
            URL url = new URL(urlString);
            return GrowthBookUtils.getQueryStringOverride(id, url, numberOfVariations);
        }
        catch (MalformedURLException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static Integer getQueryStringOverride(String id, URL url, Integer numberOfVariations) {
        String query = url.getQuery();
        Map<String, String> queryMap = UrlUtils.parseQueryString(query);
        String possibleValue = queryMap.get(id);
        if (possibleValue == null) {
            return null;
        }
        try {
            int variationValue = Integer.parseInt(possibleValue);
            if (variationValue < 0 || variationValue >= numberOfVariations) {
                return null;
            }
            return variationValue;
        }
        catch (NumberFormatException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static String getForcedFeatureRawValueForKeyFromUrl(String featureKey, URL url) {
        String prefixedKey = "gb~" + featureKey;
        Map<String, String> queryMap = UrlUtils.parseQueryString(url.getQuery());
        if (!queryMap.containsKey(prefixedKey)) {
            return null;
        }
        return queryMap.get(prefixedKey);
    }

    @Nullable
    public static Boolean getForcedBooleanValueFromUrl(String featureKey, URL url) {
        String value = GrowthBookUtils.getForcedFeatureRawValueForKeyFromUrl(featureKey, url);
        if (value == null) {
            return null;
        }
        if ((value = value.toLowerCase()).equals("true") || value.equals("1") || value.equals("on")) {
            return true;
        }
        if (value.equals("false") || value.equals("0") || value.equals("off")) {
            return false;
        }
        return null;
    }

    @Nullable
    public static String getForcedStringValueFromUrl(String featureKey, URL url) {
        return GrowthBookUtils.getForcedFeatureRawValueForKeyFromUrl(featureKey, url);
    }

    @Nullable
    public static Float getForcedFloatValueFromUrl(String featureKey, URL url) {
        String value = GrowthBookUtils.getForcedFeatureRawValueForKeyFromUrl(featureKey, url);
        if (value == null) {
            return null;
        }
        try {
            return Float.valueOf(Float.parseFloat(value));
        }
        catch (NumberFormatException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static Double getForcedDoubleValueFromUrl(String featureKey, URL url) {
        String value = GrowthBookUtils.getForcedFeatureRawValueForKeyFromUrl(featureKey, url);
        if (value == null) {
            return null;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static Integer getForcedIntegerValueFromUrl(String featureKey, URL url) {
        String value = GrowthBookUtils.getForcedFeatureRawValueForKeyFromUrl(featureKey, url);
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static <ValueType> ValueType getForcedSerializableValueFromUrl(String featureKey, URL url, Class<ValueType> valueTypeClass, Gson gson) {
        String value = GrowthBookUtils.getForcedFeatureRawValueForKeyFromUrl(featureKey, url);
        if (value == null) {
            return null;
        }
        try {
            return (ValueType)gson.fromJson(value, valueTypeClass);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static ArrayList<BucketRange> getBucketRanges(Integer numberOfVariations, @NotNull Float coverage, @Nullable ArrayList<Float> weights) {
        float sumOfWeights;
        float clampedCoverage = MathUtils.clamp(coverage.floatValue(), 0.0f, 1.0f);
        ArrayList<Float> adjustedWeights = weights;
        if (weights == null || numberOfVariations.intValue() != weights.size()) {
            adjustedWeights = GrowthBookUtils.getEqualWeights(numberOfVariations);
        }
        if ((double)(sumOfWeights = MathUtils.sum(adjustedWeights)) < 0.99 || (double)sumOfWeights > 1.01) {
            adjustedWeights = GrowthBookUtils.getEqualWeights(numberOfVariations);
        }
        float cumulative = 0.0f;
        ArrayList<BucketRange> bucketRanges = new ArrayList<BucketRange>();
        for (float weight : adjustedWeights) {
            float start = cumulative;
            cumulative += weight;
            BucketRange bucketRange = BucketRange.builder().rangeStart(Float.valueOf(start)).rangeEnd(Float.valueOf(start + clampedCoverage * weight)).build();
            bucketRanges.add(bucketRange);
        }
        return bucketRanges;
    }

    public static Boolean inRange(Float n, BucketRange range) {
        if (n == null || range == null) {
            return false;
        }
        return n.floatValue() >= range.getRangeStart().floatValue() && n.floatValue() < range.getRangeEnd().floatValue();
    }

    public static Boolean isFilteredOut(List<Filter> filters, JsonObject attributes) {
        if (filters == null) {
            return false;
        }
        if (attributes == null) {
            return false;
        }
        return filters.stream().anyMatch(filter -> {
            Float n;
            JsonElement hashValueElement;
            String hashAttribute = filter.getAttribute();
            if (hashAttribute == null) {
                hashAttribute = "id";
            }
            if ((hashValueElement = attributes.get(hashAttribute)) == null) {
                return true;
            }
            if (hashValueElement.isJsonNull()) {
                return true;
            }
            if (!hashValueElement.isJsonPrimitive()) {
                return true;
            }
            JsonPrimitive hashValuePrimitive = hashValueElement.getAsJsonPrimitive();
            String hashValue = hashValuePrimitive.getAsString();
            if (hashValue == null || hashValue.isEmpty()) {
                return true;
            }
            Integer hashVersion = filter.getHashVersion();
            if (hashVersion == null) {
                hashVersion = 2;
            }
            if ((n = GrowthBookUtils.hash(hashValue, hashVersion, filter.getSeed())) == null) {
                return true;
            }
            List<BucketRange> ranges = filter.getRanges();
            if (ranges == null) {
                return true;
            }
            return ranges.stream().noneMatch(range -> GrowthBookUtils.inRange(n, range));
        });
    }

    public static Boolean isIncludedInRollout(JsonObject attributes, String seed, String hashAttribute, String fallbackAttribute, @Nullable BucketRange range, @Nullable Float coverage, @Nullable Integer hashVersion) {
        HashAttributeAndHashValue hashAttributeAndHashValue;
        Float hash;
        if (range == null && coverage == null) {
            return true;
        }
        if (range == null && coverage.floatValue() == 0.0f) {
            return false;
        }
        if (hashVersion == null) {
            hashVersion = 1;
        }
        if ((hash = GrowthBookUtils.hash((hashAttributeAndHashValue = GrowthBookUtils.getHashAttribute(hashAttribute, fallbackAttribute, attributes)).getHashValue(), hashVersion, seed)) == null) {
            return false;
        }
        if (range != null) {
            return GrowthBookUtils.inRange(hash, range);
        }
        return hash.floatValue() <= coverage.floatValue();
    }

    public static void refreshStickyBuckets(GBContext context, String featuresDataModel, JsonObject attributeOverrides) {
        StickyBucketService stickyBucketService = context.getStickyBucketService();
        if (stickyBucketService == null) {
            log.debug("refreshStickyBuckets: sticky bucket service not configured, skipping refresh.");
            return;
        }
        Map<String, String> stickyBucketAttributes = GrowthBookUtils.getStickyBucketAttributes(context, featuresDataModel, attributeOverrides);
        context.setStickyBucketAssignmentDocs(stickyBucketService.getAllAssignments(stickyBucketAttributes));
    }

    public static Map<String, String> getStickyBucketAttributes(GBContext context, String featuresDataModel, JsonObject attributeOverrides) {
        boolean shouldDerive;
        HashMap<String, String> attributes = new HashMap<String, String>();
        List<String> identifierAttributes = context.getStickyBucketIdentifierAttributes();
        if (identifierAttributes == null || identifierAttributes.isEmpty()) {
            return attributes;
        }
        String signature = Integer.toString(featuresDataModel == null ? context.getFeatures().hashCode() : featuresDataModel.hashCode());
        boolean bl = shouldDerive = !signature.equals(context.getStickyBucketIdentifierAttributesSignature());
        if (shouldDerive) {
            List<String> derived = GrowthBookUtils.deriveStickyBucketIdentifierAttributes(context, featuresDataModel);
            identifierAttributes = derived;
            context.setStickyBucketIdentifierAttributes(derived);
            context.setStickyBucketIdentifierAttributesSignature(signature);
        }
        for (String attr : identifierAttributes) {
            HashAttributeAndHashValue hashAttribute = GrowthBookUtils.getHashAttribute(attr, null, attributeOverrides);
            attributes.put(attr, hashAttribute.getHashValue());
        }
        return attributes;
    }

    private static <ValueType> List<String> deriveStickyBucketIdentifierAttributes(GBContext context, String featureDataModel) {
        String featuresStringJson;
        Map<String, Feature<?>> featuresMap;
        JsonObject jsonObject;
        HashSet<String> attributes = new HashSet<String>();
        Map<String, Feature<?>> features = context.getFeatures();
        if (featureDataModel != null && !featureDataModel.isEmpty() && (jsonObject = (JsonObject)GrowthBookJsonUtils.getInstance().gson.fromJson(featureDataModel, JsonObject.class)) != null && jsonObject.has("features") && jsonObject.get("features") != null && !(featuresMap = TransformationUtil.transformFeatures(featuresStringJson = jsonObject.get("features").toString().trim())).isEmpty()) {
            features = featuresMap;
        }
        if (features != null) {
            for (Map.Entry<String, Feature<?>> entry : features.entrySet()) {
                Feature<?> feature = entry.getValue();
                if (feature == null || feature.getRules() == null) continue;
                for (FeatureRule<?> rule : feature.getRules()) {
                    ArrayList<?> variations = rule.getVariations();
                    if (variations == null || variations.isEmpty()) continue;
                    String attr = rule.getHashAttribute() != null ? rule.getHashAttribute() : "id";
                    attributes.add(attr);
                    String fallbackAttribute = rule.getFallbackAttribute();
                    if (fallbackAttribute == null) continue;
                    attributes.add(fallbackAttribute);
                }
            }
        }
        return new ArrayList<String>(attributes);
    }

    public static Map<String, String> getStickyBucketAssignments(EvaluationContext context, @Nullable String expHashAttribute, @Nullable String expFallbackAttribute) {
        HashMap<String, String> mergedAssignments = new HashMap<String, String>();
        if (context.getUser().getStickyBucketAssignmentDocs() == null) {
            return mergedAssignments;
        }
        HashAttributeAndHashValue hashAttributeAndHashValueWithoutFallbackPass = GrowthBookUtils.getHashAttribute(expHashAttribute, null, context.getUser().getAttributes());
        String hashKey = hashAttributeAndHashValueWithoutFallbackPass.getHashAttribute() + "||" + hashAttributeAndHashValueWithoutFallbackPass.getHashValue();
        HashAttributeAndHashValue hashAttributeAndHashValueWithFallbackAttribute = GrowthBookUtils.getHashAttribute(null, expFallbackAttribute, context.getUser().getAttributes());
        String fallBackKey = hashAttributeAndHashValueWithFallbackAttribute.getHashValue().isEmpty() ? null : hashAttributeAndHashValueWithFallbackAttribute.getHashAttribute() + "||" + hashAttributeAndHashValueWithFallbackAttribute.getHashValue();
        Map<String, StickyAssignmentsDocument> stickyAssignmentsDocuments = context.getUser().getStickyBucketAssignmentDocs();
        if (context.getUser().getAttributes().get(expFallbackAttribute) != null) {
            String leftOperand;
            String string = leftOperand = stickyAssignmentsDocuments.get(expFallbackAttribute + "||" + context.getUser().getAttributes().get(expFallbackAttribute).getAsString()) == null ? null : stickyAssignmentsDocuments.get(expFallbackAttribute + "||" + context.getUser().getAttributes().get(expFallbackAttribute).getAsString()).getAttributeValue();
            if (!Objects.equals(leftOperand, context.getUser().getAttributes().get(expFallbackAttribute).getAsString())) {
                context.getUser().setStickyBucketAssignmentDocs(new HashMap<String, StickyAssignmentsDocument>());
            }
        }
        if (context.getUser().getStickyBucketAssignmentDocs() != null) {
            context.getUser().getStickyBucketAssignmentDocs().values().forEach(it -> mergedAssignments.putAll(it.getAssignments()));
        }
        if (fallBackKey != null && stickyAssignmentsDocuments.get(fallBackKey) != null) {
            mergedAssignments.putAll(stickyAssignmentsDocuments.get(fallBackKey).getAssignments());
        }
        if (stickyAssignmentsDocuments.get(hashKey) != null) {
            mergedAssignments.putAll(stickyAssignmentsDocuments.get(hashKey).getAssignments());
        }
        return mergedAssignments;
    }

    public static StickyBucketVariation getStickyBucketVariation(EvaluationContext context, String experimentKey, @Nullable String experimentHashAttribute, @Nullable String experimentFallbackAttribute, @Nullable Integer experimentBucketVersion, @Nullable Integer minExperimentBucketVersion, @Nullable List<VariationMeta> meta) {
        String variationKey;
        if (experimentBucketVersion == null) {
            experimentBucketVersion = 0;
        }
        if (minExperimentBucketVersion == null) {
            minExperimentBucketVersion = 0;
        }
        if (meta == null) {
            meta = new ArrayList<VariationMeta>();
        }
        String id = GrowthBookUtils.getStickyBucketExperimentKey(experimentKey, experimentBucketVersion);
        Map<String, String> assignments = GrowthBookUtils.getStickyBucketAssignments(context, experimentHashAttribute, experimentFallbackAttribute);
        if (minExperimentBucketVersion > 0) {
            for (int i = 0; i < minExperimentBucketVersion; ++i) {
                String blockedKey = GrowthBookUtils.getStickyBucketExperimentKey(experimentKey, i);
                if (!assignments.containsKey(blockedKey)) continue;
                return new StickyBucketVariation(-1, true);
            }
        }
        if ((variationKey = assignments.get(id)) == null) {
            return new StickyBucketVariation(-1, null);
        }
        int variationIndex = GrowthBookUtils.findVariationIndex(meta, variationKey);
        if (variationIndex != -1) {
            return new StickyBucketVariation(variationIndex, null);
        }
        return new StickyBucketVariation(-1, null);
    }

    public static String getStickyBucketExperimentKey(String experimentKey, @Nullable Integer experimentBucketVersion) {
        if (experimentBucketVersion == null) {
            experimentBucketVersion = 0;
        }
        return experimentKey + "__" + experimentBucketVersion;
    }

    public static GeneratedStickyBucketAssignmentDocModel generateStickyBucketAssignmentDoc(Map<String, StickyAssignmentsDocument> stickyBucketAssignmentDocs, String attributeName, String attributeValue, Map<String, String> assignments) {
        String key = attributeName + "||" + attributeValue;
        HashMap<String, String> existingAssignments = new HashMap();
        if (stickyBucketAssignmentDocs != null && stickyBucketAssignmentDocs.get(key) != null) {
            existingAssignments = stickyBucketAssignmentDocs.get(key).getAssignments();
        }
        boolean hasChanges = false;
        for (Map.Entry<String, String> entry : assignments.entrySet()) {
            if (Objects.equals(entry.getValue(), existingAssignments.get(entry.getKey()))) continue;
            hasChanges = true;
            break;
        }
        if (!hasChanges) {
            StickyAssignmentsDocument doc = new StickyAssignmentsDocument(attributeName, attributeValue, existingAssignments);
            return new GeneratedStickyBucketAssignmentDocModel(key, doc, false);
        }
        HashMap<String, String> newAssignments = new HashMap<String, String>(existingAssignments);
        newAssignments.putAll(assignments);
        StickyAssignmentsDocument stickyAssignmentsDocument = new StickyAssignmentsDocument(attributeName, attributeValue, newAssignments);
        return new GeneratedStickyBucketAssignmentDocModel(key, stickyAssignmentsDocument, true);
    }

    public static HashAttributeAndHashValue getHashAttribute(@Nullable String attr, @Nullable String fallbackAttribute, JsonObject attributes) {
        String hashAttribute = attr != null ? attr : "id";
        String hashValue = "";
        if (attributes.get(hashAttribute) != null && !attributes.get(hashAttribute).isJsonNull()) {
            hashValue = attributes.get(hashAttribute).getAsString();
        }
        if (hashValue.isEmpty() && fallbackAttribute != null) {
            if (attributes.get(fallbackAttribute) != null && !attributes.get(fallbackAttribute).isJsonNull()) {
                hashValue = attributes.get(fallbackAttribute).getAsString();
            }
            if (!hashValue.isEmpty()) {
                hashAttribute = fallbackAttribute;
            }
        }
        return new HashAttributeAndHashValue(hashAttribute, hashValue);
    }

    private static int findVariationIndex(List<VariationMeta> meta, String variationKey) {
        for (int i = 0; i < meta.size(); ++i) {
            if (meta.get(i).getKey() == null || !Objects.equals(meta.get(i).getKey(), variationKey)) continue;
            return i;
        }
        return -1;
    }

    public static <K, V> Map<K, V> mergeMaps(List<Map<K, V>> maps) {
        return maps.stream().filter(Objects::nonNull).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v2));
    }
}

