/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java.multiusermode.util;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import growthbook.sdk.java.model.Feature;
import growthbook.sdk.java.util.DecryptionUtils;
import growthbook.sdk.java.util.GrowthBookJsonUtils;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformationUtil {
    private static final Logger log = LoggerFactory.getLogger(TransformationUtil.class);
    private static final Gson GSON = GrowthBookJsonUtils.getInstance().gson;

    public static Map<String, Feature<?>> transformFeatures(String featuresJsonString) {
        if (featuresJsonString == null || featuresJsonString.isEmpty()) {
            return Collections.emptyMap();
        }
        try {
            Type featureMapType = new TypeToken<Map<String, Feature<?>>>(){}.getType();
            return (Map)GSON.fromJson(featuresJsonString, featureMapType);
        }
        catch (JsonSyntaxException e) {
            log.error("Invalid JSON format: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (Exception e) {
            log.error("Error parsing features JSON: {}", (Object)e.getMessage(), (Object)e);
        }
        return Collections.emptyMap();
    }

    public static JsonObject transformSavedGroups(String savedGroupsJsonString) {
        if (savedGroupsJsonString == null || savedGroupsJsonString.isEmpty()) {
            return new JsonObject();
        }
        try {
            return (JsonObject)GSON.fromJson(savedGroupsJsonString, JsonObject.class);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new JsonObject();
        }
    }

    public static Map<String, Feature<?>> transformEncryptedFeatures(@Nullable String featuresJson, @Nullable String encryptionKey) {
        if (encryptionKey != null && featuresJson != null) {
            try {
                String decrypted = DecryptionUtils.decrypt(featuresJson, encryptionKey);
                String featuresJsonDecrypted = decrypted.trim();
                return TransformationUtil.transformFeatures(featuresJsonDecrypted);
            }
            catch (DecryptionUtils.DecryptionException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        } else if (featuresJson != null) {
            return TransformationUtil.transformFeatures(featuresJson);
        }
        return Collections.emptyMap();
    }

    public static JsonObject transformAttributes(@Nullable String attributesJsonString) {
        try {
            if (attributesJsonString == null) {
                return new JsonObject();
            }
            JsonElement element = (JsonElement)GSON.fromJson(attributesJsonString, JsonElement.class);
            return element != null && element.isJsonObject() ? element.getAsJsonObject() : new JsonObject();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new JsonObject();
        }
    }
}

