/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java.multiusermode.configurations;

import com.google.gson.JsonObject;
import growthbook.sdk.java.model.StickyAssignmentsDocument;
import growthbook.sdk.java.multiusermode.util.TransformationUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserContext {
    private static final Logger log = LoggerFactory.getLogger(UserContext.class);
    @Nullable
    private JsonObject attributes;
    @Nullable
    private String url;
    @Nullable
    private Map<String, StickyAssignmentsDocument> stickyBucketAssignmentDocs;
    @Nullable
    private Map<String, Integer> forcedVariationsMap;
    @Nullable
    private Map<String, Object> forcedFeatureValues;
    @Nullable
    private String attributesJson;

    private UserContext(UserContextBuilder userContextBuilder) {
        this.attributes = userContextBuilder.attributes;
        this.url = userContextBuilder.url;
        this.stickyBucketAssignmentDocs = userContextBuilder.stickyBucketAssignmentDocs;
        this.forcedVariationsMap = userContextBuilder.forcedVariationsMap;
        this.forcedFeatureValues = userContextBuilder.forcedFeatureValues;
        this.attributesJson = userContextBuilder.attributesJson;
    }

    public UserContext witAttributesJson(String attributesJson) {
        return new UserContextBuilder().attributesJson(attributesJson).forcedVariationsMap(this.forcedVariationsMap).forcedFeatureValues(this.forcedFeatureValues).url(this.url).stickyBucketAssignmentDocs(this.stickyBucketAssignmentDocs).build();
    }

    public UserContext withAttributes(JsonObject attributes) {
        return new UserContextBuilder().attributes(attributes == null ? new JsonObject() : attributes).forcedVariationsMap(this.forcedVariationsMap).forcedFeatureValues(this.forcedFeatureValues).url(this.url).stickyBucketAssignmentDocs(this.stickyBucketAssignmentDocs).build();
    }

    public JsonObject getAttributes() {
        if (this.attributes == null) {
            return new JsonObject();
        }
        return this.attributes;
    }

    public Map<String, Integer> getForcedVariationsMap() {
        return this.forcedVariationsMap == null ? new HashMap() : this.forcedVariationsMap;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    @Nullable
    public Map<String, StickyAssignmentsDocument> getStickyBucketAssignmentDocs() {
        return this.stickyBucketAssignmentDocs;
    }

    @Nullable
    public Map<String, Object> getForcedFeatureValues() {
        return this.forcedFeatureValues;
    }

    @Nullable
    public String getAttributesJson() {
        return this.attributesJson;
    }

    public void setStickyBucketAssignmentDocs(@Nullable Map<String, StickyAssignmentsDocument> stickyBucketAssignmentDocs) {
        this.stickyBucketAssignmentDocs = stickyBucketAssignmentDocs;
    }

    public static class UserContextBuilder {
        @Nullable
        private JsonObject attributes;
        @Nullable
        private String url;
        @Nullable
        private Map<String, StickyAssignmentsDocument> stickyBucketAssignmentDocs;
        @Nullable
        private Map<String, Integer> forcedVariationsMap;
        @Nullable
        private Map<String, Object> forcedFeatureValues;
        @Nullable
        private String attributesJson;

        public UserContextBuilder attributesJson(String attributesJson) {
            this.attributesJson = attributesJson;
            if (this.attributes == null) {
                this.attributes = TransformationUtil.transformAttributes(attributesJson);
            }
            return this;
        }

        public UserContextBuilder attributes(JsonObject attributes) {
            this.attributes = attributes;
            return this;
        }

        public UserContextBuilder url(String url) {
            this.url = url;
            return this;
        }

        public UserContextBuilder stickyBucketAssignmentDocs(Map<String, StickyAssignmentsDocument> stickyBucketAssignmentDocs) {
            this.stickyBucketAssignmentDocs = stickyBucketAssignmentDocs;
            return this;
        }

        public UserContextBuilder forcedVariationsMap(Map<String, Integer> forcedVariationsMap) {
            this.forcedVariationsMap = forcedVariationsMap;
            return this;
        }

        public UserContextBuilder forcedFeatureValues(Map<String, Object> forcedFeatureValues) {
            this.forcedFeatureValues = forcedFeatureValues;
            return this;
        }

        public UserContext build() {
            return new UserContext(this);
        }
    }
}

