/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java.repository;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import growthbook.sdk.java.callback.FeatureRefreshCallback;
import growthbook.sdk.java.exception.FeatureFetchException;
import growthbook.sdk.java.model.Feature;
import growthbook.sdk.java.model.FeatureResponseKey;
import growthbook.sdk.java.model.HttpHeaders;
import growthbook.sdk.java.model.HttpMethods;
import growthbook.sdk.java.model.RequestBodyForRemoteEval;
import growthbook.sdk.java.model.SseKey;
import growthbook.sdk.java.multiusermode.util.TransformationUtil;
import growthbook.sdk.java.repository.FeatureRefreshStrategy;
import growthbook.sdk.java.repository.IGBFeaturesRepository;
import growthbook.sdk.java.sandbox.CacheManagerFactory;
import growthbook.sdk.java.sandbox.CacheMode;
import growthbook.sdk.java.sandbox.GbCacheManager;
import growthbook.sdk.java.util.DecryptionUtils;
import growthbook.sdk.java.util.GrowthBookJsonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeJavaGbFeatureRepository
implements IGBFeaturesRepository {
    private static final Logger log = LoggerFactory.getLogger(NativeJavaGbFeatureRepository.class);
    private static final String ENABLED = "enabled";
    private static final int QUANTITY_TO_CUT_SSE = 5;
    private static final String FILE_NAME_FOR_CACHE = "FEATURE_CACHE.json";
    public static final String FILE_PATH_FOR_CACHE = "src/main/resources";
    public static final String EMPTY_JSON_OBJECT_STRING = "{}";
    private final String featuresEndpoint;
    private final String remoteEvalEndPoint;
    private final String eventsEndpoint;
    private FeatureRefreshStrategy refreshStrategy;
    @Nullable
    private final String encryptionKey;
    private final AtomicBoolean sseAllowed = new AtomicBoolean(false);
    private final AtomicInteger swrTtlSeconds;
    private final AtomicLong expiresAt = new AtomicLong(0L);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final AtomicReference<String> savedGroupsJson = new AtomicReference<String>("{}");
    private final AtomicReference<String> featuresJson = new AtomicReference<String>("{}");
    private final CopyOnWriteArrayList<FeatureRefreshCallback> refreshCallbacks = new CopyOnWriteArrayList();
    private final ReentrantLock lock = new ReentrantLock(true);
    private AtomicReference<GbCacheManager> cacheManager;
    private final AtomicBoolean isCacheDisabled;
    @Nullable
    private final RequestBodyForRemoteEval requestBodyForRemoteEval;

    public NativeJavaGbFeatureRepository(@Nullable String apiHost, String clientKey, @Nullable String encryptionKey, @Nullable FeatureRefreshStrategy refreshStrategy, @Nullable Integer swrTtlSeconds, @Nullable Boolean isCacheDisabled, @Nullable RequestBodyForRemoteEval requestBodyForRemoteEval, @Nullable GbCacheManager cacheManager) {
        this.isCacheDisabled = new AtomicBoolean(Boolean.TRUE.equals(isCacheDisabled));
        if (clientKey == null) {
            throw new IllegalArgumentException("clientKey cannot be null");
        }
        if (apiHost == null) {
            apiHost = "https://cdn.growthbook.io";
        }
        this.refreshStrategy = refreshStrategy == null ? FeatureRefreshStrategy.STALE_WHILE_REVALIDATE : refreshStrategy;
        this.featuresEndpoint = apiHost + "/api/features/" + clientKey;
        this.eventsEndpoint = apiHost + "/sub/" + clientKey;
        this.remoteEvalEndPoint = apiHost + "/api/eval/" + clientKey;
        this.requestBodyForRemoteEval = requestBodyForRemoteEval;
        this.encryptionKey = encryptionKey;
        this.swrTtlSeconds = swrTtlSeconds == null ? new AtomicInteger(60) : new AtomicInteger(swrTtlSeconds);
        this.refreshExpiresAt();
        if (!this.isCacheDisabled.get()) {
            this.cacheManager = cacheManager != null ? new AtomicReference<GbCacheManager>(cacheManager) : new AtomicReference<GbCacheManager>(this.determineCacheManager());
        }
    }

    @Override
    public void initialize() throws FeatureFetchException {
        this.initialize(false);
    }

    @Nullable
    public String getSavedGroupsJson() {
        return this.savedGroupsJson.get();
    }

    @Override
    public void initialize(Boolean retryOnFailure) throws FeatureFetchException {
        try {
            this.lock.lock();
            if (this.initialized.get()) {
                return;
            }
            switch (this.refreshStrategy) {
                case STALE_WHILE_REVALIDATE: {
                    this.fetchFeatures();
                    break;
                }
                case SERVER_SENT_EVENTS: {
                    this.fetchFeatures();
                    this.initializeSSE(retryOnFailure);
                    break;
                }
                case REMOTE_EVAL_STRATEGY: {
                    this.fetchForRemoteEval(this.requestBodyForRemoteEval);
                }
            }
            this.initialized.set(true);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String getFeaturesJson() {
        try {
            this.lock.lock();
            if (this.refreshStrategy == FeatureRefreshStrategy.STALE_WHILE_REVALIDATE && this.isCacheExpired().booleanValue()) {
                this.enqueueFeatureRefreshRequest();
                this.refreshExpiresAt();
            }
            String string = this.featuresJson.get();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void enqueueFeatureRefreshRequest() {
        try {
            this.fetchFeatures();
        }
        catch (FeatureFetchException e) {
            log.error("FeatureFetchException occur with message - {}, Code is - {}", new Object[]{e.getMessage(), e.getErrorCode(), e});
        }
    }

    public Map<String, Feature<?>> getFeaturesMap() {
        try {
            this.lock.lock();
            if (this.refreshStrategy == FeatureRefreshStrategy.STALE_WHILE_REVALIDATE && this.isCacheExpired().booleanValue()) {
                this.enqueueFeatureRefreshRequest();
                this.refreshExpiresAt();
            }
            Map<String, Feature<?>> map = Optional.ofNullable(this.featuresJson.get()).map(TransformationUtil::transformFeatures).orElse(Collections.emptyMap());
            return map;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void onFeaturesRefresh(FeatureRefreshCallback callback) {
        this.refreshCallbacks.add(callback);
    }

    @Override
    public void clearCallbacks() {
        this.refreshCallbacks.clear();
    }

    private void refreshExpiresAt() {
        this.expiresAt.set(Instant.now().getEpochSecond() + (long)this.swrTtlSeconds.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchFeatures() throws FeatureFetchException {
        block18: {
            if (this.featuresEndpoint == null) {
                throw new IllegalArgumentException("features endpoint cannot be null");
            }
            HttpURLConnection connection = null;
            BufferedReader reader = null;
            try {
                URL url = new URL(this.featuresEndpoint);
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod(HttpMethods.GET.getMethod());
                if (connection.getResponseCode() == 200) {
                    String lines;
                    reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuilder responseBuilder = new StringBuilder();
                    while ((lines = reader.readLine()) != null) {
                        responseBuilder.append(lines);
                    }
                    reader.close();
                    String responseBody = responseBuilder.toString();
                    String sseSupportHeader = connection.getHeaderField(HttpHeaders.X_SSE_SUPPORT.getHeader());
                    if (sseSupportHeader == null) {
                        throw new FeatureFetchException(FeatureFetchException.FeatureFetchErrorCode.UNKNOWN);
                    }
                    this.sseAllowed.set(ENABLED.equals(sseSupportHeader));
                    this.onSuccess(responseBody, false);
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                if (!this.isCacheDisabled.get()) {
                    String cachedData = this.getCachedFeatures();
                    this.onResponseJson(cachedData, true);
                    break block18;
                }
                this.onRefreshFailed(e);
                throw new FeatureFetchException(FeatureFetchException.FeatureFetchErrorCode.UNKNOWN, e.getMessage());
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
    }

    private void onSuccess(String response, boolean isFromCache) throws FeatureFetchException {
        String responseJsonString;
        if (response != null) {
            responseJsonString = response;
        } else {
            log.error("FeatureFetchException: FeatureFetchErrorCode.NO_RESPONSE_ERROR");
            log.info("Fetching data from cache...");
            responseJsonString = this.getCachedFeatures();
            isFromCache = true;
        }
        this.onResponseJson(responseJsonString, isFromCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onResponseJson(String responseJsonString, boolean isFromCache) throws FeatureFetchException {
        try {
            this.lock.lock();
            if (responseJsonString == null || responseJsonString.trim().isEmpty()) {
                return;
            }
            if (!isFromCache && !this.isCacheDisabled.get() && this.cacheManager.get() != null) {
                try {
                    this.cacheManager.get().saveContent(FILE_NAME_FOR_CACHE, responseJsonString);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            try {
                String refreshedFeatures;
                JsonObject jsonObject = (JsonObject)GrowthBookJsonUtils.getInstance().gson.fromJson(responseJsonString, JsonObject.class);
                if (jsonObject == null) {
                    log.error("JSON response is null or invalid");
                    throw new FeatureFetchException(FeatureFetchException.FeatureFetchErrorCode.UNKNOWN, "JSON response is null or invalid");
                }
                String refreshedSavedGroups = "";
                if (this.encryptionKey != null) {
                    JsonElement encryptedFeaturesJsonElement = jsonObject.get(FeatureResponseKey.ENCRYPTED_FEATURES_KEY.getKey());
                    JsonElement encryptedSavedGroupsJsonElement = jsonObject.get(FeatureResponseKey.ENCRYPTED_SAVED_GROUPS_KEY.getKey());
                    if (encryptedFeaturesJsonElement == null) {
                        log.error("encryptionKey provided but endpoint not encrypted");
                        throw new FeatureFetchException(FeatureFetchException.FeatureFetchErrorCode.CONFIGURATION_ERROR, "encryptionKey provided but endpoint not encrypted");
                    }
                    if (encryptedSavedGroupsJsonElement != null) {
                        String encryptedSavedGroupsJson = encryptedSavedGroupsJsonElement.getAsString();
                        refreshedSavedGroups = DecryptionUtils.decrypt(encryptedSavedGroupsJson, this.encryptionKey).trim();
                    }
                    String encryptedFeaturesJson = encryptedFeaturesJsonElement.getAsString();
                    refreshedFeatures = DecryptionUtils.decrypt(encryptedFeaturesJson, this.encryptionKey).trim();
                } else {
                    JsonElement featuresJsonElement = jsonObject.get(FeatureResponseKey.FEATURE_KEY.getKey());
                    JsonElement savedGroupJsonElement = jsonObject.get(FeatureResponseKey.SAVED_GROUP_KEY.getKey());
                    if (featuresJsonElement == null) {
                        log.error("No features found");
                        throw new FeatureFetchException(FeatureFetchException.FeatureFetchErrorCode.CONFIGURATION_ERROR, "No features found");
                    }
                    refreshedFeatures = featuresJsonElement.toString().trim();
                    if (savedGroupJsonElement != null) {
                        refreshedSavedGroups = savedGroupJsonElement.toString().trim();
                    }
                }
                this.featuresJson.set(refreshedFeatures);
                this.savedGroupsJson.set(refreshedSavedGroups);
                this.onRefreshSuccess(this.featuresJson.get());
            }
            catch (DecryptionUtils.DecryptionException e) {
                log.error("DecryptionException exception occur, when try to parse: {}. {}", new Object[]{responseJsonString, e.getMessage(), e});
                throw new FeatureFetchException(FeatureFetchException.FeatureFetchErrorCode.UNKNOWN, e.getMessage());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void onRefreshSuccess(String featuresJson) {
        for (FeatureRefreshCallback callback : this.refreshCallbacks) {
            if (callback == null) continue;
            callback.onRefresh(featuresJson);
        }
    }

    public void onRefreshFailed(Throwable throwable) {
        for (FeatureRefreshCallback callback : this.refreshCallbacks) {
            if (callback == null) continue;
            callback.onError(throwable);
        }
    }

    private Boolean isCacheExpired() {
        long now = Instant.now().getEpochSecond();
        return now >= this.expiresAt.get();
    }

    private void initializeSSE(final Boolean retryOnFailure) {
        if (!this.sseAllowed.get()) {
            log.info("\nFalling back to stale-while-revalidate refresh strategy. 'X-Sse-Support: enabled' not present on resource returned at {}", (Object)this.featuresEndpoint);
            this.refreshStrategy = FeatureRefreshStrategy.STALE_WHILE_REVALIDATE;
        }
        Runnable sseTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedReader reader = null;
                HttpURLConnection connection = null;
                try {
                    String line;
                    connection = NativeJavaGbFeatureRepository.this.establishSseConnection(NativeJavaGbFeatureRepository.this.eventsEndpoint);
                    reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuilder dataBuffer = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        if (line.startsWith(SseKey.DATA.getKey())) {
                            dataBuffer.append(line.substring(5).trim()).append("\n");
                            continue;
                        }
                        if (!line.isEmpty()) continue;
                        String data = dataBuffer.toString();
                        if (!data.isEmpty()) {
                            NativeJavaGbFeatureRepository.this.onResponseJson(data, false);
                        }
                        dataBuffer.setLength(0);
                    }
                }
                catch (Exception e) {
                    log.error("Failed into SSE connection. Try to reconnect {}", (Object)e.getMessage(), (Object)e);
                    if (retryOnFailure.booleanValue()) {
                        this.run();
                    }
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        if (connection != null) {
                            connection.disconnect();
                        }
                    }
                    catch (IOException e) {
                        log.error("BufferedReader unsuccessfully closed: {}", (Object)e.getMessage(), (Object)e);
                    }
                }
            }
        };
        new Thread(sseTask).start();
    }

    private void fetchForRemoteEval(RequestBodyForRemoteEval requestBodyForRemoteEval) throws FeatureFetchException {
        HttpURLConnection urlConnection = null;
        try {
            String body = GrowthBookJsonUtils.getInstance().gson.toJson((Object)requestBodyForRemoteEval);
            URL url = new URL(this.remoteEvalEndPoint);
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.setDoOutput(true);
            urlConnection.setRequestProperty("Content-Type", "application/json");
            urlConnection.setRequestProperty("Accept", "application/json");
            try (OutputStream os = urlConnection.getOutputStream();){
                byte[] input = body.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            if (urlConnection.getResponseCode() == 200) {
                String inputLine;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                StringBuilder builder = new StringBuilder();
                while ((inputLine = bufferedReader.readLine()) != null) {
                    builder.append(inputLine);
                }
                bufferedReader.close();
                String jsonResponse = builder.toString();
                this.onSuccess(jsonResponse, false);
            } else {
                this.onRefreshFailed(new Throwable("Response is not success. Response code: " + urlConnection.getResponseCode() + ". Message: " + urlConnection.getResponseMessage()));
            }
        }
        catch (IOException e) {
            this.onRefreshFailed(e);
            log.error("Exception occur with message: {}", (Object)e.getMessage(), (Object)e);
            throw new FeatureFetchException(FeatureFetchException.FeatureFetchErrorCode.NO_RESPONSE_ERROR, e.getMessage());
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    private HttpURLConnection establishSseConnection(String sseEndPoint) throws FeatureFetchException {
        HttpURLConnection connection;
        try {
            URL url = new URL(sseEndPoint);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(HttpMethods.GET.getMethod());
            connection.setRequestProperty(HttpHeaders.ACCEPT.getHeader(), HttpHeaders.SSE_HEADER.getHeader());
            connection.setDoInput(true);
            connection.connect();
        }
        catch (IOException e) {
            log.error("Exception occur while establishing SSE connection: {}", (Object)e.getMessage(), (Object)e);
            throw new FeatureFetchException(FeatureFetchException.FeatureFetchErrorCode.SSE_CONNECTION_ERROR, e.getMessage());
        }
        return connection;
    }

    private String getCachedFeatures() throws FeatureFetchException {
        String cachedData;
        String string = cachedData = this.cacheManager.get() == null ? null : this.cacheManager.get().loadCache(FILE_NAME_FOR_CACHE);
        if (cachedData == null) {
            log.error("FeatureFetchException: No Features from Cache");
            throw new FeatureFetchException(FeatureFetchException.FeatureFetchErrorCode.NO_RESPONSE_ERROR);
        }
        return cachedData;
    }

    private GbCacheManager determineCacheManager() {
        try {
            return CacheManagerFactory.create(CacheMode.AUTO, null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static NativeJavaGbFeatureRepositoryBuilder builder() {
        return new NativeJavaGbFeatureRepositoryBuilder();
    }

    public String getFeaturesEndpoint() {
        return this.featuresEndpoint;
    }

    public String getRemoteEvalEndPoint() {
        return this.remoteEvalEndPoint;
    }

    public String getEventsEndpoint() {
        return this.eventsEndpoint;
    }

    public FeatureRefreshStrategy getRefreshStrategy() {
        return this.refreshStrategy;
    }

    @Nullable
    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public AtomicInteger getSwrTtlSeconds() {
        return this.swrTtlSeconds;
    }

    public AtomicLong getExpiresAt() {
        return this.expiresAt;
    }

    @Nullable
    public RequestBodyForRemoteEval getRequestBodyForRemoteEval() {
        return this.requestBodyForRemoteEval;
    }

    public static class NativeJavaGbFeatureRepositoryBuilder {
        private String apiHost;
        private String clientKey;
        private String encryptionKey;
        private FeatureRefreshStrategy refreshStrategy;
        private Integer swrTtlSeconds;
        private Boolean isCacheDisabled;
        private RequestBodyForRemoteEval requestBodyForRemoteEval;
        private GbCacheManager cacheManager;

        NativeJavaGbFeatureRepositoryBuilder() {
        }

        public NativeJavaGbFeatureRepositoryBuilder apiHost(@Nullable String apiHost) {
            this.apiHost = apiHost;
            return this;
        }

        public NativeJavaGbFeatureRepositoryBuilder clientKey(String clientKey) {
            this.clientKey = clientKey;
            return this;
        }

        public NativeJavaGbFeatureRepositoryBuilder encryptionKey(@Nullable String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public NativeJavaGbFeatureRepositoryBuilder refreshStrategy(@Nullable FeatureRefreshStrategy refreshStrategy) {
            this.refreshStrategy = refreshStrategy;
            return this;
        }

        public NativeJavaGbFeatureRepositoryBuilder swrTtlSeconds(@Nullable Integer swrTtlSeconds) {
            this.swrTtlSeconds = swrTtlSeconds;
            return this;
        }

        public NativeJavaGbFeatureRepositoryBuilder isCacheDisabled(@Nullable Boolean isCacheDisabled) {
            this.isCacheDisabled = isCacheDisabled;
            return this;
        }

        public NativeJavaGbFeatureRepositoryBuilder requestBodyForRemoteEval(@Nullable RequestBodyForRemoteEval requestBodyForRemoteEval) {
            this.requestBodyForRemoteEval = requestBodyForRemoteEval;
            return this;
        }

        public NativeJavaGbFeatureRepositoryBuilder cacheManager(@Nullable GbCacheManager cacheManager) {
            this.cacheManager = cacheManager;
            return this;
        }

        public NativeJavaGbFeatureRepository build() {
            return new NativeJavaGbFeatureRepository(this.apiHost, this.clientKey, this.encryptionKey, this.refreshStrategy, this.swrTtlSeconds, this.isCacheDisabled, this.requestBodyForRemoteEval, this.cacheManager);
        }

        public String toString() {
            return "NativeJavaGbFeatureRepository.NativeJavaGbFeatureRepositoryBuilder(apiHost=" + this.apiHost + ", clientKey=" + this.clientKey + ", encryptionKey=" + this.encryptionKey + ", refreshStrategy=" + (Object)((Object)this.refreshStrategy) + ", swrTtlSeconds=" + this.swrTtlSeconds + ", isCacheDisabled=" + this.isCacheDisabled + ", requestBodyForRemoteEval=" + this.requestBodyForRemoteEval + ", cacheManager=" + this.cacheManager + ")";
        }
    }
}

