/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java.stickyBucketing;

import growthbook.sdk.java.model.StickyAssignmentsDocument;
import growthbook.sdk.java.stickyBucketing.StickyBucketService;
import java.util.HashMap;
import java.util.Map;

public class InMemoryStickyBucketServiceImpl
implements StickyBucketService {
    private final Map<String, StickyAssignmentsDocument> localStorage;

    public InMemoryStickyBucketServiceImpl(Map<String, StickyAssignmentsDocument> localStorage) {
        this.localStorage = localStorage;
    }

    @Override
    public StickyAssignmentsDocument getAssignments(String attributeName, String attributeValue) {
        return this.localStorage.get(attributeName + "||" + attributeValue);
    }

    @Override
    public void saveAssignments(StickyAssignmentsDocument doc) {
        this.localStorage.put(doc.getAttributeName() + "||" + doc.getAttributeValue(), doc);
    }

    @Override
    public Map<String, StickyAssignmentsDocument> getAllAssignments(Map<String, String> attributes) {
        HashMap<String, StickyAssignmentsDocument> docs = new HashMap<String, StickyAssignmentsDocument>();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String value;
            String key = entry.getKey();
            StickyAssignmentsDocument doc = this.getAssignments(key, value = entry.getValue());
            if (doc == null) continue;
            String docKey = doc.getAttributeName() + "||" + doc.getAttributeValue();
            docs.put(docKey, doc);
        }
        return docs;
    }
}

