/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java.models;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import growthbook.sdk.java.internal.services.GrowthBookJsonUtils;
import growthbook.sdk.java.models.TrackingCallback;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class GBContext {
    @Nullable
    private JsonObject features;
    @Nullable
    private Boolean enabled;
    @Nullable
    private String url;
    private Boolean isQaMode;
    @Nullable
    private TrackingCallback trackingCallback;
    @Nullable
    private String attributesJson;
    @Nullable
    private JsonObject attributes;
    @Nullable
    private String featuresJson;
    @Nullable
    private Map<String, Integer> forcedVariationsMap;

    public static GBContext create(@Nullable String attributesJson, @Nullable String featuresJson, @Nullable Boolean isEnabled, Boolean isQaMode, @Nullable String url, @Nullable Map<String, Integer> forcedVariationsMap, @Nullable TrackingCallback trackingCallback) {
        return GBContext.builder().attributesJson(attributesJson).featuresJson(featuresJson).enabled(isEnabled).isQaMode(isQaMode).url(url).forcedVariationsMap(forcedVariationsMap).trackingCallback(trackingCallback).build();
    }

    private void setFeatures(@Nullable JsonObject features) {
        this.features = features;
    }

    public void setAttributesJson(String attributesJson) {
        this.attributesJson = attributesJson;
        if (attributesJson != null) {
            this.setAttributes(GBContext.transformAttributes(attributesJson));
        }
    }

    private void setAttributes(@Nullable JsonObject attributes) {
        this.attributes = attributes;
    }

    public void setFeaturesJson(String featuresJson) {
        this.featuresJson = featuresJson;
        if (featuresJson != null) {
            this.setFeatures(GBContext.transformFeatures(featuresJson));
        }
    }

    public static GBContextBuilder builder() {
        return new CustomGBContextBuilder();
    }

    @Nullable
    private static JsonObject transformFeatures(String featuresJsonString) {
        try {
            return (JsonObject)GrowthBookJsonUtils.getInstance().gson.fromJson(featuresJsonString, JsonObject.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static JsonObject transformAttributes(@Nullable String attributesJsonString) {
        try {
            if (attributesJsonString == null) {
                return new JsonObject();
            }
            JsonElement element = (JsonElement)GrowthBookJsonUtils.getInstance().gson.fromJson(attributesJsonString, JsonElement.class);
            if (element == null || element.isJsonNull()) {
                return new JsonObject();
            }
            return (JsonObject)GrowthBookJsonUtils.getInstance().gson.fromJson(attributesJsonString, JsonObject.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new JsonObject();
        }
    }

    private static Boolean $default$enabled() {
        return true;
    }

    private static Boolean $default$isQaMode() {
        return false;
    }

    private static String $default$attributesJson() {
        return "{}";
    }

    private static String $default$featuresJson() {
        return "{}";
    }

    private static Map<String, Integer> $default$forcedVariationsMap() {
        return new HashMap<String, Integer>();
    }

    GBContext(@Nullable JsonObject features, @Nullable Boolean enabled, @Nullable String url, Boolean isQaMode, @Nullable TrackingCallback trackingCallback, @Nullable String attributesJson, @Nullable JsonObject attributes, @Nullable String featuresJson, @Nullable Map<String, Integer> forcedVariationsMap) {
        this.features = features;
        this.enabled = enabled;
        this.url = url;
        this.isQaMode = isQaMode;
        this.trackingCallback = trackingCallback;
        this.attributesJson = attributesJson;
        this.attributes = attributes;
        this.featuresJson = featuresJson;
        this.forcedVariationsMap = forcedVariationsMap;
    }

    @Nullable
    public JsonObject getFeatures() {
        return this.features;
    }

    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    public Boolean getIsQaMode() {
        return this.isQaMode;
    }

    @Nullable
    public TrackingCallback getTrackingCallback() {
        return this.trackingCallback;
    }

    @Nullable
    public String getAttributesJson() {
        return this.attributesJson;
    }

    @Nullable
    public JsonObject getAttributes() {
        return this.attributes;
    }

    @Nullable
    public String getFeaturesJson() {
        return this.featuresJson;
    }

    @Nullable
    public Map<String, Integer> getForcedVariationsMap() {
        return this.forcedVariationsMap;
    }

    public void setEnabled(@Nullable Boolean enabled) {
        this.enabled = enabled;
    }

    public void setUrl(@Nullable String url) {
        this.url = url;
    }

    public void setIsQaMode(Boolean isQaMode) {
        this.isQaMode = isQaMode;
    }

    public void setTrackingCallback(@Nullable TrackingCallback trackingCallback) {
        this.trackingCallback = trackingCallback;
    }

    public void setForcedVariationsMap(@Nullable Map<String, Integer> forcedVariationsMap) {
        this.forcedVariationsMap = forcedVariationsMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GBContext)) {
            return false;
        }
        GBContext other = (GBContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$isQaMode = this.getIsQaMode();
        Boolean other$isQaMode = other.getIsQaMode();
        if (this$isQaMode == null ? other$isQaMode != null : !((Object)this$isQaMode).equals(other$isQaMode)) {
            return false;
        }
        JsonObject this$features = this.getFeatures();
        JsonObject other$features = other.getFeatures();
        if (this$features == null ? other$features != null : !this$features.equals(other$features)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        TrackingCallback this$trackingCallback = this.getTrackingCallback();
        TrackingCallback other$trackingCallback = other.getTrackingCallback();
        if (this$trackingCallback == null ? other$trackingCallback != null : !this$trackingCallback.equals(other$trackingCallback)) {
            return false;
        }
        String this$attributesJson = this.getAttributesJson();
        String other$attributesJson = other.getAttributesJson();
        if (this$attributesJson == null ? other$attributesJson != null : !this$attributesJson.equals(other$attributesJson)) {
            return false;
        }
        JsonObject this$attributes = this.getAttributes();
        JsonObject other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !this$attributes.equals(other$attributes)) {
            return false;
        }
        String this$featuresJson = this.getFeaturesJson();
        String other$featuresJson = other.getFeaturesJson();
        if (this$featuresJson == null ? other$featuresJson != null : !this$featuresJson.equals(other$featuresJson)) {
            return false;
        }
        Map<String, Integer> this$forcedVariationsMap = this.getForcedVariationsMap();
        Map<String, Integer> other$forcedVariationsMap = other.getForcedVariationsMap();
        return !(this$forcedVariationsMap == null ? other$forcedVariationsMap != null : !((Object)this$forcedVariationsMap).equals(other$forcedVariationsMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GBContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $isQaMode = this.getIsQaMode();
        result = result * 59 + ($isQaMode == null ? 43 : ((Object)$isQaMode).hashCode());
        JsonObject $features = this.getFeatures();
        result = result * 59 + ($features == null ? 43 : $features.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        TrackingCallback $trackingCallback = this.getTrackingCallback();
        result = result * 59 + ($trackingCallback == null ? 43 : $trackingCallback.hashCode());
        String $attributesJson = this.getAttributesJson();
        result = result * 59 + ($attributesJson == null ? 43 : $attributesJson.hashCode());
        JsonObject $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : $attributes.hashCode());
        String $featuresJson = this.getFeaturesJson();
        result = result * 59 + ($featuresJson == null ? 43 : $featuresJson.hashCode());
        Map<String, Integer> $forcedVariationsMap = this.getForcedVariationsMap();
        result = result * 59 + ($forcedVariationsMap == null ? 43 : ((Object)$forcedVariationsMap).hashCode());
        return result;
    }

    public String toString() {
        return "GBContext(features=" + this.getFeatures() + ", enabled=" + this.getEnabled() + ", url=" + this.getUrl() + ", isQaMode=" + this.getIsQaMode() + ", trackingCallback=" + this.getTrackingCallback() + ", attributesJson=" + this.getAttributesJson() + ", attributes=" + this.getAttributes() + ", featuresJson=" + this.getFeaturesJson() + ", forcedVariationsMap=" + this.getForcedVariationsMap() + ")";
    }

    public static class GBContextBuilder {
        private JsonObject features;
        private boolean enabled$set;
        private Boolean enabled$value;
        private String url;
        private boolean isQaMode$set;
        private Boolean isQaMode$value;
        private TrackingCallback trackingCallback;
        private boolean attributesJson$set;
        private String attributesJson$value;
        private JsonObject attributes;
        private boolean featuresJson$set;
        private String featuresJson$value;
        private boolean forcedVariationsMap$set;
        private Map<String, Integer> forcedVariationsMap$value;

        GBContextBuilder() {
        }

        public GBContextBuilder features(@Nullable JsonObject features) {
            this.features = features;
            return this;
        }

        public GBContextBuilder enabled(@Nullable Boolean enabled) {
            this.enabled$value = enabled;
            this.enabled$set = true;
            return this;
        }

        public GBContextBuilder url(@Nullable String url) {
            this.url = url;
            return this;
        }

        public GBContextBuilder isQaMode(Boolean isQaMode) {
            this.isQaMode$value = isQaMode;
            this.isQaMode$set = true;
            return this;
        }

        public GBContextBuilder trackingCallback(@Nullable TrackingCallback trackingCallback) {
            this.trackingCallback = trackingCallback;
            return this;
        }

        public GBContextBuilder attributesJson(@Nullable String attributesJson) {
            this.attributesJson$value = attributesJson;
            this.attributesJson$set = true;
            return this;
        }

        public GBContextBuilder attributes(@Nullable JsonObject attributes) {
            this.attributes = attributes;
            return this;
        }

        public GBContextBuilder featuresJson(@Nullable String featuresJson) {
            this.featuresJson$value = featuresJson;
            this.featuresJson$set = true;
            return this;
        }

        public GBContextBuilder forcedVariationsMap(@Nullable Map<String, Integer> forcedVariationsMap) {
            this.forcedVariationsMap$value = forcedVariationsMap;
            this.forcedVariationsMap$set = true;
            return this;
        }

        public GBContext build() {
            Boolean enabled$value = this.enabled$value;
            if (!this.enabled$set) {
                enabled$value = GBContext.$default$enabled();
            }
            Boolean isQaMode$value = this.isQaMode$value;
            if (!this.isQaMode$set) {
                isQaMode$value = GBContext.$default$isQaMode();
            }
            String attributesJson$value = this.attributesJson$value;
            if (!this.attributesJson$set) {
                attributesJson$value = GBContext.$default$attributesJson();
            }
            String featuresJson$value = this.featuresJson$value;
            if (!this.featuresJson$set) {
                featuresJson$value = GBContext.$default$featuresJson();
            }
            Map forcedVariationsMap$value = this.forcedVariationsMap$value;
            if (!this.forcedVariationsMap$set) {
                forcedVariationsMap$value = GBContext.$default$forcedVariationsMap();
            }
            return new GBContext(this.features, enabled$value, this.url, isQaMode$value, this.trackingCallback, attributesJson$value, this.attributes, featuresJson$value, forcedVariationsMap$value);
        }

        public String toString() {
            return "GBContext.GBContextBuilder(features=" + this.features + ", enabled$value=" + this.enabled$value + ", url=" + this.url + ", isQaMode$value=" + this.isQaMode$value + ", trackingCallback=" + this.trackingCallback + ", attributesJson$value=" + this.attributesJson$value + ", attributes=" + this.attributes + ", featuresJson$value=" + this.featuresJson$value + ", forcedVariationsMap$value=" + this.forcedVariationsMap$value + ")";
        }
    }

    static class CustomGBContextBuilder
    extends GBContextBuilder {
        CustomGBContextBuilder() {
        }

        @Override
        public GBContext build() {
            GBContext context = super.build();
            if (context.featuresJson != null) {
                context.setFeatures(GBContext.transformFeatures(context.featuresJson));
            }
            context.setAttributesJson(context.attributesJson);
            return context;
        }
    }
}

