/*
 * Decompiled with CFR 0.152.
 */
package asteroid.utils;

import asteroid.Expressions;
import asteroid.Statements;
import asteroid.Utils;
import asteroid.utils.StatementUtils;
import groovy.lang.Closure;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;

public class CheckUtils {
    public void addCheckTo(MethodNode methodNode) {
        BlockStatement blockStmt = Utils.NODE.getCodeBlock(methodNode);
        List<StatementUtils.Group> groups = Utils.STMT.groupStatementsByLabel(blockStmt);
        List<Statement> statements = Utils.STMT.applyToStatementsByLabelFlatten(groups, this.getMappings());
        if (!groups.isEmpty()) {
            methodNode.setCode((Statement)Statements.blockS(statements));
        }
    }

    private Map<String, Closure<Statement>> getMappings() {
        HashMap<String, Closure<Statement>> mappings = new HashMap<String, Closure<Statement>>();
        mappings.put("check", this.buildAssertionStmt());
        return mappings;
    }

    private Closure<Statement> buildAssertionStmt() {
        return new Closure<Statement>(null){

            public Statement doCall(StatementUtils.Group group, ExpressionStatement stmt) {
                return CheckUtils.this.createAssertStatement(group, stmt);
            }
        };
    }

    private Statement createAssertStatement(StatementUtils.Group group, ExpressionStatement stmt) {
        return Statements.assertS(Expressions.boolX(stmt.getExpression()), group.label.desc);
    }
}

