/*
 * Decompiled with CFR 0.152.
 */
package asteroid.statements;

import asteroid.A;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;

public class TryCatchStatementBuilder {
    private final List<CatchStatement> catchStatements = new ArrayList<CatchStatement>();
    private Statement tryStatement;
    private Statement finallyStatement;

    public TryCatchStatementBuilder tryStmt(Statement stmt) {
        this.tryStatement = stmt;
        return this;
    }

    public TryCatchStatementBuilder addCatchStmt(Class exceptionType, String exceptionVarName, Statement stmt) {
        return this.addCatchStmt(A.NODES.clazz(exceptionType).build(), exceptionVarName, stmt);
    }

    public TryCatchStatementBuilder addCatchStmt(ClassNode exceptionType, String exceptionVarName, Statement stmt) {
        Parameter param = A.NODES.param(exceptionVarName).type(exceptionType).build();
        CatchStatement catchStatement = new CatchStatement(param, stmt);
        this.catchStatements.add(catchStatement);
        return this;
    }

    public TryCatchStatementBuilder finallyStmt(Statement stmt) {
        this.finallyStatement = stmt;
        return this;
    }

    public TryCatchStatement build() {
        if (this.tryStatement == null || this.finallyStatement == null) {
            throw new IllegalStateException("Both try statement and finally statement must be provided");
        }
        TryCatchStatement tryCatchStmt = new TryCatchStatement(this.tryStatement, this.finallyStatement);
        if (!this.catchStatements.isEmpty()) {
            tryCatchStmt.getCatchStatements().addAll(this.catchStatements);
        }
        return tryCatchStmt;
    }
}

