/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.measure;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import org.graphstream.algorithm.Algorithm;
import org.graphstream.algorithm.DynamicAlgorithm;
import org.graphstream.algorithm.flow.EdmondsKarpAlgorithm;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.stream.Sink;
import org.graphstream.stream.SinkAdapter;

public class ConnectivityMeasure {
    public static int getVertexConnectivity(Graph g) {
        int previous;
        boolean isPreviousConnected;
        int current = Integer.MIN_VALUE;
        current = ((Node)g.nodes().max((x, y) -> Integer.compare(x.getDegree(), y.getDegree())).get()).getDegree();
        boolean isCurrentConnected = ConnectivityMeasure.isKVertexConnected(g, current);
        do {
            isPreviousConnected = isCurrentConnected;
            previous = current;
            current = isPreviousConnected ? previous + 1 : previous - 1;
            isCurrentConnected = ConnectivityMeasure.isKVertexConnected(g, current);
        } while ((!isPreviousConnected || isCurrentConnected || previous != current - 1) && (isPreviousConnected || !isCurrentConnected || previous != current + 1));
        if (!isPreviousConnected) {
            return current;
        }
        return previous;
    }

    public static int getEdgeConnectivity(Graph g) {
        int k = Integer.MAX_VALUE;
        EdmondsKarpAlgorithm flow = new EdmondsKarpAlgorithm();
        if (g.getNodeCount() < 2) {
            return 0;
        }
        for (int u = 0; u < g.getNodeCount() - 1; ++u) {
            for (int v = u + 1; v < g.getNodeCount(); ++v) {
                flow.init(g, g.getNode(u).getId(), g.getNode(v).getId());
                flow.setAllCapacities(1.0);
                flow.compute();
                k = Math.min(k, (int)flow.getMaximumFlow());
            }
        }
        return k;
    }

    public static boolean isKVertexConnected(Graph g, int k) {
        Node[] tuple = ConnectivityMeasure.getKDisconnectingNodeTuple(g, k - 1);
        return tuple == null;
    }

    public static boolean isKEdgeConnected(Graph g, int k) {
        Edge[] tuple = ConnectivityMeasure.getKDisconnectingEdgeTuple(g, k - 1);
        return tuple == null;
    }

    public static Node[] getKDisconnectingNodeTuple(Graph g, int k) {
        LinkedList<Integer> toVisit = new LinkedList<Integer>();
        boolean[] visited = new boolean[g.getNodeCount()];
        HashSet<Integer> removed = new HashSet<Integer>();
        KIndexesArray karray = new KIndexesArray(k, g.getNodeCount());
        if (k >= g.getNodeCount()) {
            return (Node[])g.nodes().toArray(Node[]::new);
        }
        do {
            int j;
            toVisit.clear();
            removed.clear();
            Arrays.fill(visited, false);
            for (j = 0; j < k; ++j) {
                removed.add(karray.get(j));
            }
            j = 0;
            while (toVisit.size() == 0) {
                if (!removed.contains(j)) {
                    toVisit.add(j);
                }
                ++j;
            }
            while (toVisit.size() > 0) {
                Node n = g.getNode(((Integer)toVisit.poll()).intValue());
                visited[n.getIndex()] = true;
                n.neighborNodes().forEach(o -> {
                    Integer index = o.getIndex();
                    if (!(visited[index] || toVisit.contains(index) || removed.contains(index))) {
                        toVisit.add(index);
                    }
                });
            }
            for (int i = 0; i < visited.length; ++i) {
                if (visited[i] || removed.contains(i)) continue;
                Node[] tuple = new Node[k];
                for (int j2 = 0; j2 < k; ++j2) {
                    tuple[j2] = g.getNode(karray.get(j2));
                }
                return tuple;
            }
        } while (karray.next());
        return null;
    }

    public static Edge[] getKDisconnectingEdgeTuple(Graph g, int k) {
        int i;
        LinkedList<Integer> toVisit = new LinkedList<Integer>();
        boolean[] visited = new boolean[g.getNodeCount()];
        HashSet<Integer> removed = new HashSet<Integer>();
        KIndexesArray karray = new KIndexesArray(k, g.getNodeCount());
        int minDegree = Integer.MAX_VALUE;
        Node nodeWithMinDegree = null;
        if (k >= g.getEdgeCount()) {
            return (Edge[])g.edges().toArray(Edge[]::new);
        }
        for (i = 0; i < g.getNodeCount(); ++i) {
            Node n = g.getNode(i);
            if (n.getDegree() >= minDegree) continue;
            minDegree = n.getDegree();
            nodeWithMinDegree = n;
        }
        if (k > minDegree) {
            Edge[] tuple = new Edge[minDegree];
            for (int i2 = 0; i2 < minDegree; ++i2) {
                tuple[i2] = nodeWithMinDegree.getEdge(i2);
            }
            return tuple;
        }
        do {
            toVisit.clear();
            removed.clear();
            Arrays.fill(visited, false);
            for (int j = 0; j < k; ++j) {
                removed.add(karray.get(j));
            }
            toVisit.add(0);
            while (toVisit.size() > 0) {
                Node n = g.getNode(((Integer)toVisit.poll()).intValue());
                visited[n.getIndex()] = true;
                n.edges().forEach(e -> {
                    Node o = e.getOpposite(n);
                    Integer index = o.getIndex();
                    if (!(visited[index] || toVisit.contains(index) || removed.contains(e.getIndex()))) {
                        toVisit.add(index);
                    }
                });
            }
            for (i = 0; i < visited.length; ++i) {
                if (visited[i]) continue;
                Edge[] tuple = new Edge[k];
                for (int j = 0; j < k; ++j) {
                    tuple[j] = g.getEdge(karray.get(j));
                }
                return tuple;
            }
        } while (karray.next());
        return null;
    }

    private static class StepTrigger
    extends SinkAdapter {
        Algorithm algo;

        StepTrigger(Algorithm algo) {
            this.algo = algo;
        }

        public void stepBegins(String sourceId, long timeId, double step) {
            this.algo.compute();
        }
    }

    public static class EdgeConnectivityMeasure
    implements DynamicAlgorithm {
        protected Graph g = null;
        protected int edgeConnectivity = -1;
        protected Sink trigger = new StepTrigger(this);

        public int getEdgeConnectivity() {
            return this.edgeConnectivity;
        }

        @Override
        public void compute() {
            this.edgeConnectivity = ConnectivityMeasure.getEdgeConnectivity(this.g);
        }

        @Override
        public void init(Graph graph) {
            this.g = graph;
            this.g.addSink(this.trigger);
        }

        @Override
        public void terminate() {
            this.g.removeSink(this.trigger);
        }
    }

    public static class VertexConnectivityMeasure
    implements DynamicAlgorithm {
        protected Graph g = null;
        protected int vertexConnectivity = -1;
        protected Sink trigger = new StepTrigger(this);

        public int getVertexConnectivity() {
            return this.vertexConnectivity;
        }

        @Override
        public void compute() {
            this.vertexConnectivity = ConnectivityMeasure.getVertexConnectivity(this.g);
        }

        @Override
        public void init(Graph graph) {
            this.g = graph;
            this.g.addSink(this.trigger);
        }

        @Override
        public void terminate() {
            this.g.removeSink(this.trigger);
        }
    }

    private static class KIndexesArray {
        final int[] data;
        final int k;
        final int n;

        public KIndexesArray(int k, int n) {
            this.k = k;
            this.n = n;
            this.data = new int[k];
            for (int i = 0; i < k; ++i) {
                this.data[i] = i;
            }
        }

        public boolean next() {
            int i;
            for (i = this.k - 1; i >= 0 && this.data[i] >= this.n - (this.k - 1 - i); --i) {
            }
            if (i >= 0) {
                int n = i;
                this.data[n] = this.data[n] + 1;
                for (int j = i + 1; j < this.k; ++j) {
                    this.data[j] = this.data[j - 1] + 1;
                }
                return true;
            }
            return false;
        }

        public int get(int i) {
            return this.data[i];
        }
    }
}

